/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.icard.common.auth;

import java.net.URI;
import java.security.cert.X509Certificate;
import javax.security.auth.callback.Callback;
import org.eclipse.higgins.icard.auth.ITSUsernamePasswordCredential;
import org.eclipse.higgins.icard.auth.ITokenServiceCredential;
import org.eclipse.higgins.icard.auth.IUsernamePasswordCredential;

public class TSUsernamePasswordCredential
implements ITSUsernamePasswordCredential {
    ITokenServiceCredential tsc;
    IUsernamePasswordCredential upc;

    public TSUsernamePasswordCredential(ITokenServiceCredential tsc, IUsernamePasswordCredential upc) {
        this.tsc = tsc;
        this.upc = upc;
    }

    public URI getAddress() {
        return this.tsc.getAddress();
    }

    public X509Certificate getCertificate() {
        return this.tsc.getCertificate();
    }

    public URI getMetadataAddress() {
        return this.tsc.getMetadataAddress();
    }

    public Callback[] getCallbacks() {
        Callback[] cts = this.tsc.getCallbacks();
        Callback[] cup = this.upc.getCallbacks();
        Callback[] c = new Callback[cts.length + cup.length];
        for (int i = 0; i < c.length; ++i) {
            c[i] = i < cts.length ? cts[i] : cup[i - cts.length];
        }
        return c;
    }

    public boolean isUsernamePredefined() {
        return this.upc.isUsernamePredefined();
    }

    public String getUsername() {
        return this.upc.getUsername();
    }

    public void setUsername(String username) {
        this.upc.setUsername(username);
    }

    public String getPassword() {
        return this.upc.getPassword();
    }

    public void setPassword(String password) {
        this.upc.setPassword(password);
    }
}

