/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.icard.common.auth;

import java.net.URI;
import java.security.cert.X509Certificate;
import javax.security.auth.callback.Callback;
import org.eclipse.higgins.icard.auth.ITSX509V3Credential;
import org.eclipse.higgins.icard.auth.ITokenServiceCredential;
import org.eclipse.higgins.icard.auth.IX509V3Credential;

public class TSX509V3Credential
implements ITSX509V3Credential {
    ITokenServiceCredential tsc;
    IX509V3Credential x509c;

    public TSX509V3Credential(ITokenServiceCredential tsc, IX509V3Credential x509c) {
        this.tsc = tsc;
        this.x509c = x509c;
    }

    public URI getAddress() {
        return this.tsc.getAddress();
    }

    public X509Certificate getCertificate() {
        return this.tsc.getCertificate();
    }

    public URI getMetadataAddress() {
        return this.tsc.getMetadataAddress();
    }

    public Callback[] getCallbacks() {
        Callback[] cts = this.tsc.getCallbacks();
        Callback[] cx509 = this.x509c.getCallbacks();
        Callback[] c = new Callback[cts.length + cx509.length];
        int i = 0;
        while (i < c.length) {
            c[i] = i < cts.length ? cts[i] : cx509[i - cts.length];
            ++i;
        }
        return c;
    }
}

