/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.icard.common.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.serializer.DOMSerializer;
import org.apache.xml.serializer.OutputPropertiesFactory;
import org.apache.xml.serializer.Serializer;
import org.apache.xml.serializer.SerializerFactory;
import org.eclipse.higgins.icard.common.io.IOElement;
import org.eclipse.higgins.icard.io.IElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLHelper {
    private static final Log log;
    public static final String IC_NS = "http://schemas.xmlsoap.org/ws/2005/05/identity";
    public static final String TRUST_NS = "http://schemas.xmlsoap.org/ws/2005/02/trust";
    public static final String WSA_NS = "http://www.w3.org/2005/08/addressing";
    public static final String MEX_NS = "http://schemas.xmlsoap.org/ws/2004/09/mex";
    public static final String WSAI_NS = "http://schemas.xmlsoap.org/ws/2006/02/addressingidentity";
    public static final String DSIG_NS = "http://www.w3.org/2000/09/xmldsig#";
    public static final String XE_NS = "http://www.w3.org/2001/04/xmlenc#";
    public static final String HI_NS = "http://www.eclipse.org/higgins/icard";
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.higgins.icard.common.utils.XMLHelper");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public static IElement toElement(OMElement omElement) throws Exception {
        IOElement element = new IOElement();
        element.set(omElement);
        return element;
    }

    public static IElement toElement(Element domElement) throws Exception {
        IOElement element = new IOElement();
        element.set(domElement);
        return element;
    }

    public static Element toDOM(OMElement omElement) throws Exception {
        if (omElement == null) {
            return null;
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            omElement.serialize((OutputStream)outputStream);
        }
        catch (Exception e) {
            log.error((Object)e);
            return null;
        }
        if (outputStream.size() == 0) {
            return null;
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document domDocument = documentBuilder.parse(inputStream);
        return domDocument.getDocumentElement();
    }

    public static String toString(OMElement omElement) throws Exception {
        if (omElement == null) {
            return null;
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        omElement.serialize((OutputStream)outputStream);
        String strElement = null;
        try {
            strElement = outputStream.toString("UTF-8");
            strElement = XMLHelper.StripNamespaceDeclaration(strElement);
        }
        catch (UnsupportedEncodingException uee) {
            log.error((Object)uee);
            throw uee;
        }
        return strElement;
    }

    public static String StripNamespaceDeclaration(String strElement) {
        boolean bNamespaceDeclaration = strElement.startsWith("<?xml");
        if (!bNamespaceDeclaration) {
            return strElement;
        }
        String strResult = strElement.substring(1);
        int nBegin = strResult.indexOf("<");
        return strResult.substring(nBegin);
    }

    public static OMElement toOM(Element domElement) throws Exception {
        if (domElement == null) {
            return null;
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        Properties prop = OutputPropertiesFactory.getDefaultMethodProperties((String)"xml");
        Serializer ser = SerializerFactory.getSerializer((Properties)prop);
        ser.setOutputFormat(prop);
        ser.setOutputStream((OutputStream)outputStream);
        DOMSerializer domSerializer = ser.asDOMSerializer();
        domSerializer.serialize((Node)domElement);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
        XMLInputFactory xif = XMLInputFactory.newInstance();
        XMLStreamReader reader = xif.createXMLStreamReader(inputStream);
        StAXOMBuilder builder = new StAXOMBuilder(reader);
        return builder.getDocumentElement();
    }

    public static String toString(Element domElement) throws IOException {
        if (domElement == null) {
            return null;
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        Properties prop = OutputPropertiesFactory.getDefaultMethodProperties((String)"xml");
        Serializer ser = SerializerFactory.getSerializer((Properties)prop);
        ser.setOutputFormat(prop);
        ser.setOutputStream((OutputStream)outputStream);
        DOMSerializer domSerializer = ser.asDOMSerializer();
        domSerializer.serialize((Node)domElement);
        String strElement = null;
        try {
            strElement = outputStream.toString("UTF-8");
            strElement = XMLHelper.StripNamespaceDeclaration(strElement);
        }
        catch (UnsupportedEncodingException uee) {
            log.error((Object)uee);
            throw uee;
        }
        return strElement;
    }

    public static void logElement(Element domElement) throws IOException {
        String strElement = XMLHelper.toString(domElement);
        log.trace((Object)strElement);
    }

    public static Element toDOM(String strElement) throws IOException, Exception {
        if (strElement == null) {
            return null;
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(strElement.getBytes());
        DocumentBuilder documentBuilder = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (Exception e) {
            log.error((Object)e);
            throw e;
        }
        Document docElement = null;
        try {
            docElement = documentBuilder.parse(inputStream);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw e;
        }
        return docElement.getDocumentElement();
    }

    public static Element domFromStream(InputStream inputStream) throws FileNotFoundException, Exception {
        DocumentBuilder documentBuilder = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (Exception e) {
            log.error((Object)e);
            throw e;
        }
        Document docElement = null;
        try {
            docElement = documentBuilder.parse(inputStream);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw e;
        }
        return docElement.getDocumentElement();
    }

    public static Element domFromFile(String strFileName) throws FileNotFoundException, Exception {
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(strFileName);
        }
        catch (FileNotFoundException fnfe) {
            log.error((Object)fnfe);
            throw fnfe;
        }
        return XMLHelper.domFromStream(inputStream);
    }

    public static OMElement omFromStream(InputStream inputStream) throws FileNotFoundException, Exception {
        XMLInputFactory xif = XMLInputFactory.newInstance();
        XMLStreamReader reader = xif.createXMLStreamReader(inputStream);
        StAXOMBuilder builder = new StAXOMBuilder(reader);
        return builder.getDocumentElement();
    }

    public static OMElement omFromFile(String strFileName) throws FileNotFoundException, Exception {
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(strFileName);
        }
        catch (FileNotFoundException fnfe) {
            log.error((Object)fnfe);
            throw fnfe;
        }
        return XMLHelper.omFromStream(inputStream);
    }

    public static OMElement toOM(String strElement) throws Exception {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(strElement.getBytes());
        XMLInputFactory xif = XMLInputFactory.newInstance();
        XMLStreamReader reader = xif.createXMLStreamReader(inputStream);
        StAXOMBuilder builder = new StAXOMBuilder(reader);
        return builder.getDocumentElement();
    }
}

