package org.eclipse.higgins.icard.common;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.security.auth.callback.CallbackHandler;

import org.eclipse.higgins.icard.CUID;
import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.icard.ICard;
import org.eclipse.higgins.icard.ICardProvider;
import org.eclipse.higgins.icard.IPolicy;
import org.eclipse.higgins.icard.io.IElement;
import org.eclipse.higgins.icard.io.IElementFormat;

public abstract class BasicCardProvider implements ICardProvider {

	public BasicCardProvider() {
		super();
	}

	public Iterator getICardsByFormat(CallbackHandler authHandler, IElementFormat format) throws CardException {
		List cards = new ArrayList();
		for (Iterator itr = getICards(authHandler); itr.hasNext(); ) {
			Object o = itr.next();
			if (o instanceof ICard) {
				ICard card = (ICard) o;
				if (card.isFormatSupported(format)) {
					cards.add(o);
				}
			}
		}
		return cards.iterator();
	}

	public Iterator getICardsByPolicy(CallbackHandler authHandler, IPolicy policy) throws CardException {
		List cards = new ArrayList();
		for (Iterator itr = getICards(authHandler); itr.hasNext(); ) {
			ICard card = (ICard) itr.next();
			if (policy == null) {
				cards.add(card);
			} else if (policy.isSatisfiedBy(card)) {
				cards.add(card);

			}
		}
		return cards.iterator();
	}

	public IElement[] exportICards(CallbackHandler authHandler, IElementFormat format, CUID[] cards) throws CardException {
		List res = new ArrayList();
		for (int i = 0; i < cards.length; i++) {
			ICard card = getICardByCUID(authHandler, cards[i]);
			if (card == null) {
				throw new CardException("Can't find card with CUID=\"" + cards[i] + "\"");
			}
			if (!card.isFormatSupported(format)) {
				throw new CardException("The card with CUID=\"" + cards[i] + "\" doesn't support required export format.");
			}
			IElement e = card.toElement(format);
			if (e == null) {
				throw new CardException("The card with CUID=\"" + cards[i] + "\" can't be converted to the required export format.");
			}
			res.add(e);
		}
		return (IElement[]) res.toArray(new IElement[res.size()]);
	}

}