/**
 * Copyright (c) 2007 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Sergey Lyakhov - initial API and implementation
 */
package org.eclipse.higgins.icard.common;

import org.eclipse.higgins.icard.ICardProvider;
import org.eclipse.higgins.icard.ICardTemplate;
import org.eclipse.higgins.icard.TUID;

public class CardTemplate extends TemplateContainer implements ICardTemplate {

	protected String providerID_;

	protected String providerName_;

	protected String providerDescription_;
	
	protected Class cardType_;
	
	/**
	 * @param id
	 * @param description
	 * @param displayName
	 * @param provider
	 */
	public CardTemplate(String id, String description, String displayName, ICardProvider provider, Class cardType) {
		super(id, description, displayName);
		setProviderDescription(provider.getDescription());
		setProviderID(provider.getID());
		setProviderName(provider.getName());
		cardType_ = cardType;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.icard.ICardTemplate#getProviderDescription()
	 */
	public String getProviderDescription() {
		return providerDescription_;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.icard.ICardTemplate#getProviderID()
	 */
	public String getProviderID() {
		return providerID_;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.icard.ICardTemplate#getProviderName()
	 */
	public String getProviderName() {
		return providerName_;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.icard.ICardTemplate#setProviderDescription(java.lang.String)
	 */
	public void setProviderDescription(String providerDescription) {
		providerDescription_ = providerDescription;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.icard.ICardTemplate#setProviderID(java.lang.String)
	 */
	public void setProviderID(String providerID) {
		providerID_ = providerID;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.icard.ICardTemplate#setProviderName(java.lang.String)
	 */
	public void setProviderName(String providerName) {
		providerName_ = providerName;
	}

	public Class getCardType() {
		return cardType_;
	}

	public TUID getTUID() {
		return new TUID(this.providerID_,this.id_);
	}
}
