/**
 * Copyright (c) 2007 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Sergey Lyakhov - initial API and implementation
 */

package org.eclipse.higgins.icard.common;

import java.net.URI;

import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.icard.ISimpleClaimType;
import org.eclipse.higgins.icard.IUIDescriptor;
import org.eclipse.higgins.icard.InvalidValueException;

public class ClaimType implements ISimpleClaimType {
	protected String type_;

	protected String name_;

	protected String description_;

	protected IUIDescriptor uiDescriptor_ = null;

	protected boolean editable_ = true;

	protected boolean visible_ = true;

	public ClaimType(URI type, String name, String description) throws CardException {
		if (type == null)
			throw new CardException("Parameter \"type\" is null.");
		type_ = type.toString();
		name_ = name;
		description_ = description;
	}

	public ClaimType(String type, String name, String description) throws CardException {
		if (type == null)
			throw new CardException("Parameter \"type\" is null.");
		type_ = type;
		name_ = name;
		description_ = description;
	}

	public ClaimType(String type, String name, String description, boolean editable, boolean visible) throws CardException {
		if (type == null)
			throw new CardException("Parameter \"type\" is null.");
		type_ = type;
		name_ = name;
		description_ = description;
		editable_ = editable;
		visible_ = visible;
	}

	private ClaimType() {
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.icard.IClaimType#getType()
	 */
	public String getType() {
		return type_;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.icard.IClaimType#getName()
	 */
	public String getDisplayName() {
		return name_;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.icard.IClaimType#getDescription()
	 */
	public String getDescription() {
		return description_;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.icard.IClaimType#getShortTypeName()
	 */
	public String getTypeLocalName() {
		return name_;
	}

	public Object clone() {
		ClaimType res = new ClaimType();
		res.type_ = type_;
		res.name_ = name_;
		res.description_ = description_;
		res.visible_ = visible_;
		res.editable_ = editable_;
		res.uiDescriptor_ = uiDescriptor_;
		return res;
	}

	public int getMaxCardinality() {
		return 1;
	}

	public Class getDataType() {
		return String.class;
	}

	public String toString(Object value) throws InvalidValueException {
		if (value == null) {
			throw new InvalidValueException("Value can not be null.");
		} else if (value instanceof String) {
			return (String) value;
		}
		throw new InvalidValueException("Value of type: " + value.getClass() + " is not supported.");
	}

	public Object fromString(String stringValue) throws InvalidValueException {
		if (stringValue == null) {
			throw new InvalidValueException("Value can not be null.");
		}
		return stringValue;
	}

	public boolean isSimple() {
		return true;
	}

	public void setUIDescriptor(IUIDescriptor descriptor) {
		uiDescriptor_ = descriptor;
	}

	public IUIDescriptor getUIDescriptor() {
		if (uiDescriptor_ == null) {
			uiDescriptor_ = UIDescriptor.createTextFieldDescriptor(null, null);
		}
		return uiDescriptor_;
	}

	public boolean isEditable() {
		return editable_;
	}

	public boolean isVisible() {
		return visible_;
	}

}
