/*******************************************************************************
 * Copyright (c) 2007-2008 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Valery Kokhan - Initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.icard.common.auth;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.icard.auth.ICredential;
import org.eclipse.higgins.icard.auth.ICredentialDescriptor;
import org.w3c.dom.Element;

public class BasicCredentialDescriptor implements ICredentialDescriptor {
	private Log log = LogFactory.getLog(BasicCredentialDescriptor.class);

	protected String type_;
	protected String displayCredentialHint_;
	protected ICredential credential_;
	protected Class credentialClass_;
	
	public BasicCredentialDescriptor(String type_, String displayCredentialHint_, ICredential credential_) {
		this.type_ = type_;
		this.displayCredentialHint_ = displayCredentialHint_;
		this.credential_ = credential_;
		this.credentialClass_ = null;
	}

	public BasicCredentialDescriptor(String type_, String displayCredentialHint_, Class credentialClass_) {
		this.type_ = type_;
		this.displayCredentialHint_ = displayCredentialHint_;
		this.credential_ = null;
		this.credentialClass_ = credentialClass_;
	}

	public Element asXML() {
		return null;
	}

	public ICredential getCredential() {
		if (credential_ != null) {
			return credential_;
		} else {
			return getCredentialFromClass();
		}
	}
	
	protected ICredential getCredentialFromClass() {
		ICredential res = null;
		if (credentialClass_ != null && ICredential.class.isAssignableFrom(credentialClass_)) {
			try {
				Object o = credentialClass_.newInstance();
				res = (ICredential) o;
			} catch (Throwable e) {
				res = null;
				log.trace("Error instantiate credential class: " + credentialClass_, e);
			}
		}
		return res;
	}

	public String getDisplayCredentialHint() {
		return displayCredentialHint_;
	}

	public String getType() {
		return type_;
	}

}
