/*******************************************************************************
 * Copyright (c) 2007 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Valery Kokhan - Initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.icard.common.auth;

import javax.security.auth.callback.Callback;

import org.eclipse.higgins.icard.auth.IPinCodeCredential;
import org.eclipse.higgins.icard.auth.ISelfIssuedCredential;
import org.eclipse.higgins.icard.common.auth.callback.PPIDCallback;

public class SelfIssuedCredential implements ISelfIssuedCredential {

	protected Callback[] callbacks = new Callback[1];
	protected PPIDCallback pc;
	protected IPinCodeCredential pcc;
	
	public SelfIssuedCredential(String ppid) {
		pc = new PPIDCallback(ppid);
		callbacks[0] = pc;
	}

	public String getPPID() {
		return pc.getPPID();
	}

	public Callback[] getCallbacks() {
		return callbacks;
	}

	public IPinCodeCredential getPinCodeCredential() {
		return pcc;
	}

	public void setPinCodeCredential(IPinCodeCredential pinCodeCredential) {
		pcc = pinCodeCredential;
	}
}
