/*******************************************************************************
 * Copyright (c) 2007 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Valery Kokhan - Initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.icard.common.auth;

import java.net.URI;
import java.security.cert.X509Certificate;

import javax.security.auth.callback.Callback;

import org.eclipse.higgins.icard.auth.ITSX509V3Credential;
import org.eclipse.higgins.icard.auth.ITokenServiceCredential;
import org.eclipse.higgins.icard.auth.IX509V3Credential;

public class TSX509V3Credential implements ITSX509V3Credential {
	ITokenServiceCredential tsc;
	IX509V3Credential x509c;

	public TSX509V3Credential(ITokenServiceCredential tsc, IX509V3Credential x509c) {
		this.tsc = tsc;
		this.x509c = x509c;
	}

	public URI getAddress() {
		return tsc.getAddress();
	}

	public X509Certificate getCertificate() {
		return tsc.getCertificate();
	}

	public URI getMetadataAddress() {
		return tsc.getMetadataAddress();
	}

	public Callback[] getCallbacks() {
		Callback[] cts = tsc.getCallbacks();
		Callback[] cx509 = x509c.getCallbacks();
		Callback[] c = new Callback[cts.length + cx509.length];
		for (int i = 0; i < c.length; i++) {
			if (i < cts.length) {
				c[i] = cts[i];
			} else {
				c[i] = cx509[i - cts.length];
			}
		}
		return c;
	}
}
