/*******************************************************************************
 * Copyright (c) 2007 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Valery Kokhan - Initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.icard.common.auth;

import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;

import org.eclipse.higgins.icard.auth.IUsernamePasswordCredential;

public class UsernamePasswordCredential implements IUsernamePasswordCredential {
	
	protected Callback[] callbacks = new Callback[2];
	
	public UsernamePasswordCredential(String username) {
		NameCallback nc = new NameCallback("Username", username);
		nc.setName(username);
		callbacks[0] = nc;
		callbacks[1] = new PasswordCallback("Password", false);
	}

	public Callback[] getCallbacks() {
		return callbacks;
	}

	public boolean isUsernamePredefined() {
		NameCallback nc = (NameCallback) callbacks[0];
		String name = nc.getName();
		String defName = nc.getDefaultName();
		if (defName != null && name != null && defName.length() > 0
				&& name.length() > 0 && name.equals(defName)) {
			return true;
		}
		return false;
	}

	public String getUsername() {
		NameCallback nc = (NameCallback) callbacks[0];
		return nc.getName();
	}

	public void setUsername(String username) {
		if (!isUsernamePredefined()) {
			NameCallback nc = (NameCallback) callbacks[0];
			nc.setName(username);
		} else {
			throw new IllegalStateException();
		}
	}

	public String getPassword() {
		PasswordCallback pc = (PasswordCallback) callbacks[1];
		return pc.getPassword() == null ? null : new String(pc.getPassword());
	}

	public void setPassword(String password) {
		PasswordCallback pc = (PasswordCallback) callbacks[1];
		pc.setPassword(password.toCharArray());
	}

}
