/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.icard.common.auth;

import java.net.URI;
import java.security.cert.X509Certificate;
import javax.security.auth.callback.Callback;
import org.eclipse.higgins.icard.auth.IPinCodeCredential;
import org.eclipse.higgins.icard.auth.ISelfIssuedCredential;
import org.eclipse.higgins.icard.auth.ITSSelfIssuedCredential;
import org.eclipse.higgins.icard.auth.ITokenServiceCredential;

public class TSSelfIssuedCredential
implements ITSSelfIssuedCredential {
    protected ITokenServiceCredential tsc;
    protected ISelfIssuedCredential sic;

    public TSSelfIssuedCredential(ITokenServiceCredential tsc, ISelfIssuedCredential sic) {
        this.tsc = tsc;
        this.sic = sic;
    }

    public URI getAddress() {
        return this.tsc.getAddress();
    }

    public X509Certificate getCertificate() {
        return this.tsc.getCertificate();
    }

    public URI getMetadataAddress() {
        return this.tsc.getMetadataAddress();
    }

    public Callback[] getCallbacks() {
        Callback[] cts = this.tsc.getCallbacks();
        Callback[] csi = this.sic.getCallbacks();
        Callback[] c = new Callback[cts.length + csi.length];
        for (int i = 0; i < c.length; ++i) {
            c[i] = i < cts.length ? cts[i] : csi[i - cts.length];
        }
        return c;
    }

    public String getPPID() {
        return this.sic.getPPID();
    }

    public IPinCodeCredential getPinCodeCredential() {
        return this.sic.getPinCodeCredential();
    }

    public void setPinCodeCredential(IPinCodeCredential pinCodeCredential) {
        this.sic.setPinCodeCredential(pinCodeCredential);
    }
}

