/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.icard.common.auth;

import java.net.URI;
import java.security.cert.X509Certificate;
import javax.security.auth.callback.Callback;
import org.eclipse.higgins.icard.IEndpointReference;
import org.eclipse.higgins.icard.auth.ICredential;
import org.eclipse.higgins.icard.auth.IKerberosV5Credential;
import org.eclipse.higgins.icard.auth.ISelfIssuedCredential;
import org.eclipse.higgins.icard.auth.ITSKerberosV5Credential;
import org.eclipse.higgins.icard.auth.ITSSelfIssuedCredential;
import org.eclipse.higgins.icard.auth.ITSUsernamePasswordCredential;
import org.eclipse.higgins.icard.auth.ITSX509V3Credential;
import org.eclipse.higgins.icard.auth.ITokenServiceCredential;
import org.eclipse.higgins.icard.auth.ITokenServiceCredentialFactory;
import org.eclipse.higgins.icard.auth.IUsernamePasswordCredential;
import org.eclipse.higgins.icard.auth.IX509V3Credential;
import org.eclipse.higgins.icard.common.auth.TSKerberosV5Credential;
import org.eclipse.higgins.icard.common.auth.TSSelfIssuedCredential;
import org.eclipse.higgins.icard.common.auth.TSUsernamePasswordCredential;
import org.eclipse.higgins.icard.common.auth.TSX509V3Credential;
import org.eclipse.higgins.icard.common.auth.callback.TokenServiceCallback;

public class TokenServiceCredential
implements ITokenServiceCredential,
ITokenServiceCredentialFactory {
    Callback[] callbacks = new Callback[1];
    TokenServiceCallback tc;

    public TokenServiceCredential(IEndpointReference er) {
        this(er.getAddress(), er.getCertificate(), er.getMetadataAddress());
    }

    public TokenServiceCredential(URI address, X509Certificate certificate, URI metadataAddress) {
        this.tc = new TokenServiceCallback(address, certificate, metadataAddress);
        this.callbacks[0] = this.tc;
    }

    public URI getAddress() {
        return this.tc.getAddress();
    }

    public X509Certificate getCertificate() {
        return this.tc.getCertificate();
    }

    public URI getMetadataAddress() {
        return this.tc.getMetadataAddress();
    }

    public Callback[] getCallbacks() {
        return this.callbacks;
    }

    public ITSUsernamePasswordCredential create(IUsernamePasswordCredential upc) {
        return new TSUsernamePasswordCredential(this, upc);
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof ITokenServiceCredential) {
            ITokenServiceCredential tsc = (ITokenServiceCredential)obj;
            try {
                return this.getAddress().equals(tsc.getAddress()) && this.getCertificate().equals(tsc.getCertificate()) && this.getMetadataAddress().equals(tsc.getMetadataAddress());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return super.equals(obj);
    }

    public ITokenServiceCredential createCredential(ICredential credential) {
        if (credential instanceof IUsernamePasswordCredential) {
            return this.createCredential((IUsernamePasswordCredential)credential);
        }
        if (credential instanceof ISelfIssuedCredential) {
            return this.createCredential((ISelfIssuedCredential)credential);
        }
        if (credential instanceof IKerberosV5Credential) {
            return this.createCredential((IKerberosV5Credential)credential);
        }
        if (credential instanceof IX509V3Credential) {
            return this.createCredential((IX509V3Credential)credential);
        }
        throw new IllegalArgumentException("Unsupported type of credential: " + credential);
    }

    protected ITSUsernamePasswordCredential createCredential(IUsernamePasswordCredential credential) {
        return new TSUsernamePasswordCredential(this, credential);
    }

    protected ITSSelfIssuedCredential createCredential(ISelfIssuedCredential credential) {
        return new TSSelfIssuedCredential(this, credential);
    }

    protected ITSKerberosV5Credential createCredential(IKerberosV5Credential credential) {
        return new TSKerberosV5Credential(this, credential);
    }

    protected ITSX509V3Credential createCredential(IX509V3Credential credential) {
        return new TSX509V3Credential(this, credential);
    }
}

