/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.icard.common.auth;

import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import org.eclipse.higgins.icard.auth.IUsernamePasswordCredential;

public class UsernamePasswordCredential
implements IUsernamePasswordCredential {
    protected Callback[] callbacks = new Callback[2];

    public UsernamePasswordCredential(String username) {
        NameCallback nc = new NameCallback("Username", username);
        nc.setName(username);
        this.callbacks[0] = nc;
        this.callbacks[1] = new PasswordCallback("Password", false);
    }

    public Callback[] getCallbacks() {
        return this.callbacks;
    }

    public boolean isUsernamePredefined() {
        NameCallback nc = (NameCallback)this.callbacks[0];
        String name = nc.getName();
        String defName = nc.getDefaultName();
        return defName != null && name != null && defName.length() > 0 && name.length() > 0 && name.equals(defName);
    }

    public String getUsername() {
        NameCallback nc = (NameCallback)this.callbacks[0];
        return nc.getName();
    }

    public void setUsername(String username) {
        if (this.isUsernamePredefined()) {
            throw new IllegalStateException();
        }
        NameCallback nc = (NameCallback)this.callbacks[0];
        nc.setName(username);
    }

    public String getPassword() {
        PasswordCallback pc = (PasswordCallback)this.callbacks[1];
        return pc.getPassword() == null ? null : new String(pc.getPassword());
    }

    public void setPassword(String password) {
        PasswordCallback pc = (PasswordCallback)this.callbacks[1];
        if (password != null) {
            pc.setPassword(password.toCharArray());
        } else {
            pc.setPassword(null);
        }
    }
}

