/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.icard.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.icard.ICard;
import org.eclipse.higgins.icard.IClaim;
import org.eclipse.higgins.icard.IClaimType;
import org.eclipse.higgins.icard.ISimpleClaim;
import org.eclipse.higgins.icard.ISimpleClaimType;
import org.eclipse.higgins.icard.InvalidStateException;
import org.eclipse.higgins.icard.InvalidTypeException;
import org.eclipse.higgins.icard.InvalidValueCountException;
import org.eclipse.higgins.icard.InvalidValueException;
import org.eclipse.higgins.icard.ReadOnlyObjectException;

public class ClaimValue
implements ISimpleClaim {
    protected ISimpleClaimType type_;
    protected ArrayList values_ = new ArrayList(1);
    protected ICard card_ = null;
    static /* synthetic */ Class class$0;

    public ClaimValue(IClaimType type, List values, ICard card) throws CardException {
        if (!(type instanceof ISimpleClaimType)) {
            throw new CardException("Parameter \"type\": " + type);
        }
        ISimpleClaimType stype = (ISimpleClaimType)type;
        if (stype.getMaxCardinality() != 1) {
            throw new InvalidTypeException("Invalid cardinality: type=" + stype.getType() + " cardinality=" + stype.getMaxCardinality());
        }
        Class clazz = stype.getDataType();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!clazz.isAssignableFrom(clazz2)) {
            throw new InvalidTypeException("Invalid data type class: type=" + stype.getType() + " dataType=" + stype.getDataType());
        }
        this.type_ = stype;
        this.setValues(values);
        this.card_ = card;
    }

    public ClaimValue(ISimpleClaimType type, String value) throws CardException {
        this(type, value, null);
    }

    public ClaimValue(ISimpleClaimType type, String value, ICard card) throws CardException {
        if (type == null) {
            throw new CardException("Parameter \"type\" is null.");
        }
        if (type.getMaxCardinality() != 1) {
            throw new InvalidTypeException("Invalid cardinality: type=" + type.getType() + " cardinality=" + type.getMaxCardinality());
        }
        Class clazz = type.getDataType();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!clazz.isAssignableFrom(clazz2)) {
            throw new InvalidTypeException("Invalid data type class: type=" + type.getType() + " dataType=" + type.getDataType());
        }
        this.card_ = card;
        this.type_ = type;
        this.setValue(value);
    }

    public IClaimType getType() {
        return this.type_;
    }

    public String getValue() {
        return (String)this.values_.get(0);
    }

    public String getTypeLocalName() {
        return this.getType().getTypeLocalName();
    }

    protected void setValue(String value) {
        if (value == null) {
            value = "";
        }
        if (this.values_.size() == 0) {
            this.values_.add(value);
        } else {
            this.values_.set(0, value);
        }
    }

    public List getValues() {
        return Collections.unmodifiableList(this.values_);
    }

    public void setValues(List newValues) throws InvalidValueException, InvalidStateException, ReadOnlyObjectException, InvalidValueCountException {
        if (this.card_ != null) {
            if (!this.card_.isEditable()) {
                throw new ReadOnlyObjectException();
            }
            if (!this.card_.isEditMode()) {
                throw new InvalidStateException();
            }
        }
        if (newValues.size() != 1) {
            throw new InvalidValueCountException();
        }
        Object o = newValues.get(0);
        if (!(o instanceof String)) {
            throw new InvalidValueException("Invalid value: " + o);
        }
        this.setValue((String)o);
        if (this.card_ != null) {
            try {
                this.card_.setClaim((IClaim)this);
            }
            catch (Exception e) {
                throw new InvalidStateException((Throwable)e);
            }
        }
    }
}

