/*******************************************************************************
 * Copyright (c) 2007-2008 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Valery Kokhan - Initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.icard.common.auth;

import javax.security.auth.callback.Callback;
import javax.security.auth.callback.PasswordCallback;

import org.eclipse.higgins.icard.auth.IPasswordCredential;

public class PasswordCredential implements IPasswordCredential {
	
	protected Callback[] callbacks = new Callback[1];
	
	public PasswordCredential() {
		callbacks[0] = new PasswordCallback("Password", false);
	}
	
	public PasswordCredential(String password) {
		this();
		setPassword(password);
	}

	public Callback[] getCallbacks() {
		return callbacks;
	}

	public String getPassword() {
		PasswordCallback pc = (PasswordCallback) callbacks[0];
		return pc.getPassword() == null ? null : new String(pc.getPassword());
	}

	public void setPassword(String password) {
		PasswordCallback pc = (PasswordCallback) callbacks[0];
		pc.setPassword(password.toCharArray());
	}

}
