/*******************************************************************************
 * Copyright (c) 2007 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Valery Kokhan - Initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.icard.common.auth;

import java.net.URI;
import java.security.cert.X509Certificate;

import javax.security.auth.callback.Callback;

import org.eclipse.higgins.icard.auth.IKerberosV5Credential;
import org.eclipse.higgins.icard.auth.ITSKerberosV5Credential;
import org.eclipse.higgins.icard.auth.ITokenServiceCredential;

public class TSKerberosV5Credential implements ITSKerberosV5Credential {
	ITokenServiceCredential tsc;
	IKerberosV5Credential kv5c;

	public TSKerberosV5Credential(ITokenServiceCredential tsc, IKerberosV5Credential kv5c) {
		this.tsc = tsc;
		this.kv5c = kv5c;
	}

	public URI getAddress() {
		return tsc.getAddress();
	}

	public X509Certificate getCertificate() {
		return tsc.getCertificate();
	}

	public URI getMetadataAddress() {
		return tsc.getMetadataAddress();
	}

	public Callback[] getCallbacks() {
		Callback[] cts = tsc.getCallbacks();
		Callback[] ckv5 = kv5c.getCallbacks();
		Callback[] c = new Callback[cts.length + ckv5.length];
		for (int i = 0; i < c.length; i++) {
			if (i < cts.length) {
				c[i] = cts[i];
			} else {
				c[i] = ckv5[i - cts.length];
			}
		}
		return c;
	}
}
