/*******************************************************************************
 * Copyright (c) 2007 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Valery Kokhan - Initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.icard.common.auth.callback;

import java.io.Serializable;
import java.net.URI;
import java.security.cert.X509Certificate;

import javax.security.auth.callback.Callback;

public class TokenServiceCallback implements Callback, Serializable {
	private static final long serialVersionUID = -1426964689132171061L;
	
	protected URI address;
	
	protected URI metadataAddress;
	
	protected X509Certificate certificate;

	public TokenServiceCallback(URI address, X509Certificate certificate, URI metadataAddress) {
		if (address == null) {
			throw new IllegalArgumentException("Argument /address/ is null.");
		}
//		if (certificate == null) {
//			throw new IllegalArgumentException("Argument /certificate/ is null.");
//		}
//		if (metadataAddress == null) {
//			throw new IllegalArgumentException("Argument /metadataAddress/ is null.");
//		}
		this.address = address;
		this.metadataAddress = metadataAddress;
		this.certificate = certificate;
	}

	public URI getAddress() {
		return address;
	}

	public URI getMetadataAddress() {
		return metadataAddress;
	}

	public X509Certificate getCertificate() {
		return certificate;
	}
}
