/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.icard.provider.cardspace.common;

import java.net.URI;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.icard.AuthenticationRequiredException;
import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.icard.IClaim;
import org.eclipse.higgins.icard.IClaimType;
import org.eclipse.higgins.icard.IEndpointReference;
import org.eclipse.higgins.icard.IManagedInformationCard;
import org.eclipse.higgins.icard.ITokenService;
import org.eclipse.higgins.icard.InvalidTypeException;
import org.eclipse.higgins.icard.auth.ICredentialDescriptor;
import org.eclipse.higgins.icard.common.ClaimType;
import org.eclipse.higgins.icard.provider.cardspace.common.CredentialDescriptor;
import org.eclipse.higgins.icard.provider.cardspace.common.EndpointReference;
import org.eclipse.higgins.icard.provider.cardspace.common.InformationCard;
import org.eclipse.higgins.icard.provider.cardspace.common.TSCredentialDescriptor;
import org.eclipse.higgins.icard.provider.cardspace.common.TokenService;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.CardCryptography;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.DateConvertor;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class ManagedCard
extends InformationCard
implements IManagedInformationCard {
    private Log log = LogFactory.getLog((Class)(class$org$eclipse$higgins$icard$provider$cardspace$common$ManagedCard == null ? (class$org$eclipse$higgins$icard$provider$cardspace$common$ManagedCard = ManagedCard.class$("org.eclipse.higgins.icard.provider.cardspace.common.ManagedCard")) : class$org$eclipse$higgins$icard$provider$cardspace$common$ManagedCard));
    protected List tokenServices_ = null;
    protected Boolean requireAppliesTo_ = null;
    protected Element privacyNotice_ = null;
    protected ICredentialDescriptor[] requiredCredentials_ = null;
    static /* synthetic */ Class class$org$eclipse$higgins$icard$provider$cardspace$common$ManagedCard;

    public List getTokenServices() {
        return this.tokenServices_;
    }

    public Boolean getRequireAppliesTo() {
        return this.requireAppliesTo_;
    }

    public Element getPrivacyNotice() {
        return this.privacyNotice_;
    }

    public void initFromXML(Element crd) throws CardException, DOMException {
        if (crd == null) {
            throw new CardException("Parameter card is null.");
        }
        this.isSelfIssued_ = false;
        Element cardMetaData = null;
        boolean isRoamingCard = false;
        if ("InformationCard".equals(crd.getLocalName())) {
            cardMetaData = crd;
        } else if ("RoamingInformationCard".equals(crd.getLocalName())) {
            cardMetaData = XMLUtils.getChildElement(crd, "http://schemas.xmlsoap.org/ws/2005/05/identity", "InformationCardMetaData");
            isRoamingCard = true;
        } else {
            throw new CardException("Couldn't import the card. Unexpected tag name: " + crd.getTagName());
        }
        if (cardMetaData == null) {
            throw new CardException("Couldn't import the card. Can not find ic:InformationCardMetaData element");
        }
        this.language_ = cardMetaData.hasAttribute("xml:lang") ? cardMetaData.getAttribute("xml:lang") : null;
        this.checkIsSelfIssued(cardMetaData);
        this.parseCardId(cardMetaData);
        this.parseCardVersion(cardMetaData);
        this.parseCardName(cardMetaData);
        this.parseCardImage(cardMetaData);
        this.parseIssuer(cardMetaData);
        this.parseIssuerName(cardMetaData);
        this.parseTimeIssued(cardMetaData);
        this.parseTimeExpires(cardMetaData);
        this.parseSupportedTokenTypes(cardMetaData);
        this.parseClaimTypes(cardMetaData);
        this.parseTokenServiceList(cardMetaData);
        this.parseRequireAppliesTo(cardMetaData);
        this.parsePrivacyNotice(cardMetaData);
        if (!isRoamingCard) {
            this.hashSalt_ = SecureRandom.getSeed(32);
            this.masterKey_ = SecureRandom.getSeed(32);
            this.timeLastUpdated_ = new Date();
        } else {
            this.parseHashSalt(cardMetaData);
            this.parseTimeLastUpdated(cardMetaData);
            this.parseMasterKey(crd);
        }
    }

    private void checkIsSelfIssued(Element card) throws CardException {
        String boolValue;
        Element isSelfIssuedElm = XMLUtils.getChildElement(card, "http://schemas.xmlsoap.org/ws/2005/05/identity", "IsSelfIssued");
        String string = boolValue = isSelfIssuedElm != null ? XMLUtils.getTextContent(isSelfIssuedElm) : "";
        if (!ManagedCard.isStringEmpty(boolValue) && "true".equals(boolValue.trim().toLowerCase())) {
            throw new CardException("Can not import self issued card.");
        }
    }

    private void parseCardId(Element card) throws CardException {
        String id = null;
        try {
            Element informationCardReference = XMLUtils.getChildElement(card, "http://schemas.xmlsoap.org/ws/2005/05/identity", "InformationCardReference");
            Element cardId = XMLUtils.getChildElement(informationCardReference, "http://schemas.xmlsoap.org/ws/2005/05/identity", "CardId");
            id = XMLUtils.getTextContent(cardId);
        }
        catch (Exception e) {
            this.log.error((Object)e);
        }
        if (ManagedCard.isStringEmpty(id)) {
            throw new CardException("Couldn't get CardId element from InfoCard.");
        }
        this.id_ = URI.create(id);
    }

    private void parseCardVersion(Element card) throws CardException {
        try {
            Element informationCardReference = XMLUtils.getChildElement(card, "http://schemas.xmlsoap.org/ws/2005/05/identity", "InformationCardReference");
            Element cardVersion = XMLUtils.getChildElement(informationCardReference, "http://schemas.xmlsoap.org/ws/2005/05/identity", "CardVersion");
            this.version_ = XMLUtils.getTextContent(cardVersion);
        }
        catch (Exception e) {
            this.log.error((Object)e);
        }
        if (ManagedCard.isStringEmpty(this.version_)) {
            throw new CardException("Couldn't get CardVersion element from InfoCard with id = " + this.id_);
        }
    }

    private void parseCardName(Element card) throws CardException {
        Element cardName = XMLUtils.getChildElement(card, "http://schemas.xmlsoap.org/ws/2005/05/identity", "CardName");
        this.name_ = cardName != null ? XMLUtils.getTextContent(cardName) : "";
    }

    private void parseCardImage(Element card) throws CardException, DOMException {
        Element cardImg = XMLUtils.getChildElement(card, "http://schemas.xmlsoap.org/ws/2005/05/identity", "CardImage");
        if (cardImg != null) {
            this.image_ = CardCryptography.decodeBase64(XMLUtils.getTextContent(cardImg));
            this.imageMimeType_ = cardImg.getAttribute("MimeType");
        }
    }

    private void parseIssuer(Element card) throws CardException {
        Element issuer = XMLUtils.getChildElement(card, "http://schemas.xmlsoap.org/ws/2005/05/identity", "Issuer");
        String string = this.issuer_ = issuer != null ? XMLUtils.getTextContent(issuer) : "";
        if (ManagedCard.isStringEmpty(this.issuer_)) {
            throw new CardException("Couldn't get Issuer element from InfoCard with id = " + this.id_);
        }
    }

    private void parseIssuerName(Element card) throws CardException {
        Element issuerName = XMLUtils.getChildElement(card, "http://schemas.xmlsoap.org/ws/2005/05/identity", "IssuerName");
        String string = this.issuerName_ = issuerName != null ? XMLUtils.getTextContent(issuerName) : "";
        if (ManagedCard.isStringEmpty(this.issuerName_)) {
            try {
                URI issuer = URI.create(this.issuer_);
                this.issuerName_ = issuer != null ? issuer.getHost().toString() : this.issuer_;
            }
            catch (Exception e) {
                this.issuerName_ = this.issuer_;
                this.log.error((Object)e);
            }
        }
    }

    private void parseTimeIssued(Element card) throws CardException {
        String timeIssued;
        Element timeIssuedElm = XMLUtils.getChildElement(card, "http://schemas.xmlsoap.org/ws/2005/05/identity", "TimeIssued");
        String string = timeIssued = timeIssuedElm != null ? XMLUtils.getTextContent(timeIssuedElm) : "";
        if (ManagedCard.isStringEmpty(timeIssued)) {
            throw new CardException("Couldn't get TimeIssued element from InfoCard with id = " + this.id_);
        }
        this.timeIssued_ = DateConvertor.parse(timeIssued);
    }

    private void parseTimeExpires(Element card) throws CardException {
        String timeExpires;
        Element timeExpiresElm = XMLUtils.getChildElement(card, "http://schemas.xmlsoap.org/ws/2005/05/identity", "TimeExpires");
        String string = timeExpires = timeExpiresElm != null ? XMLUtils.getTextContent(timeExpiresElm) : "";
        if (!ManagedCard.isStringEmpty(timeExpires)) {
            this.timeExpires_ = DateConvertor.parse(timeExpires);
        }
    }

    private void parseSupportedTokenTypes(Element card) throws CardException {
        this.supportedTokenTypes_ = new ArrayList();
        Element supportedTokenTypeList = XMLUtils.getChildElement(card, "http://schemas.xmlsoap.org/ws/2005/05/identity", "SupportedTokenTypeList");
        if (supportedTokenTypeList == null) {
            throw new CardException("Couldn't get \"SupportedTokenTypeList\" element from InfoCard with id = " + this.id_);
        }
        NodeList tokenTypes = supportedTokenTypeList.getChildNodes();
        int len = tokenTypes.getLength();
        for (int i = 0; i < len; ++i) {
            Node nd = tokenTypes.item(i);
            if (nd.getNodeType() != 1 || !"TokenType".equals(nd.getLocalName()) || !"http://schemas.xmlsoap.org/ws/2005/02/trust".equals(nd.getNamespaceURI())) continue;
            Element elm = (Element)nd;
            this.supportedTokenTypes_.add(URI.create(XMLUtils.getTextContent(elm)));
        }
        if (this.supportedTokenTypes_.size() == 0) {
            throw new CardException("Couldn't get the list of TokenType elements from InfoCard with id = " + this.id_);
        }
    }

    private void parseClaimTypes(Element card) throws CardException {
        this.claimTypes_ = new ArrayList();
        Element supportedClaimTypeList = XMLUtils.getChildElement(card, "http://schemas.xmlsoap.org/ws/2005/05/identity", "SupportedClaimTypeList");
        if (supportedClaimTypeList == null) {
            throw new CardException("Couldn't get \"SupportedClaimTypeList\" element from InfoCard with id = " + this.id_);
        }
        NodeList claimTypes = supportedClaimTypeList.getChildNodes();
        int len = claimTypes.getLength();
        for (int i = 0; i < len; ++i) {
            Node node = claimTypes.item(i);
            if (node.getNodeType() != 1 || !"SupportedClaimType".equals(node.getLocalName()) || !"http://schemas.xmlsoap.org/ws/2005/05/identity".equals(node.getNamespaceURI())) continue;
            Element elm = (Element)node;
            String uri = elm.getAttribute("Uri");
            if (ManagedCard.isStringEmpty(uri)) {
                throw new CardException("Couldn't get \"uri\" attribute of SupportedClaimType element for InfoCard with id = " + this.id_);
            }
            Element displayTagElm = XMLUtils.getChildElement(elm, "http://schemas.xmlsoap.org/ws/2005/05/identity", "DisplayTag");
            String displayTag = displayTagElm != null ? XMLUtils.getTextContent(displayTagElm) : "";
            Element descriptionElm = XMLUtils.getChildElement(elm, "http://schemas.xmlsoap.org/ws/2005/05/identity", "Description");
            String description = descriptionElm != null ? XMLUtils.getTextContent(descriptionElm) : "";
            this.claimTypes_.add(new ClaimType(uri, displayTag, description));
        }
    }

    private EndpointReference parseEndpointReference(Element endpointRef) throws CardException {
        Element addressElm = XMLUtils.getChildElement(endpointRef, "http://www.w3.org/2005/08/addressing", "Address");
        String addressStr = addressElm != null ? XMLUtils.getTextContent(addressElm) : "";
        URI address = addressStr != null ? URI.create(addressStr) : null;
        Element metadata = XMLUtils.getChildElement(endpointRef, "http://www.w3.org/2005/08/addressing", "Metadata");
        Element identity = XMLUtils.getChildElement(endpointRef, "http://schemas.xmlsoap.org/ws/2006/02/addressingidentity", "Identity");
        return new EndpointReference(address, metadata, identity);
    }

    private CredentialDescriptor parseUserCredential(Element credential) throws CardException {
        Element hintElm = XMLUtils.getChildElement(credential, "http://schemas.xmlsoap.org/ws/2005/05/identity", "DisplayCredentialHint");
        String hint = hintElm != null ? XMLUtils.getTextContent(hintElm) : "";
        return new CredentialDescriptor(hint, credential);
    }

    private void parseTokenServiceList(Element card) throws CardException {
        this.tokenServices_ = new ArrayList();
        Element tokenServiceList = XMLUtils.getChildElement(card, "http://schemas.xmlsoap.org/ws/2005/05/identity", "TokenServiceList");
        if (tokenServiceList == null) {
            throw new CardException("Couldn't get \"TokenServiceList\" element from InfoCard with id = " + this.id_);
        }
        NodeList tokenServices = tokenServiceList.getChildNodes();
        int len = tokenServices.getLength();
        for (int i = 0; i < len; ++i) {
            Node node = tokenServices.item(i);
            if (node.getNodeType() != 1 || !"TokenService".equals(node.getLocalName()) || !"http://schemas.xmlsoap.org/ws/2005/05/identity".equals(node.getNamespaceURI())) continue;
            Element elm = (Element)node;
            Element endpointRef = XMLUtils.getChildElement(elm, "http://www.w3.org/2005/08/addressing", "EndpointReference");
            if (endpointRef == null) {
                throw new CardException("Couldn't get wsa:EndpointReference element");
            }
            EndpointReference epRef = this.parseEndpointReference(endpointRef);
            Element credential = XMLUtils.getChildElement(elm, "http://schemas.xmlsoap.org/ws/2005/05/identity", "UserCredential");
            if (credential == null) {
                throw new CardException("Couldn't get ic:UserCredential element");
            }
            CredentialDescriptor userCredential = this.parseUserCredential(credential);
            this.tokenServices_.add(new TokenService(epRef, userCredential));
        }
        if (this.tokenServices_.size() == 0) {
            throw new CardException("Couldn't get list of TokenService elements from InfoCard with id = " + this.id_);
        }
    }

    private void parseRequireAppliesTo(Element card) throws CardException {
        Element requireAppliesTo = XMLUtils.getChildElement(card, "http://schemas.xmlsoap.org/ws/2005/05/identity", "RequireAppliesTo");
        String str = requireAppliesTo != null ? XMLUtils.getTextContent(requireAppliesTo) : "";
        this.requireAppliesTo_ = null;
        if (!ManagedCard.isStringEmpty(str)) {
            if (str.equalsIgnoreCase("false")) {
                this.requireAppliesTo_ = new Boolean(false);
            } else if (str.equalsIgnoreCase("true")) {
                this.requireAppliesTo_ = new Boolean(true);
            }
        }
    }

    private void parsePrivacyNotice(Element card) throws CardException {
        this.privacyNotice_ = XMLUtils.getChildElement(card, "http://schemas.xmlsoap.org/ws/2005/05/identity", "PrivacyNotice");
    }

    private void parseHashSalt(Element card) throws CardException {
        String str;
        Element hashSalt = XMLUtils.getChildElement(card, "http://schemas.xmlsoap.org/ws/2005/05/identity", "HashSalt");
        String string = str = hashSalt != null ? XMLUtils.getTextContent(hashSalt) : "";
        if (ManagedCard.isStringEmpty(str)) {
            throw new CardException("Couldn't get HashSalt element from InfoCard with id = " + this.id_);
        }
        this.hashSalt_ = CardCryptography.decodeBase64(str);
    }

    private void parseTimeLastUpdated(Element card) throws CardException {
        String str;
        Element timeLastUpdated = XMLUtils.getChildElement(card, "http://schemas.xmlsoap.org/ws/2005/05/identity", "TimeLastUpdated");
        String string = str = timeLastUpdated != null ? XMLUtils.getTextContent(timeLastUpdated) : "";
        if (ManagedCard.isStringEmpty(str)) {
            throw new CardException("Couldn't get TimeLastUpdated element from InfoCard with id = " + this.id_);
        }
        this.timeLastUpdated_ = DateConvertor.parse(str);
    }

    private void parseMasterKey(Element roamingCard) throws CardException {
        String str;
        Element informationCardPrivateData = XMLUtils.getChildElement(roamingCard, "http://schemas.xmlsoap.org/ws/2005/05/identity", "InformationCardPrivateData");
        if (informationCardPrivateData != null) {
            Element masterKey = XMLUtils.getChildElement(informationCardPrivateData, "http://schemas.xmlsoap.org/ws/2005/05/identity", "MasterKey");
            String string = str = masterKey != null ? XMLUtils.getTextContent(masterKey) : "";
            if (ManagedCard.isStringEmpty(str)) {
                throw new CardException("Couldn't get MasterKey element from RoamingInformationCard with id = " + this.id_);
            }
        } else {
            throw new CardException("Couldn't get \"InformationCardPrivateData\" element from RoamingInformationCard with id = " + this.id_);
        }
        this.masterKey_ = CardCryptography.decodeBase64(str);
    }

    private static boolean isStringEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }

    public Element toXML(Document doc) throws CardException {
        Element card = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "RoamingInformationCard");
        Element metaData = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "InformationCardMetaData");
        if (this.language_ != null) {
            metaData.setAttribute("xml:lang", this.language_);
        }
        card.appendChild(metaData);
        this.addCardReference(doc, metaData);
        this.addCardName(doc, metaData);
        this.addCardImage(doc, metaData);
        this.addIssuer(doc, metaData);
        this.addTimeIssued(doc, metaData);
        this.addTimeExpires(doc, metaData);
        this.addTokenServiceList(doc, metaData);
        this.addSupportedTokenTypes(doc, metaData);
        this.addClaimTypes(doc, metaData);
        this.addRequireAppliesTo(doc, metaData);
        this.addPrivacyNotice(doc, metaData);
        this.addIsSelfIssued(doc, metaData);
        this.addHashSalt(doc, metaData);
        this.addTimeLastUpdated(doc, metaData);
        this.addIssuerId(doc, metaData);
        this.addIssuerName(doc, metaData);
        this.addBackgroundColor(doc, metaData);
        Element privateData = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "InformationCardPrivateData");
        card.appendChild(privateData);
        this.addMasterKey(doc, privateData);
        return card;
    }

    private void addCardReference(Document doc, Element metaData) {
        Element ref = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "InformationCardReference");
        metaData.appendChild(ref);
        Element id = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "CardId");
        XMLUtils.setTextContent(id, this.id_.toString());
        ref.appendChild(id);
        Element version = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "CardVersion");
        XMLUtils.setTextContent(version, this.version_);
        ref.appendChild(version);
    }

    private void addCardName(Document doc, Element metaData) {
        Element name = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "CardName");
        XMLUtils.setTextContent(name, this.name_);
        metaData.appendChild(name);
    }

    private void addCardImage(Document doc, Element metaData) {
        Element image = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "CardImage");
        image.setAttribute("MimeType", this.imageMimeType_);
        XMLUtils.setTextContent(image, new String(CardCryptography.encodeBase64(this.image_, 0)));
        metaData.appendChild(image);
    }

    private void addIssuer(Document doc, Element metaData) {
        Element issuer = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "Issuer");
        XMLUtils.setTextContent(issuer, this.issuer_);
        metaData.appendChild(issuer);
    }

    private void addTimeIssued(Document doc, Element metaData) {
        String time = DateConvertor.format(this.timeIssued_);
        Element timeIssued = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "TimeIssued");
        XMLUtils.setTextContent(timeIssued, time);
        metaData.appendChild(timeIssued);
    }

    private void addTimeExpires(Document doc, Element metaData) {
        String time = DateConvertor.format(this.timeExpires_);
        Element timeExpires = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "TimeExpires");
        XMLUtils.setTextContent(timeExpires, time);
        metaData.appendChild(timeExpires);
    }

    private void addTokenServiceList(Document doc, Element metaData) {
        Element tokenServiceList = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "TokenServiceList");
        metaData.appendChild(tokenServiceList);
        Iterator it = this.tokenServices_.iterator();
        while (it.hasNext()) {
            ITokenService tokenSrv = (ITokenService)it.next();
            Element tokenService = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "TokenService");
            tokenServiceList.appendChild(tokenService);
            IEndpointReference endpoint = tokenSrv.getEndpointReference();
            Element endpointReference = doc.createElementNS("http://www.w3.org/2005/08/addressing", "EndpointReference");
            tokenService.appendChild(endpointReference);
            Element address = doc.createElementNS("http://www.w3.org/2005/08/addressing", "Address");
            XMLUtils.setTextContent(address, endpoint.getAddress().toString());
            endpointReference.appendChild(address);
            if (endpoint.getMetadata() != null) {
                Node metadata = doc.importNode(endpoint.getMetadata(), true);
                endpointReference.appendChild(metadata);
            }
            if (endpoint.getIdentity() != null) {
                Node identity = doc.importNode(endpoint.getIdentity(), true);
                endpointReference.appendChild(identity);
            }
            ICredentialDescriptor uCredential = tokenSrv.getUserCredential();
            Node credential = doc.importNode(uCredential.asXML(), true);
            tokenService.appendChild(credential);
        }
    }

    private void addSupportedTokenTypes(Document doc, Element metaData) {
        Element tokenList = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "SupportedTokenTypeList");
        metaData.appendChild(tokenList);
        Iterator it = this.supportedTokenTypes_.iterator();
        while (it.hasNext()) {
            String uri = it.next().toString();
            Element tokenType = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/02/trust", "TokenType");
            XMLUtils.setTextContent(tokenType, uri);
            tokenList.appendChild(tokenType);
        }
    }

    private void addClaimTypes(Document doc, Element metaData) {
        Element claimTypeList = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "SupportedClaimTypeList");
        metaData.appendChild(claimTypeList);
        Iterator it = this.claimTypes_.iterator();
        while (it.hasNext()) {
            IClaimType type = (IClaimType)it.next();
            Element claimType = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "SupportedClaimType");
            claimType.setAttribute("Uri", type.getType().toString());
            claimTypeList.appendChild(claimType);
            Element displayTag = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "DisplayTag");
            XMLUtils.setTextContent(displayTag, type.getDisplayName());
            claimType.appendChild(displayTag);
            Element description = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "Description");
            XMLUtils.setTextContent(description, type.getDescription());
            claimType.appendChild(description);
        }
    }

    private void addRequireAppliesTo(Document doc, Element metaData) {
        if (this.requireAppliesTo_ != null) {
            Element requireAppliesTo = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "RequireAppliesTo");
            XMLUtils.setTextContent(requireAppliesTo, this.requireAppliesTo_.toString());
            metaData.appendChild(requireAppliesTo);
        }
    }

    private void addPrivacyNotice(Document doc, Element metaData) {
        if (this.privacyNotice_ != null) {
            Element privacyNotice = (Element)doc.importNode(this.privacyNotice_, true);
            metaData.appendChild(privacyNotice);
        }
    }

    private void addIsSelfIssued(Document doc, Element metaData) {
        Element isSelfIssued = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "IsSelfIssued");
        XMLUtils.setTextContent(isSelfIssued, String.valueOf(this.isSelfIssued()));
        metaData.appendChild(isSelfIssued);
    }

    private void addHashSalt(Document doc, Element metaData) throws CardException {
        if (this.hashSalt_ == null) {
            throw new CardException("Card does not have HashSalt value");
        }
        Element hashSalt = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "HashSalt");
        XMLUtils.setTextContent(hashSalt, CardCryptography.encodeBase64(this.hashSalt_, 1));
        metaData.appendChild(hashSalt);
    }

    private void addTimeLastUpdated(Document doc, Element metaData) throws CardException {
        if (this.timeLastUpdated_ == null) {
            throw new CardException("Card does not have TimeLastUpdated value");
        }
        Element timeLastUpdated = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "TimeLastUpdated");
        XMLUtils.setTextContent(timeLastUpdated, DateConvertor.formatMS(this.timeLastUpdated_));
        metaData.appendChild(timeLastUpdated);
    }

    private void addIssuerId(Document doc, Element metaData) {
        Element issuerId = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "IssuerId");
        XMLUtils.setTextContent(issuerId, "");
        metaData.appendChild(issuerId);
    }

    private void addIssuerName(Document doc, Element metaData) {
        Element issuerName = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "IssuerName");
        XMLUtils.setTextContent(issuerName, this.getIssuerName());
        metaData.appendChild(issuerName);
    }

    private void addBackgroundColor(Document doc, Element metaData) {
        Element color = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "BackgroundColor");
        XMLUtils.setTextContent(color, "0");
        metaData.appendChild(color);
    }

    private void addMasterKey(Document doc, Element privateData) throws CardException {
        if (this.masterKey_ == null) {
            throw new CardException("Card does not have MasterKey value");
        }
        Element masterKey = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "MasterKey");
        XMLUtils.setTextContent(masterKey, CardCryptography.encodeBase64(this.masterKey_, 0));
        privateData.appendChild(masterKey);
    }

    public ICredentialDescriptor[] getRequiredCredentials() {
        if (this.requiredCredentials_ == null) {
            List tsl = this.getTokenServices();
            this.requiredCredentials_ = new ICredentialDescriptor[tsl.size()];
            for (int i = 0; i < tsl.size(); ++i) {
                ITokenService ts = (ITokenService)tsl.get(i);
                this.requiredCredentials_[i] = new TSCredentialDescriptor(ts);
            }
        }
        return this.requiredCredentials_;
    }

    public IClaim getClaim(String type) throws AuthenticationRequiredException, InvalidTypeException, CardException {
        if (this.claimValues_ == null) {
            throw new AuthenticationRequiredException();
        }
        if (this.claimValues_.containsKey(type)) {
            return (IClaim)this.claimValues_.get(type);
        }
        throw new InvalidTypeException("Claim type: " + type + " is not supported.");
    }

    public IClaim getClaimByLocalName(String shortTypeName) throws AuthenticationRequiredException, InvalidTypeException, CardException {
        if (this.claimValuesByLocalName_ == null) {
            throw new AuthenticationRequiredException();
        }
        if (this.claimValuesByLocalName_.containsKey(shortTypeName)) {
            return (IClaim)this.claimValuesByLocalName_.get(shortTypeName);
        }
        throw new InvalidTypeException("Claim with local type name: " + shortTypeName + " is not supported.");
    }

    public Iterator getClaims() throws CardException {
        if (this.claimValues_ == null) {
            throw new AuthenticationRequiredException();
        }
        return this.claimValues_.values().iterator();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

