/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.icard.provider.cardspace.common;

import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.higgins.icard.AuthenticationException;
import org.eclipse.higgins.icard.AuthenticationRequiredException;
import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.icard.IClaim;
import org.eclipse.higgins.icard.IClaimType;
import org.eclipse.higgins.icard.IPersonalInformationCard;
import org.eclipse.higgins.icard.ISimpleClaimType;
import org.eclipse.higgins.icard.InvalidTypeException;
import org.eclipse.higgins.icard.auth.ICredential;
import org.eclipse.higgins.icard.auth.ICredentialDescriptor;
import org.eclipse.higgins.icard.common.ClaimType;
import org.eclipse.higgins.icard.common.ClaimValue;
import org.eclipse.higgins.icard.common.auth.PinCodeCredential;
import org.eclipse.higgins.icard.provider.cardspace.common.BasicCredentialDescriptor;
import org.eclipse.higgins.icard.provider.cardspace.common.InformationCard;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.CardCryptography;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.DateConvertor;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.SelfIssuedCardClaims;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class PersonalCard
extends InformationCard
implements IPersonalInformationCard {
    protected ArrayList tmpClaimValueList_ = null;
    protected URI claimListContextID_ = null;
    protected String claimListSubjectID_ = null;
    protected byte[] pinDigest_ = null;

    public void initFromXML(Element card) throws CardException, DOMException {
        this.isSelfIssued_ = true;
        this.issuer_ = "http://schemas.xmlsoap.org/ws/2005/05/identity/issuer/self";
        this.issuerName_ = "Self";
        Element informationCardMetaData = XMLUtils.getChildElement(card, "http://schemas.xmlsoap.org/ws/2005/05/identity", "InformationCardMetaData");
        if (informationCardMetaData == null) {
            throw new CardException("Can not find \"InformationCardMetaData\" element.");
        }
        this.language_ = null;
        if (informationCardMetaData.hasAttribute("xml:lang")) {
            this.language_ = informationCardMetaData.getAttribute("xml:lang");
        }
        Element informationCardPrivateData = XMLUtils.getChildElement(card, "http://schemas.xmlsoap.org/ws/2005/05/identity", "InformationCardPrivateData");
        this.checkIsSelfIssued(informationCardMetaData);
        this.parseCardId(informationCardMetaData);
        this.parseCardVersion(informationCardMetaData);
        this.parseCardName(informationCardMetaData);
        this.parseCardImage(informationCardMetaData);
        this.parseTimeIssued(informationCardMetaData);
        this.parseTimeExpires(informationCardMetaData);
        this.parseSupportedTokenTypes(informationCardMetaData);
        this.parseClaimTypes(informationCardMetaData);
        this.parseHashSalt(informationCardMetaData);
        this.parsePinDigest(informationCardMetaData);
        this.parseTimeLastUpdated(informationCardMetaData);
        this.parseClaimValues(informationCardPrivateData);
        this.parseMasterKey(informationCardPrivateData);
    }

    private void checkIsSelfIssued(Element metaData) throws CardException {
        String boolValue;
        Element isSelfIssued = XMLUtils.getChildElement(metaData, "http://schemas.xmlsoap.org/ws/2005/05/identity", "IsSelfIssued");
        String string = boolValue = isSelfIssued != null ? XMLUtils.getTextContent(isSelfIssued) : "";
        if (boolValue == null || !"true".equals(boolValue.trim().toLowerCase())) {
            throw new CardException("Can not import non-self issued card.");
        }
    }

    private void parseCardId(Element metaData) throws CardException {
        String id;
        Element informationCardReference = XMLUtils.getChildElement(metaData, "http://schemas.xmlsoap.org/ws/2005/05/identity", "InformationCardReference");
        if (informationCardReference != null) {
            Element cardId = XMLUtils.getChildElement(informationCardReference, "http://schemas.xmlsoap.org/ws/2005/05/identity", "CardId");
            String string = id = cardId != null ? XMLUtils.getTextContent(cardId) : "";
            if (id == null || id.trim().length() == 0) {
                throw new CardException("Couldn't get CardId from InfoCard.");
            }
        } else {
            throw new CardException("Couldn't get \"InformationCardReference\" from InfoCard.");
        }
        this.id_ = URI.create(id);
    }

    private void parseCardVersion(Element metaData) throws CardException {
        Element informationCardReference = XMLUtils.getChildElement(metaData, "http://schemas.xmlsoap.org/ws/2005/05/identity", "InformationCardReference");
        if (informationCardReference != null) {
            Element cardVersion = XMLUtils.getChildElement(informationCardReference, "http://schemas.xmlsoap.org/ws/2005/05/identity", "CardVersion");
            String string = this.version_ = cardVersion != null ? XMLUtils.getTextContent(cardVersion) : "";
            if (this.version_ == null || this.version_.trim().length() == 0) {
                throw new CardException("Couldn't get CardVersion from InfoCard with id = " + this.id_);
            }
        } else {
            throw new CardException("Couldn't get \"InformationCardReference\" from InfoCard.");
        }
    }

    private void parseCardName(Element metaData) throws CardException {
        Element cardName = XMLUtils.getChildElement(metaData, "http://schemas.xmlsoap.org/ws/2005/05/identity", "CardName");
        this.name_ = cardName != null ? XMLUtils.getTextContent(cardName) : "";
    }

    private void parseCardImage(Element metaData) throws CardException, DOMException {
        Element cardImg = XMLUtils.getChildElement(metaData, "http://schemas.xmlsoap.org/ws/2005/05/identity", "CardImage");
        if (cardImg == null) {
            throw new CardException("Couldn't get CardImage from InfoCard with id = " + this.id_);
        }
        if (cardImg != null) {
            this.image_ = CardCryptography.decodeBase64(XMLUtils.getTextContent(cardImg));
            this.imageMimeType_ = cardImg.getAttribute("MimeType");
        }
    }

    private void parseTimeIssued(Element metaData) throws CardException {
        String timeIssued;
        Element timeIssuedElm = XMLUtils.getChildElement(metaData, "http://schemas.xmlsoap.org/ws/2005/05/identity", "TimeIssued");
        String string = timeIssued = timeIssuedElm != null ? XMLUtils.getTextContent(timeIssuedElm) : "";
        if (timeIssued == null || timeIssued.trim().length() == 0) {
            throw new CardException("Couldn't get TimeIssued from InfoCard with id = " + this.id_);
        }
        this.timeIssued_ = DateConvertor.parse(timeIssued);
    }

    private void parseTimeExpires(Element metaData) throws CardException {
        String timeExpires;
        Element timeExpiresElm = XMLUtils.getChildElement(metaData, "http://schemas.xmlsoap.org/ws/2005/05/identity", "TimeExpires");
        String string = timeExpires = timeExpiresElm != null ? XMLUtils.getTextContent(timeExpiresElm) : "";
        if (timeExpires != null && timeExpires.trim().length() == 0) {
            this.timeExpires_ = DateConvertor.parse(timeExpires);
        }
    }

    private void parseSupportedTokenTypes(Element metaData) throws CardException {
        this.supportedTokenTypes_ = new ArrayList();
        Element supportedTokenTypeList = XMLUtils.getChildElement(metaData, "http://schemas.xmlsoap.org/ws/2005/05/identity", "SupportedTokenTypeList");
        if (supportedTokenTypeList == null) {
            throw new CardException("Couldn't get \"SupportedTokenTypeList\" element from InfoCard with id = " + this.id_);
        }
        NodeList tokenTypes = supportedTokenTypeList.getChildNodes();
        int len = tokenTypes.getLength();
        for (int i = 0; i < len; ++i) {
            Node nd = tokenTypes.item(i);
            if (nd.getNodeType() != 1 || !"TokenType".equals(nd.getLocalName()) || !"http://schemas.xmlsoap.org/ws/2005/02/trust".equals(nd.getNamespaceURI())) continue;
            Element elm = (Element)nd;
            this.supportedTokenTypes_.add(URI.create(XMLUtils.getTextContent(elm)));
        }
        if (this.supportedTokenTypes_.size() == 0) {
            throw new CardException("Couldn't get the list of TokenType elements from InfoCard with id = " + this.id_);
        }
    }

    private void parseClaimTypes(Element metaData) throws CardException {
        this.claimTypes_ = new ArrayList();
        Element supportedClaimTypeList = XMLUtils.getChildElement(metaData, "http://schemas.xmlsoap.org/ws/2005/05/identity", "SupportedClaimTypeList");
        if (supportedClaimTypeList == null) {
            throw new CardException("Couldn't get \"SupportedClaimTypeList\" element from InfoCard with id = " + this.id_);
        }
        NodeList claimTypes = supportedClaimTypeList.getChildNodes();
        int len = claimTypes.getLength();
        for (int i = 0; i < len; ++i) {
            Node node = claimTypes.item(i);
            if (node.getNodeType() != 1 || !"SupportedClaimType".equals(node.getLocalName()) || !"http://schemas.xmlsoap.org/ws/2005/05/identity".equals(node.getNamespaceURI())) continue;
            Element elm = (Element)node;
            String uri = elm.getAttribute("Uri");
            if (uri == null || uri.trim().length() == 0) {
                throw new CardException("Couldn't get \"uri\" attribute of SupportedClaimType element for InfoCard with id = " + this.id_);
            }
            Element displayTagElm = XMLUtils.getChildElement(elm, "http://schemas.xmlsoap.org/ws/2005/05/identity", "DisplayTag");
            String displayTag = displayTagElm != null ? XMLUtils.getTextContent(displayTagElm) : "";
            Element descriptionElm = XMLUtils.getChildElement(elm, "http://schemas.xmlsoap.org/ws/2005/05/identity", "Description");
            String description = descriptionElm != null ? XMLUtils.getTextContent(descriptionElm) : "";
            this.claimTypes_.add(new ClaimType(uri, displayTag, description));
        }
    }

    private void parseClaimValues(Element privateData) throws CardException {
        this.tmpClaimValueList_ = new ArrayList();
        Element claimValueList = XMLUtils.getChildElement(privateData, "http://schemas.xmlsoap.org/ws/2005/05/identity", "ClaimValueList");
        if (claimValueList == null) {
            throw new CardException("Couldn't get the list of \"ClaimValueList\" elements from InfoCard with id = " + this.id_);
        }
        NodeList claimValues = claimValueList.getChildNodes();
        int len = claimValues.getLength();
        for (int i = 0; i < len; ++i) {
            String value;
            Node node = claimValues.item(i);
            if (node.getNodeType() != 1 || !"ClaimValue".equals(node.getLocalName()) || !"http://schemas.xmlsoap.org/ws/2005/05/identity".equals(node.getNamespaceURI())) continue;
            Element elm = (Element)node;
            String uri = elm.getAttribute("Uri");
            if (uri == null || uri.trim().length() == 0) {
                throw new CardException("Couldn't get \"uri\" attribute of ClaimValue element for InfoCard with id = " + this.id_);
            }
            Element valueElm = XMLUtils.getChildElement(elm, "http://schemas.xmlsoap.org/ws/2005/05/identity", "Value");
            String string = value = valueElm != null ? XMLUtils.getTextContent(valueElm) : "";
            if (value == null) continue;
            ClaimValue claimValue = new ClaimValue((ISimpleClaimType)SelfIssuedCardClaims.getClaimType(uri), value);
            this.tmpClaimValueList_.add(claimValue);
        }
        if (this.tmpClaimValueList_.size() == 0) {
            throw new CardException("Couldn't get list of ClaimValue elements from InfoCard with id = " + this.id_);
        }
    }

    private void parseHashSalt(Element metaData) throws CardException {
        String str;
        Element hashSalt = XMLUtils.getChildElement(metaData, "http://schemas.xmlsoap.org/ws/2005/05/identity", "HashSalt");
        String string = str = hashSalt != null ? XMLUtils.getTextContent(hashSalt) : "";
        if (str == null || str.trim().length() == 0) {
            throw new CardException("Couldn't get HashSalt element from InfoCard with id = " + this.id_);
        }
        this.hashSalt_ = CardCryptography.decodeBase64(str);
    }

    private void parsePinDigest(Element metaData) throws CardException {
        String str;
        this.pinDigest_ = null;
        Element pinDigest = XMLUtils.getChildElement(metaData, "http://schemas.xmlsoap.org/ws/2005/05/identity", "PinDigest");
        String string = str = pinDigest != null ? XMLUtils.getTextContent(pinDigest) : "";
        if (str != null) {
            this.pinDigest_ = CardCryptography.decodeBase64(str);
        }
    }

    private void parseTimeLastUpdated(Element metaData) throws CardException {
        String str;
        Element timeLastUpdated = XMLUtils.getChildElement(metaData, "http://schemas.xmlsoap.org/ws/2005/05/identity", "TimeLastUpdated");
        String string = str = timeLastUpdated != null ? XMLUtils.getTextContent(timeLastUpdated) : "";
        if (str == null || str.trim().length() == 0) {
            throw new CardException("Couldn't get TimeLastUpdated element from InfoCard with id = " + this.id_);
        }
        this.timeLastUpdated_ = DateConvertor.parse(str);
    }

    private void parseMasterKey(Element privateData) throws CardException {
        String str;
        Element masterKey = XMLUtils.getChildElement(privateData, "http://schemas.xmlsoap.org/ws/2005/05/identity", "MasterKey");
        String string = str = masterKey != null ? XMLUtils.getTextContent(masterKey) : "";
        if (str == null || str.trim().length() == 0) {
            throw new CardException("Couldn't get MasterKey element from RoamingInformationCard with id = " + this.id_);
        }
        this.masterKey_ = CardCryptography.decodeBase64(str);
    }

    public URI getClaimListContextID() {
        return this.claimListContextID_;
    }

    public String getClaimListSubjectID() {
        return this.claimListSubjectID_;
    }

    public Element toXML(Document doc) throws CardException {
        Element root = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "InformationCard");
        if (this.language_ != null) {
            root.setAttribute("xml:lang", this.language_);
        }
        doc.appendChild(root);
        this.addCardReference(doc, root);
        this.addCardName(doc, root);
        this.addCardImage(doc, root);
        this.addIssuer(doc, root);
        this.addTimeIssued(doc, root);
        this.addTimeExpires(doc, root);
        this.addSupportedTokenTypes(doc, root);
        this.addClaimTypes(doc, root);
        return root;
    }

    public Element claimsToXML(Document doc) throws CardException {
        Element root = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "ClaimValueList");
        doc.appendChild(root);
        Iterator values = this.tmpClaimValueList_.iterator();
        while (values.hasNext()) {
            ClaimValue claim = (ClaimValue)values.next();
            Element claimValue = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "ClaimValue");
            claimValue.setAttribute("Uri", claim.getType().toString());
            root.appendChild(claimValue);
            Element value = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "Value");
            XMLUtils.setTextContent(value, claim.getValue());
            claimValue.appendChild(value);
        }
        return root;
    }

    private void addCardReference(Document doc, Element root) {
        Element ref = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "InformationCardReference");
        root.appendChild(ref);
        Element id = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "CardId");
        XMLUtils.setTextContent(id, this.id_.toString());
        ref.appendChild(id);
        Element version = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "CardVersion");
        XMLUtils.setTextContent(version, this.version_);
        ref.appendChild(version);
    }

    private void addCardName(Document doc, Element root) {
        Element name = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "CardName");
        XMLUtils.setTextContent(name, this.name_);
        root.appendChild(name);
    }

    private void addCardImage(Document doc, Element root) {
        Element image = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "CardImage");
        image.setAttribute("MimeType", this.imageMimeType_);
        XMLUtils.setTextContent(image, new String(CardCryptography.encodeBase64(this.image_, 0)));
        root.appendChild(image);
    }

    private void addIssuer(Document doc, Element root) {
        Element issuer = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "Issuer");
        XMLUtils.setTextContent(issuer, this.issuer_);
        root.appendChild(issuer);
    }

    private void addTimeIssued(Document doc, Element root) {
        String time = DateConvertor.format(this.timeIssued_);
        Element timeIssued = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "TimeIssued");
        XMLUtils.setTextContent(timeIssued, time);
        root.appendChild(timeIssued);
    }

    private void addTimeExpires(Document doc, Element root) {
        String time = DateConvertor.format(this.timeExpires_);
        Element timeExpires = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "TimeExpires");
        XMLUtils.setTextContent(timeExpires, time);
        root.appendChild(timeExpires);
    }

    private void addSupportedTokenTypes(Document doc, Element root) {
        Element tokenList = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "SupportedTokenTypeList");
        root.appendChild(tokenList);
        Iterator it = this.supportedTokenTypes_.iterator();
        while (it.hasNext()) {
            String uri = it.next().toString();
            Element tokenType = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/02/trust", "TokenType");
            XMLUtils.setTextContent(tokenType, uri);
            tokenList.appendChild(tokenType);
        }
    }

    private void addClaimTypes(Document doc, Element root) {
        Element claimTypeList = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "SupportedClaimTypeList");
        root.appendChild(claimTypeList);
        Iterator it = this.claimTypes_.iterator();
        while (it.hasNext()) {
            IClaimType type = (IClaimType)it.next();
            Element claimType = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "SupportedClaimType");
            claimType.setAttribute("Uri", type.getType().toString());
            claimTypeList.appendChild(claimType);
            Element displayTag = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "DisplayTag");
            XMLUtils.setTextContent(displayTag, type.getDisplayName());
            claimType.appendChild(displayTag);
            Element description = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "Description");
            XMLUtils.setTextContent(description, type.getDescription());
            claimType.appendChild(description);
        }
    }

    public byte[] getPinDigest() throws CardException {
        return this.pinDigest_;
    }

    public IClaim getClaim(String type) throws AuthenticationRequiredException, InvalidTypeException, CardException {
        if (this.claimValues_ == null) {
            this.retrieveClaims(null);
        }
        if (this.claimValues_ == null) {
            throw new AuthenticationRequiredException();
        }
        if (this.claimValues_.containsKey(type)) {
            return (IClaim)this.claimValues_.get(type);
        }
        throw new InvalidTypeException("Claim type: " + type + " is not supported.");
    }

    public IClaim getClaimByLocalName(String shortTypeName) throws AuthenticationRequiredException, InvalidTypeException, CardException {
        if (this.claimValuesByLocalName_ == null) {
            this.retrieveClaims(null);
        }
        if (this.claimValuesByLocalName_ == null) {
            throw new AuthenticationRequiredException();
        }
        if (this.claimValuesByLocalName_.containsKey(shortTypeName)) {
            return (IClaim)this.claimValuesByLocalName_.get(shortTypeName);
        }
        throw new InvalidTypeException("Claim with local type name: " + shortTypeName + " is not supported.");
    }

    public Iterator getClaims() throws CardException {
        if (this.claimValues_ == null) {
            this.retrieveClaims(null);
        }
        if (this.claimValues_ == null) {
            throw new AuthenticationRequiredException();
        }
        return this.claimValues_.values().iterator();
    }

    public ICredentialDescriptor[] getRequiredCredentials() {
        ICredentialDescriptor[] requiredCredentials = null;
        if (this.pinDigest_ != null) {
            requiredCredentials = new ICredentialDescriptor[]{new BasicCredentialDescriptor("PinCodeCredential", "Please provide PIN code", (ICredential)new PinCodeCredential())};
        }
        return requiredCredentials;
    }

    protected abstract void retrieveClaims(ICredential var1) throws AuthenticationRequiredException, AuthenticationException, CardException;
}

