/*******************************************************************************
 * Copyright (c) 2006-2007 IBM Corporation, Parity Communications Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *    Bjoern Assmann (IBM Corporation) - initial API and implementation
 *    abhi shelat
 *    Valery Kokhan - refactoring to integrate with I-Card Registry
 *******************************************************************************/

package org.eclipse.higgins.icard.provider.cardspace.common;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.icard.ICard;
import org.eclipse.higgins.icard.ICardConstants;
import org.eclipse.higgins.icard.IInformationCard;
import org.eclipse.higgins.icard.policy.ICardSpacePolicy;

public class CardSpacePolicy implements ICardSpacePolicy {
	protected static final Log log = LogFactory.getLog(CardSpacePolicy.class);
	
	protected String issuer = "";
	protected String issuerPolicy = "";
	protected String tokenType = "";
	protected List requiredClaims = new ArrayList();
	protected List optionalClaims = new ArrayList();
	protected URL site = null;
	protected String privacyUrl = "";
	protected String privacyVersion = "";
	//protected List cardTypes = Arrays.asList(new String[] {ICardConstants.I_CARD_TYPE_CARDSPACE});
	protected Class[] cardTypes = new Class[] {IInformationCard.class};

	public String getIssuer() {
		return issuer;
	}

	public String getIssuerPolicy() {
		return issuerPolicy;
	}

	public String getTokenType() {
		return tokenType;
	}

	public List getRequiredClaims() {
		return Collections.unmodifiableList(requiredClaims);
	}

	public List getOptionalClaims() {
		return Collections.unmodifiableList(optionalClaims);
	}

	public URL getSite() {
		return site ;
	}

	public String getPrivacyUrl() {
		return privacyUrl;
	}

	public String getPrivacyVersion() {
		return privacyVersion;
	}

	public void setIssuer(String issuer) {
		this.issuer = issuer;
	}

	public void setIssuerPolicy(String issuerPolicy) {
		this.issuerPolicy = issuerPolicy;
	}

	public void setOptionalClaims(List optionalClaims) {
		this.optionalClaims = optionalClaims;
	}

	public void setPrivacyUrl(String privacyUrl) {
		this.privacyUrl = privacyUrl;
	}

	public void setPrivacyVersion(String privacyVersion) {
		this.privacyVersion = privacyVersion;
	}

	public void setRequiredClaims(List requiredClaims) {
		this.requiredClaims = requiredClaims;
	}

	public void setSite(URL site) {
		this.site = site;
	}

	public void setTokenType(String tokenType) {
		this.tokenType = tokenType;
	}

	public String getType() {
		return ICardConstants.POLICY_TYPE_CARDSPACE;
	}

	public Class[] getICardTypes() {
		//return Collections.unmodifiableList(cardTypes);
		return cardTypes;
	}

	public boolean isSatisfiedBy(ICard icard) {
		if (icard == null) {
			return false;
		} /*else if (!getICardTypes().contains(icard.getType())) {
			log.trace("CardSpacePolicy::isSatisfiedBy(ICard icard) fail on card [" + icard.getName()+"] b/c cardType mismatch");
			return false;
		} */else if (icard instanceof IInformationCard) {
			return isSatisfiedBy((IInformationCard) icard);
		}
		return false;
	}

	public boolean isSatisfiedBy(IInformationCard icard) {
		log.trace("CardSpacePolicy::isSatisfiedBy check on ["+icard.getName()+"]");		
		// check whether card applies to policy, i.e. check issuer, ....
		// TODO

		// check issuer
		if (!issuer.equals("")) {
			if (!issuer.equals(icard.getIssuer())) {
				log.trace("issuer " + issuer + " does not match " + icard.getIssuer());
				return false;
			}
		}
		log.trace("issuer ok.");

		// TODO the time when infocard expires should be considred

		// TODO How should issuerPolicy be used for the matching ?
		
		// TODO should we check tokenType ?
		List suppTokenTypes = icard.getSupportedTokenTypes();
		log.trace("Supported token types: " + suppTokenTypes);
		
		if (suppTokenTypes == null || !suppTokenTypes.contains(tokenType)) {
			log.trace("Token type: " + tokenType + " is not supported.");
		}

		List suppClaims = icard.getSupportedClaimTypesUris();
		log.trace("supported claims: " + suppClaims);
		
		for (int i = 0; i < requiredClaims.size(); i++) {
			String claim = (String) requiredClaims.get(i);
			log.trace("Claim to satisfy: " + claim);
			// TODO maybe we should store the index of claim in suppClaims
			// this could be useful for the creation of the token.
			if (!suppClaims.contains(claim)) {
				log.trace("claim not satisfied: " + claim);
				log.trace("returning FALSE");
				return false;
			}
		}

		// TODO how should we deal with ArrayList optionalClaims

		// TODO Should we use this for the matching String privacyUrl;
		
		// TODO How should we consider  privacyVersion; ?
		log.trace("returning TRUE");
		return true;
	}

	public String[] getSummary() {
		return makeSummary(requiredClaims);
	}
	
	public String[] makeSummary(List claims) {
		String[] summary = new String[claims.size()];
		ListIterator li = claims.listIterator();
		int i=0;
		while (li.hasNext()) {
			String cl = CardspaceDisplayMappings.getString(li.next().toString());
			summary[i++] = cl;
		}
		return summary;
	}
	
	public String[] getOptionalClaimSummary() {
		return makeSummary(optionalClaims);
	}
	
}
