/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.icard.provider.cardspace.common;

import java.security.SecureRandom;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.icard.AuthenticationRequiredException;
import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.icard.IClaim;
import org.eclipse.higgins.icard.IClaimType;
import org.eclipse.higgins.icard.IEndpointReference;
import org.eclipse.higgins.icard.IManagedInformationCard;
import org.eclipse.higgins.icard.ITokenService;
import org.eclipse.higgins.icard.InvalidTypeException;
import org.eclipse.higgins.icard.auth.ICredentialDescriptor;
import org.eclipse.higgins.icard.common.io.IOElement;
import org.eclipse.higgins.icard.io.CardIOException;
import org.eclipse.higgins.icard.io.IElement;
import org.eclipse.higgins.icard.io.IElementFormat;
import org.eclipse.higgins.icard.io.UnsupportedElementFormatException;
import org.eclipse.higgins.icard.provider.cardspace.common.InformationCard;
import org.eclipse.higgins.icard.provider.cardspace.common.TSCredentialDescriptor;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.CardCryptography;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.CardUtils;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.DateConvertor;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class ManagedCard
extends InformationCard
implements IManagedInformationCard {
    protected static Log log = LogFactory.getLog((Class)(class$org$eclipse$higgins$icard$provider$cardspace$common$ManagedCard == null ? (class$org$eclipse$higgins$icard$provider$cardspace$common$ManagedCard = ManagedCard.class$("org.eclipse.higgins.icard.provider.cardspace.common.ManagedCard")) : class$org$eclipse$higgins$icard$provider$cardspace$common$ManagedCard));
    protected List tokenServices_ = null;
    protected Boolean requireAppliesTo_ = null;
    protected Element privacyNotice_ = null;
    protected ICredentialDescriptor[] requiredCredentials_ = null;
    static /* synthetic */ Class class$org$eclipse$higgins$icard$provider$cardspace$common$ManagedCard;

    public List getTokenServices() {
        return this.tokenServices_;
    }

    public Boolean getRequireAppliesTo() {
        return this.requireAppliesTo_;
    }

    public Element getPrivacyNotice() {
        return this.privacyNotice_;
    }

    public void initFromXML(Element crd) throws CardException, DOMException {
        if (crd == null) {
            throw new CardException("Parameter card is null.");
        }
        this.isSelfIssued_ = false;
        Element cardMetaData = null;
        boolean isRoamingCard = false;
        if ("InformationCard".equals(crd.getLocalName())) {
            cardMetaData = crd;
        } else if ("RoamingInformationCard".equals(crd.getLocalName())) {
            cardMetaData = XMLUtils.getChildElement(crd, "http://schemas.xmlsoap.org/ws/2005/05/identity", "InformationCardMetaData");
            isRoamingCard = true;
        } else {
            throw new CardException("Couldn't import the card. Unexpected tag name: " + crd.getTagName());
        }
        if (cardMetaData == null) {
            throw new CardException("Couldn't import the card. Can not find ic:InformationCardMetaData element");
        }
        this.language_ = cardMetaData.hasAttribute("xml:lang") ? cardMetaData.getAttribute("xml:lang") : null;
        this.checkIsSelfIssued(cardMetaData);
        this.id_ = CardUtils.parseCardId(cardMetaData);
        this.version_ = CardUtils.parseCardVersion(cardMetaData);
        this.name_ = CardUtils.parseCardName(cardMetaData);
        this.image_ = CardUtils.parseCardImage(cardMetaData);
        this.imageMimeType_ = CardUtils.parseCardImageType(cardMetaData);
        this.issuer_ = CardUtils.parseIssuer(cardMetaData);
        this.issuerID_ = CardUtils.parseIssuerID(cardMetaData);
        this.issuerName_ = CardUtils.parseIssuerName(cardMetaData);
        this.timeIssued_ = CardUtils.parseTimeIssued(cardMetaData);
        this.timeExpires_ = CardUtils.parseTimeExpires(cardMetaData);
        this.supportedTokenTypes_ = CardUtils.parseSupportedTokenTypes(cardMetaData);
        this.claimTypes_ = CardUtils.parseClaimTypes(cardMetaData);
        this.tokenServices_ = CardUtils.parseTokenServiceList(cardMetaData);
        this.requireAppliesTo_ = CardUtils.parseRequireAppliesTo(cardMetaData);
        this.privacyNotice_ = CardUtils.parsePrivacyNotice(cardMetaData);
        if (!isRoamingCard) {
            this.hashSalt_ = SecureRandom.getSeed(32);
            this.masterKey_ = SecureRandom.getSeed(32);
            this.timeLastUpdated_ = new Date();
        } else {
            this.hashSalt_ = CardUtils.parseHashSalt(cardMetaData);
            this.timeLastUpdated_ = CardUtils.parseTimeLastUpdated(cardMetaData);
            this.masterKey_ = CardUtils.parseMasterKey(crd);
        }
    }

    private void checkIsSelfIssued(Element card) throws CardException {
        if (CardUtils.isSelfIssued(card)) {
            throw new CardException("Can not import self issued card.");
        }
    }

    public IElement toElement(IElementFormat format) throws CardException, CardIOException, UnsupportedElementFormatException {
        if (!this.isFormatSupported(format)) {
            throw new CardException("Unsupported element format: " + format);
        }
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setIgnoringComments(true);
            dbf.setIgnoringElementContentWhitespace(true);
            dbf.setNamespaceAware(true);
            dbf.setValidating(false);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.newDocument();
            Element card = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "RoamingInformationCard");
            Element metaData = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "InformationCardMetaData");
            if (this.language_ != null) {
                metaData.setAttribute("xml:lang", this.language_);
            }
            card.appendChild(metaData);
            this.addCardReference(doc, metaData);
            this.addCardName(doc, metaData);
            this.addCardImage(doc, metaData);
            this.addIssuer(doc, metaData);
            this.addTimeIssued(doc, metaData);
            this.addTimeExpires(doc, metaData);
            this.addTokenServiceList(doc, metaData);
            this.addSupportedTokenTypes(doc, metaData);
            this.addClaimTypes(doc, metaData);
            this.addRequireAppliesTo(doc, metaData);
            this.addPrivacyNotice(doc, metaData);
            this.addIsSelfIssued(doc, metaData);
            this.addHashSalt(doc, metaData);
            this.addTimeLastUpdated(doc, metaData);
            this.addIssuerId(doc, metaData);
            this.addIssuerName(doc, metaData);
            this.addBackgroundColor(doc, metaData);
            Element privateData = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "InformationCardPrivateData");
            card.appendChild(privateData);
            this.addMasterKey(doc, privateData);
            IOElement element = new IOElement();
            element.set((Object)card);
            return element;
        }
        catch (Exception e) {
            log.error((Object)"Can't export card", (Throwable)e);
            throw new CardException("Can't export card", (Throwable)e);
        }
    }

    private void addCardReference(Document doc, Element metaData) {
        Element ref = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "InformationCardReference");
        metaData.appendChild(ref);
        Element id = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "CardId");
        XMLUtils.setTextContent(id, this.id_.toString());
        ref.appendChild(id);
        Element version = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "CardVersion");
        XMLUtils.setTextContent(version, this.version_);
        ref.appendChild(version);
    }

    private void addCardName(Document doc, Element metaData) {
        Element name = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "CardName");
        XMLUtils.setTextContent(name, this.name_);
        metaData.appendChild(name);
    }

    private void addCardImage(Document doc, Element metaData) {
        Element image = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "CardImage");
        image.setAttribute("MimeType", this.imageMimeType_);
        XMLUtils.setTextContent(image, new String(CardCryptography.encodeBase64(this.image_, 0)));
        metaData.appendChild(image);
    }

    private void addIssuer(Document doc, Element metaData) {
        Element issuer = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "Issuer");
        XMLUtils.setTextContent(issuer, this.issuer_);
        metaData.appendChild(issuer);
    }

    private void addTimeIssued(Document doc, Element metaData) {
        String time = DateConvertor.format(this.timeIssued_);
        Element timeIssued = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "TimeIssued");
        XMLUtils.setTextContent(timeIssued, time);
        metaData.appendChild(timeIssued);
    }

    private void addTimeExpires(Document doc, Element metaData) {
        String time = DateConvertor.format(this.timeExpires_);
        Element timeExpires = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "TimeExpires");
        XMLUtils.setTextContent(timeExpires, time);
        metaData.appendChild(timeExpires);
    }

    private void addTokenServiceList(Document doc, Element metaData) {
        Element tokenServiceList = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "TokenServiceList");
        metaData.appendChild(tokenServiceList);
        Iterator it = this.tokenServices_.iterator();
        while (it.hasNext()) {
            ITokenService tokenSrv = (ITokenService)it.next();
            Element tokenService = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "TokenService");
            tokenServiceList.appendChild(tokenService);
            IEndpointReference endpoint = tokenSrv.getEndpointReference();
            Element endpointReference = doc.createElementNS("http://www.w3.org/2005/08/addressing", "EndpointReference");
            tokenService.appendChild(endpointReference);
            Element address = doc.createElementNS("http://www.w3.org/2005/08/addressing", "Address");
            XMLUtils.setTextContent(address, endpoint.getAddress().toString());
            endpointReference.appendChild(address);
            if (endpoint.getMetadata() != null) {
                Node metadata = doc.importNode(endpoint.getMetadata(), true);
                endpointReference.appendChild(metadata);
            }
            if (endpoint.getIdentity() != null) {
                Node identity = doc.importNode(endpoint.getIdentity(), true);
                endpointReference.appendChild(identity);
            }
            ICredentialDescriptor uCredential = tokenSrv.getUserCredential();
            Node credential = doc.importNode(uCredential.asXML(), true);
            tokenService.appendChild(credential);
        }
    }

    private void addSupportedTokenTypes(Document doc, Element metaData) {
        Element tokenList = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "SupportedTokenTypeList");
        metaData.appendChild(tokenList);
        Iterator it = this.supportedTokenTypes_.iterator();
        while (it.hasNext()) {
            String uri = it.next().toString();
            Element tokenType = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/02/trust", "TokenType");
            XMLUtils.setTextContent(tokenType, uri);
            tokenList.appendChild(tokenType);
        }
    }

    private void addClaimTypes(Document doc, Element metaData) {
        Element claimTypeList = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "SupportedClaimTypeList");
        metaData.appendChild(claimTypeList);
        Iterator it = this.claimTypes_.iterator();
        while (it.hasNext()) {
            IClaimType type = (IClaimType)it.next();
            Element claimType = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "SupportedClaimType");
            claimType.setAttribute("Uri", type.getType().toString());
            claimTypeList.appendChild(claimType);
            Element displayTag = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "DisplayTag");
            XMLUtils.setTextContent(displayTag, type.getDisplayName());
            claimType.appendChild(displayTag);
            Element description = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "Description");
            XMLUtils.setTextContent(description, type.getDescription());
            claimType.appendChild(description);
        }
    }

    private void addRequireAppliesTo(Document doc, Element metaData) {
        if (this.requireAppliesTo_ != null) {
            Element requireAppliesTo = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "RequireAppliesTo");
            XMLUtils.setTextContent(requireAppliesTo, this.requireAppliesTo_.toString());
            metaData.appendChild(requireAppliesTo);
        }
    }

    private void addPrivacyNotice(Document doc, Element metaData) {
        if (this.privacyNotice_ != null) {
            Element privacyNotice = (Element)doc.importNode(this.privacyNotice_, true);
            metaData.appendChild(privacyNotice);
        }
    }

    private void addIsSelfIssued(Document doc, Element metaData) {
        Element isSelfIssued = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "IsSelfIssued");
        XMLUtils.setTextContent(isSelfIssued, String.valueOf(this.isSelfIssued()));
        metaData.appendChild(isSelfIssued);
    }

    private void addHashSalt(Document doc, Element metaData) throws CardException {
        if (this.hashSalt_ == null) {
            throw new CardException("Card does not have HashSalt value");
        }
        Element hashSalt = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "HashSalt");
        XMLUtils.setTextContent(hashSalt, CardCryptography.encodeBase64(this.hashSalt_, 1));
        metaData.appendChild(hashSalt);
    }

    private void addTimeLastUpdated(Document doc, Element metaData) throws CardException {
        if (this.timeLastUpdated_ == null) {
            throw new CardException("Card does not have TimeLastUpdated value");
        }
        Element timeLastUpdated = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "TimeLastUpdated");
        XMLUtils.setTextContent(timeLastUpdated, DateConvertor.formatMS(this.timeLastUpdated_));
        metaData.appendChild(timeLastUpdated);
    }

    private void addIssuerId(Document doc, Element metaData) {
        Element issuerId = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "IssuerId");
        metaData.appendChild(issuerId);
        if (this.issuerID_ != null) {
            XMLUtils.setTextContent(issuerId, CardCryptography.encodeBase64(this.issuerID_, 0));
        }
    }

    private void addIssuerName(Document doc, Element metaData) {
        Element issuerName = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "IssuerName");
        XMLUtils.setTextContent(issuerName, this.getIssuerName());
        metaData.appendChild(issuerName);
    }

    private void addBackgroundColor(Document doc, Element metaData) {
        Element color = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "BackgroundColor");
        XMLUtils.setTextContent(color, "0");
        metaData.appendChild(color);
    }

    private void addMasterKey(Document doc, Element privateData) throws CardException {
        if (this.masterKey_ == null) {
            throw new CardException("Card does not have MasterKey value");
        }
        Element masterKey = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "MasterKey");
        XMLUtils.setTextContent(masterKey, CardCryptography.encodeBase64(this.masterKey_, 0));
        privateData.appendChild(masterKey);
    }

    public ICredentialDescriptor[] getRequiredCredentials() {
        if (this.requiredCredentials_ == null) {
            List tsl = this.getTokenServices();
            this.requiredCredentials_ = new ICredentialDescriptor[tsl.size()];
            for (int i = 0; i < tsl.size(); ++i) {
                ITokenService ts = (ITokenService)tsl.get(i);
                this.requiredCredentials_[i] = new TSCredentialDescriptor(ts);
            }
        }
        return this.requiredCredentials_;
    }

    public IClaim getClaim(String type) throws AuthenticationRequiredException, InvalidTypeException, CardException {
        List supportedTypes = this.getSupportedClaimTypesUris();
        if (type == null || !supportedTypes.contains(type)) {
            throw new InvalidTypeException("Claim type: " + type + " is not supported.");
        }
        if (this.claimValues_ == null) {
            throw new AuthenticationRequiredException();
        }
        if (this.claimValues_.containsKey(type)) {
            return (IClaim)this.claimValues_.get(type);
        }
        return null;
    }

    public IClaim getClaimByLocalName(String shortTypeName) throws AuthenticationRequiredException, InvalidTypeException, CardException {
        if (this.claimValuesByLocalName_ == null) {
            throw new AuthenticationRequiredException();
        }
        if (this.claimValuesByLocalName_.containsKey(shortTypeName)) {
            return (IClaim)this.claimValuesByLocalName_.get(shortTypeName);
        }
        throw new InvalidTypeException("Claim with local type name: " + shortTypeName + " is not supported.");
    }

    public Iterator getClaims() throws CardException {
        if (this.claimValues_ == null) {
            throw new AuthenticationRequiredException();
        }
        return this.claimValues_.values().iterator();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

