/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.icard.provider.cardspace.common.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.CardCryptography;

public class EncryptedMasterKey {
    private static Log log = LogFactory.getLog((Class)(class$org$eclipse$higgins$icard$provider$cardspace$common$utils$EncryptedMasterKey == null ? (class$org$eclipse$higgins$icard$provider$cardspace$common$utils$EncryptedMasterKey = EncryptedMasterKey.class$("org.eclipse.higgins.icard.provider.cardspace.common.utils.EncryptedMasterKey")) : class$org$eclipse$higgins$icard$provider$cardspace$common$utils$EncryptedMasterKey));
    private byte[] encryptedKey_ = null;
    private byte[] version_ = null;
    private byte[] salt_ = null;
    private byte[] iterationCount_ = null;
    private byte[] initVector_ = null;
    private byte[] encryptedData_ = null;
    private byte[] derivedKey_ = null;
    private byte[] pinCode_ = null;
    private Key key_ = null;
    private byte[] decryptedMasterKey_ = null;
    private static final byte[] PIN_ENCRYPTION_VERSION = new byte[]{1};
    private static final byte[] KEY_DERIVATION_ITERATION_COUNT = new byte[]{1, 0, 0, 0};
    static /* synthetic */ Class class$org$eclipse$higgins$icard$provider$cardspace$common$utils$EncryptedMasterKey;

    public EncryptedMasterKey(byte[] encryptedMasterKey, byte[] pinCode) throws CardException {
        if (pinCode == null) {
            throw new CardException("Parameter \"pinCode\" is null.");
        }
        if (encryptedMasterKey == null) {
            throw new CardException("Parameter \"encryptedMasterKey\" is null.");
        }
        if (encryptedMasterKey.length < 38) {
            throw new CardException("EncryptedMasterKey array is too short. Most likely the master key is not encrypted.");
        }
        this.pinCode_ = pinCode;
        this.encryptedKey_ = encryptedMasterKey;
        this.version_ = CardCryptography.getSubArray(this.encryptedKey_, 0, 1);
        log.debug((Object)("decryptPersonalCardField() > Version " + String.valueOf(this.version_)));
        this.salt_ = CardCryptography.getSubArray(this.encryptedKey_, 1, 16);
        this.iterationCount_ = CardCryptography.getSubArray(this.encryptedKey_, 17, 4);
        log.debug((Object)("decryptPersonalCardField() > Version " + String.valueOf(this.iterationCount_)));
        this.initVector_ = CardCryptography.getSubArray(this.encryptedKey_, 21, 16);
        this.encryptedData_ = CardCryptography.getSubArray(this.encryptedKey_, 37, this.encryptedKey_.length - 37);
        try {
            this.derivedKey_ = CardCryptography.getDerivedKey(pinCode, this.salt_);
        }
        catch (NoSuchAlgorithmException e) {
            log.error((Object)e);
            throw new CardException(e.getMessage());
        }
        this.key_ = new SecretKeySpec(this.derivedKey_, "AES");
    }

    public EncryptedMasterKey(byte[] decryptedMasterKey, byte[] salt, byte[] initVector, byte[] pinCode) throws CardException {
        byte[] derivedKey;
        if (decryptedMasterKey == null) {
            throw new CardException("Parameter \"decryptedMasterKey\" is null");
        }
        this.decryptedMasterKey_ = decryptedMasterKey;
        if (salt == null) {
            throw new CardException("Parameter \"salt\" is null");
        }
        this.salt_ = salt;
        if (initVector == null) {
            throw new CardException("Parameter \"initVector\" is null");
        }
        this.initVector_ = initVector;
        if (pinCode == null) {
            throw new CardException("Parameter \"pinCode\" is null");
        }
        this.pinCode_ = pinCode;
        try {
            derivedKey = CardCryptography.getDerivedKey(this.pinCode_, this.salt_);
        }
        catch (NoSuchAlgorithmException e) {
            log.error((Object)e);
            throw new CardException(e.getMessage());
        }
        this.key_ = new SecretKeySpec(derivedKey, "AES");
        try {
            this.encryptedData_ = CardCryptography.encryptData(this.decryptedMasterKey_, this.initVector_, this.key_);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new CardException(e.getMessage());
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            os.write(PIN_ENCRYPTION_VERSION);
            os.write(this.salt_);
            os.write(KEY_DERIVATION_ITERATION_COUNT);
            os.write(this.initVector_);
            os.write(this.encryptedData_);
        }
        catch (IOException e) {
            log.error((Object)e);
            throw new CardException(e.getMessage());
        }
        this.encryptedKey_ = os.toByteArray();
    }

    public Key getKey() {
        return this.key_;
    }

    public byte[] getInitVector() {
        return this.initVector_;
    }

    public byte[] getSalt() {
        return this.salt_;
    }

    public byte[] getPinCode() {
        return this.pinCode_;
    }

    public byte[] getDecryptedMasterKey() throws CardException {
        if (this.decryptedMasterKey_ == null) {
            try {
                this.decryptedMasterKey_ = CardCryptography.decryptPersonalCardField(this.encryptedData_, this);
            }
            catch (Exception e) {
                log.error((Object)e);
                throw new CardException(e.getMessage());
            }
        }
        return this.decryptedMasterKey_;
    }

    public byte[] getEncryptedMasterKey() throws CardException {
        return this.encryptedKey_;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

