/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.icard.provider.cardspace.common.utils;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.icard.IInformationCard;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.RelyingPartyIdentifierHelper;
import org.eclipse.higgins.sts.base64.apache.Base64ApacheExtension;

public class PPIDHelper {
    protected static final Log log = LogFactory.getLog((Class)(class$org$eclipse$higgins$icard$provider$cardspace$common$utils$PPIDHelper == null ? (class$org$eclipse$higgins$icard$provider$cardspace$common$utils$PPIDHelper = PPIDHelper.class$("org.eclipse.higgins.icard.provider.cardspace.common.utils.PPIDHelper")) : class$org$eclipse$higgins$icard$provider$cardspace$common$utils$PPIDHelper));
    static char[] userFriendlyPPIDValuetabe = new char[]{'Q', 'L', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'J', 'K', 'M', 'N', 'P', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    static /* synthetic */ Class class$org$eclipse$higgins$icard$provider$cardspace$common$utils$PPIDHelper;

    public static byte[] computeClaimValuePPID(IInformationCard informationCard, X509Certificate rp) throws Exception {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        log.trace((Object)("used cardid: " + informationCard.getID()));
        informationCard.getID();
        byte[] canonicalCardId = md.digest(informationCard.getID().getBytes("UTF-16LE"));
        log.trace((Object)("cardid in bytes: " + canonicalCardId));
        md.reset();
        byte[] relyingPartyId = RelyingPartyIdentifierHelper.getRelyingPartyIdentifier(rp);
        md.update(relyingPartyId);
        md.update(canonicalCardId);
        byte[] res = md.digest();
        log.info((Object)"user friendly ppid is: ");
        return res;
    }

    public static String getUserFriendlyPPID(byte[] ppid) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        byte[] ppidh = md.digest(ppid);
        StringBuffer res = new StringBuffer();
        for (int i = 0; i < 10; ++i) {
            int value = ppidh[i];
            if ((value %= 32) < 0) {
                value += 32;
            }
            char A_i = userFriendlyPPIDValuetabe[value];
            res.append(A_i);
            if (i != 2 && i != 6) continue;
            res.append('-');
        }
        return res.toString();
    }

    public static String getUserFriendlyPPID(String ppid) throws Exception {
        Base64ApacheExtension base64Extension = new Base64ApacheExtension();
        byte[] bppid = base64Extension.decode(ppid);
        return PPIDHelper.getUserFriendlyPPID(bppid);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

