/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.icard.provider.cardspace.common.utils;

import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.icard.ISimpleClaimType;
import org.eclipse.higgins.icard.common.ClaimType;
import org.eclipse.higgins.icard.common.ClaimValue;
import org.eclipse.higgins.icard.provider.cardspace.common.CredentialDescriptor;
import org.eclipse.higgins.icard.provider.cardspace.common.EndpointReference;
import org.eclipse.higgins.icard.provider.cardspace.common.TokenService;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.CardCryptography;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.DateConvertor;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.SelfIssuedCardClaims;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.XMLUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CardUtils {
    private static Log log;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.higgins.icard.provider.cardspace.common.ManagedCard");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public static URI parseCardId(Element card) throws CardException {
        String id = null;
        try {
            Element informationCardReference = XMLUtils.getChildElement(card, "http://schemas.xmlsoap.org/ws/2005/05/identity", "InformationCardReference");
            Element cardId = XMLUtils.getChildElement(informationCardReference, "http://schemas.xmlsoap.org/ws/2005/05/identity", "CardId");
            id = XMLUtils.getTextContent(cardId);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        if (CardUtils.isStringEmpty(id)) {
            throw new CardException("Couldn't get CardId element from InfoCard.");
        }
        return URI.create(id);
    }

    public static String parseCardVersion(Element card) throws CardException {
        String version = null;
        try {
            Element informationCardReference = XMLUtils.getChildElement(card, "http://schemas.xmlsoap.org/ws/2005/05/identity", "InformationCardReference");
            Element cardVersion = XMLUtils.getChildElement(informationCardReference, "http://schemas.xmlsoap.org/ws/2005/05/identity", "CardVersion");
            version = XMLUtils.getTextContent(cardVersion);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        if (CardUtils.isStringEmpty(version)) {
            throw new CardException("Couldn't get CardVersion element");
        }
        return version;
    }

    public static String parseCardName(Element card) throws CardException {
        Element cardNameElm = XMLUtils.getChildElement(card, "http://schemas.xmlsoap.org/ws/2005/05/identity", "CardName");
        return cardNameElm != null ? XMLUtils.getTextContent(cardNameElm) : "";
    }

    public static byte[] parseCardImage(Element card) throws CardException {
        byte[] image = null;
        Element cardImageElm = XMLUtils.getChildElement(card, "http://schemas.xmlsoap.org/ws/2005/05/identity", "CardImage");
        if (cardImageElm != null) {
            image = CardCryptography.decodeBase64(XMLUtils.getTextContent(cardImageElm));
        }
        return image;
    }

    public static String parseCardImageType(Element card) throws CardException {
        String imageMimeType = "";
        Element cardImageElm = XMLUtils.getChildElement(card, "http://schemas.xmlsoap.org/ws/2005/05/identity", "CardImage");
        if (cardImageElm != null) {
            imageMimeType = cardImageElm.getAttribute("MimeType");
        }
        return imageMimeType;
    }

    public static String parseIssuer(Element card) throws CardException {
        String issuer = null;
        Element issuerElm = XMLUtils.getChildElement(card, "http://schemas.xmlsoap.org/ws/2005/05/identity", "Issuer");
        String string = issuer = issuerElm != null ? XMLUtils.getTextContent(issuerElm) : "";
        if (CardUtils.isStringEmpty(issuer)) {
            throw new CardException("Couldn't get issuer information from card element");
        }
        return issuer;
    }

    public static String parseIssuerName(Element card) throws CardException {
        String issuerName = null;
        Element issuerNameElm = XMLUtils.getChildElement(card, "http://schemas.xmlsoap.org/ws/2005/05/identity", "IssuerName");
        String string = issuerName = issuerNameElm != null ? XMLUtils.getTextContent(issuerNameElm) : "";
        if (CardUtils.isStringEmpty(issuerName)) {
            String sIssuer = CardUtils.parseIssuer(card);
            try {
                URI issuer = URI.create(sIssuer);
                issuerName = issuer != null ? issuer.getHost().toString() : sIssuer;
            }
            catch (Exception e) {
                issuerName = sIssuer;
                log.error((Object)e);
            }
        }
        return issuerName;
    }

    public static byte[] parseIssuerID(Element card) throws CardException {
        String issuerID;
        Element issuerNameElm = XMLUtils.getChildElement(card, "http://schemas.xmlsoap.org/ws/2005/05/identity", "IssuerId");
        if (issuerNameElm != null && (issuerID = XMLUtils.getTextContent(issuerNameElm)) != null) {
            return CardCryptography.decodeBase64(issuerID);
        }
        return null;
    }

    public static Date parseTimeIssued(Element card) throws CardException {
        String timeIssued;
        Element timeIssuedElm = XMLUtils.getChildElement(card, "http://schemas.xmlsoap.org/ws/2005/05/identity", "TimeIssued");
        String string = timeIssued = timeIssuedElm != null ? XMLUtils.getTextContent(timeIssuedElm) : "";
        if (CardUtils.isStringEmpty(timeIssued)) {
            throw new CardException("Couldn't get TimeIssued information from card element");
        }
        return DateConvertor.parse(timeIssued);
    }

    public static Date parseTimeExpires(Element card) throws CardException {
        String timeExpires;
        Date res = null;
        Element timeExpiresElm = XMLUtils.getChildElement(card, "http://schemas.xmlsoap.org/ws/2005/05/identity", "TimeExpires");
        String string = timeExpires = timeExpiresElm != null ? XMLUtils.getTextContent(timeExpiresElm) : "";
        if (!CardUtils.isStringEmpty(timeExpires)) {
            res = DateConvertor.parse(timeExpires);
        }
        return res;
    }

    public static List parseSupportedTokenTypes(Element card) throws CardException {
        ArrayList<URI> supportedTokenTypes = new ArrayList<URI>();
        Element supportedTokenTypeList = XMLUtils.getChildElement(card, "http://schemas.xmlsoap.org/ws/2005/05/identity", "SupportedTokenTypeList");
        if (supportedTokenTypeList == null) {
            throw new CardException("Couldn't get \"SupportedTokenTypeList\" element");
        }
        NodeList tokenTypes = supportedTokenTypeList.getChildNodes();
        int len = tokenTypes.getLength();
        int i = 0;
        while (i < len) {
            Element elm;
            String uri;
            Node nd = tokenTypes.item(i);
            if (nd.getNodeType() == 1 && "TokenType".equals(nd.getLocalName()) && "http://schemas.xmlsoap.org/ws/2005/02/trust".equals(nd.getNamespaceURI()) && !CardUtils.isStringEmpty(uri = XMLUtils.getTextContent(elm = (Element)nd))) {
                supportedTokenTypes.add(URI.create(uri));
            }
            ++i;
        }
        if (supportedTokenTypes.size() == 0) {
            throw new CardException("Couldn't get information about supported token types");
        }
        return supportedTokenTypes;
    }

    public static List parseClaimTypes(Element card) throws CardException {
        ArrayList<ClaimType> claimTypes_ = new ArrayList<ClaimType>();
        Element supportedClaimTypeList = XMLUtils.getChildElement(card, "http://schemas.xmlsoap.org/ws/2005/05/identity", "SupportedClaimTypeList");
        if (supportedClaimTypeList == null) {
            throw new CardException("Couldn't get \"SupportedClaimTypeList\" element");
        }
        NodeList claimTypes = supportedClaimTypeList.getChildNodes();
        int len = claimTypes.getLength();
        int i = 0;
        while (i < len) {
            Node node = claimTypes.item(i);
            if (node.getNodeType() == 1 && "SupportedClaimType".equals(node.getLocalName()) && "http://schemas.xmlsoap.org/ws/2005/05/identity".equals(node.getNamespaceURI())) {
                Element elm = (Element)node;
                String uri = elm.getAttribute("Uri");
                if (CardUtils.isStringEmpty(uri)) {
                    throw new CardException("Couldn't get \"uri\" attribute of SupportedClaimType element");
                }
                Element displayTagElm = XMLUtils.getChildElement(elm, "http://schemas.xmlsoap.org/ws/2005/05/identity", "DisplayTag");
                String displayTag = displayTagElm != null ? XMLUtils.getTextContent(displayTagElm) : "";
                Element descriptionElm = XMLUtils.getChildElement(elm, "http://schemas.xmlsoap.org/ws/2005/05/identity", "Description");
                String description = descriptionElm != null ? XMLUtils.getTextContent(descriptionElm) : "";
                claimTypes_.add(new ClaimType(uri, displayTag, description));
            }
            ++i;
        }
        return claimTypes_;
    }

    private static EndpointReference parseEndpointReference(Element endpointRef) throws CardException {
        Element addressElm = XMLUtils.getChildElement(endpointRef, "http://www.w3.org/2005/08/addressing", "Address");
        String addressStr = addressElm != null ? XMLUtils.getTextContent(addressElm) : "";
        URI address = addressStr != null ? URI.create(addressStr) : null;
        Element metadata = XMLUtils.getChildElement(endpointRef, "http://www.w3.org/2005/08/addressing", "Metadata");
        Element identity = XMLUtils.getChildElement(endpointRef, "http://schemas.xmlsoap.org/ws/2006/02/addressingidentity", "Identity");
        return new EndpointReference(address, metadata, identity);
    }

    private static CredentialDescriptor parseUserCredential(Element credential) throws CardException {
        Element hintElm = XMLUtils.getChildElement(credential, "http://schemas.xmlsoap.org/ws/2005/05/identity", "DisplayCredentialHint");
        String hint = hintElm != null ? XMLUtils.getTextContent(hintElm) : "";
        return new CredentialDescriptor(hint, credential);
    }

    public static List parseTokenServiceList(Element card) throws CardException {
        ArrayList<TokenService> tokenServices_ = new ArrayList<TokenService>();
        Element tokenServiceList = XMLUtils.getChildElement(card, "http://schemas.xmlsoap.org/ws/2005/05/identity", "TokenServiceList");
        if (tokenServiceList == null) {
            throw new CardException("Couldn't get \"TokenServiceList\" element");
        }
        NodeList tokenServices = tokenServiceList.getChildNodes();
        int len = tokenServices.getLength();
        int i = 0;
        while (i < len) {
            Node node = tokenServices.item(i);
            if (node.getNodeType() == 1 && "TokenService".equals(node.getLocalName()) && "http://schemas.xmlsoap.org/ws/2005/05/identity".equals(node.getNamespaceURI())) {
                Element elm = (Element)node;
                Element endpointRef = XMLUtils.getChildElement(elm, "http://www.w3.org/2005/08/addressing", "EndpointReference");
                if (endpointRef == null) {
                    throw new CardException("Couldn't get wsa:EndpointReference element");
                }
                EndpointReference epRef = CardUtils.parseEndpointReference(endpointRef);
                Element credential = XMLUtils.getChildElement(elm, "http://schemas.xmlsoap.org/ws/2005/05/identity", "UserCredential");
                if (credential == null) {
                    throw new CardException("Couldn't get ic:UserCredential element");
                }
                CredentialDescriptor userCredential = CardUtils.parseUserCredential(credential);
                tokenServices_.add(new TokenService(epRef, userCredential));
            }
            ++i;
        }
        if (tokenServices_.size() == 0) {
            throw new CardException("Couldn't get list of TokenService elements");
        }
        return tokenServices_;
    }

    public static Boolean parseRequireAppliesTo(Element card) throws CardException {
        Element requireAppliesTo = XMLUtils.getChildElement(card, "http://schemas.xmlsoap.org/ws/2005/05/identity", "RequireAppliesTo");
        Boolean requireAppliesTo_ = null;
        if (requireAppliesTo != null) {
            String optional = requireAppliesTo.getAttribute("Optional");
            if (optional == null || "".equals(optional) || "false".equalsIgnoreCase(optional)) {
                requireAppliesTo_ = Boolean.FALSE;
            }
            if ("true".equalsIgnoreCase(optional)) {
                requireAppliesTo_ = Boolean.TRUE;
            }
        }
        System.out.println("---> RequiresAppliesTo field: " + requireAppliesTo_);
        return requireAppliesTo_;
    }

    public static Element parsePrivacyNotice(Element card) throws CardException {
        return XMLUtils.getChildElement(card, "http://schemas.xmlsoap.org/ws/2005/05/identity", "PrivacyNotice");
    }

    public static byte[] parseHashSalt(Element card) throws CardException {
        String str;
        Element hashSalt = XMLUtils.getChildElement(card, "http://schemas.xmlsoap.org/ws/2005/05/identity", "HashSalt");
        String string = str = hashSalt != null ? XMLUtils.getTextContent(hashSalt) : "";
        if (CardUtils.isStringEmpty(str)) {
            throw new CardException("Couldn't retrieve HashSalt");
        }
        return CardCryptography.decodeBase64(str);
    }

    public static Date parseTimeLastUpdated(Element card) throws CardException {
        String str;
        Element timeLastUpdated = XMLUtils.getChildElement(card, "http://schemas.xmlsoap.org/ws/2005/05/identity", "TimeLastUpdated");
        String string = str = timeLastUpdated != null ? XMLUtils.getTextContent(timeLastUpdated) : "";
        if (CardUtils.isStringEmpty(str)) {
            throw new CardException("Couldn't retrieve TimeLastUpdated");
        }
        return DateConvertor.parse(str);
    }

    public static byte[] parseMasterKey(Element roamingCard) throws CardException {
        Element informationCardPrivateData = XMLUtils.getChildElement(roamingCard, "http://schemas.xmlsoap.org/ws/2005/05/identity", "InformationCardPrivateData");
        if (informationCardPrivateData != null) {
            String str;
            Element masterKey = XMLUtils.getChildElement(informationCardPrivateData, "http://schemas.xmlsoap.org/ws/2005/05/identity", "MasterKey");
            String string = str = masterKey != null ? XMLUtils.getTextContent(masterKey) : "";
            if (CardUtils.isStringEmpty(str)) {
                throw new CardException("Couldn't get MasterKey element from RoamingInformationCard");
            }
            return CardCryptography.decodeBase64(str);
        }
        throw new CardException("Couldn't get \"InformationCardPrivateData\" element from RoamingInformationCard");
    }

    public static byte[] parsePinDigest(Element metaData) throws CardException {
        String str;
        byte[] pinDigest_ = null;
        Element pinDigest = XMLUtils.getChildElement(metaData, "http://schemas.xmlsoap.org/ws/2005/05/identity", "PinDigest");
        String string = str = pinDigest != null ? XMLUtils.getTextContent(pinDigest) : null;
        if (str != null) {
            pinDigest_ = CardCryptography.decodeBase64(str);
        }
        return pinDigest_;
    }

    public static HashMap parseClaimValues(Element privateData) throws CardException {
        HashMap<String, ClaimValue> tmpClaimValueMap_ = new HashMap<String, ClaimValue>();
        Element claimValueList = XMLUtils.getChildElement(privateData, "http://schemas.xmlsoap.org/ws/2005/05/identity", "ClaimValueList");
        if (claimValueList == null) {
            return tmpClaimValueMap_;
        }
        NodeList claimValues = claimValueList.getChildNodes();
        int len = claimValues.getLength();
        int i = 0;
        while (i < len) {
            Node node = claimValues.item(i);
            if (node.getNodeType() == 1 && "ClaimValue".equals(node.getLocalName()) && "http://schemas.xmlsoap.org/ws/2005/05/identity".equals(node.getNamespaceURI())) {
                String value;
                Element elm = (Element)node;
                String uri = elm.getAttribute("Uri");
                if (uri == null || uri.trim().length() == 0) {
                    throw new CardException("Couldn't get \"uri\" attribute of ClaimValue element");
                }
                Element valueElm = XMLUtils.getChildElement(elm, "http://schemas.xmlsoap.org/ws/2005/05/identity", "Value");
                String string = value = valueElm != null ? XMLUtils.getTextContent(valueElm) : "";
                if (value != null) {
                    ClaimValue claimValue = new ClaimValue((ISimpleClaimType)SelfIssuedCardClaims.getClaimType(uri), value);
                    tmpClaimValueMap_.put(uri, claimValue);
                }
            }
            ++i;
        }
        return tmpClaimValueMap_;
    }

    public static boolean isSelfIssued(Element card) throws CardException {
        String boolValue;
        boolean res = false;
        Element isSelfIssuedElm = XMLUtils.getChildElement(card, "http://schemas.xmlsoap.org/ws/2005/05/identity", "IsSelfIssued");
        String string = boolValue = isSelfIssuedElm != null ? XMLUtils.getTextContent(isSelfIssuedElm) : "";
        if (!CardUtils.isStringEmpty(boolValue) && "true".equals(boolValue.trim().toLowerCase())) {
            res = true;
        }
        return res;
    }

    public static boolean isStringEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }
}

