/*******************************************************************************
 * Copyright (c) 2007-2008 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Valery Kokhan - Initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.icard.provider.cardspace.common.io;

import javax.xml.namespace.QName;

import org.eclipse.higgins.icard.common.io.XMLElementFormat;
import org.eclipse.higgins.icard.common.io.FormatDescriptor;
import org.eclipse.higgins.icard.io.IElementFormat;
import org.eclipse.higgins.icard.io.IFormatDescriptor;
import org.eclipse.higgins.icard.io.IFormatProvider;
import org.eclipse.higgins.icard.io.IInputProcessor;
import org.eclipse.higgins.icard.io.IOutputProcessor;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.CardContext;
import org.eclipse.higgins.registry.IConfiguration;

public class CRDFormatProvider implements IFormatProvider {
	private static final String FORMAT_ID = "org.eclipse.higgins.icard.format.crd";

	private static final String FORMAT_NAME = "Managed Information Card Format";

	private static final String FILE_EXTENSION = ".crd";

	private static final String FORMAT_DESCRIPTION = "This format represents the format of Managed Information Card files.";
	
	private static final IElementFormat elementDescriptor = new XMLElementFormat(
			new QName[] { CardContext.QN_IC_INFORMATION_CARD });
	
	protected static final IFormatDescriptor formatDescriptor = new FormatDescriptor(FORMAT_ID, FORMAT_NAME, FORMAT_DESCRIPTION, FILE_EXTENSION, null, elementDescriptor);
	private final IInputProcessor inputProcessor = new CRDInputProcessor(); 
	private final IOutputProcessor outputProcessor = null; 


	/* (non-Javadoc)
	 * @see org.eclipse.higgins.registry.IServiceProvider#getConfiguration()
	 */
	public IConfiguration getConfiguration() {
		return null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.registry.IServiceProvider#getID()
	 */
	public String getID() {
		return FORMAT_ID;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.registry.IServiceProvider#setID(java.lang.String)
	 */
	public void setID(String id) throws Exception {
		throw new UnsupportedOperationException();
	}

	public IFormatDescriptor getFormatDescriptor() {
		return formatDescriptor;
	}

	public IInputProcessor getInputProcessor() {
		return inputProcessor;
	}

	public IOutputProcessor getOutputProcessor() {
		return outputProcessor;
	}

}
