/*******************************************************************************
 * Copyright (c) 2007-2008 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Valery Kokhan - Initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.icard.provider.cardspace.common.io;

import java.io.InputStream;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.icard.auth.ICredential;
import org.eclipse.higgins.icard.io.CardIOException;
import org.eclipse.higgins.icard.io.IElement;
import org.eclipse.higgins.icard.io.IFormatDescriptor;
import org.eclipse.higgins.icard.io.IInputProcessor;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.CardContext;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.CardCryptography;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.CardUtils;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.XMLUtils;
import org.w3c.dom.Element;

public class CRDInputProcessor implements IInputProcessor {
	private Log log = LogFactory.getLog(CRDInputProcessor.class);

	public IFormatDescriptor checkInput(InputStream is) {
		IFormatDescriptor format = null;
		try {
			Element crd = CardCryptography.getCardFromSignedEnvelop(is);
			Element cardMetaData = null;
			if (CardContext.IC_INFORMATION_CARD.equals(crd.getLocalName()))
				cardMetaData = crd;
			else if (CardContext.IC_ROAMING_INFORMATION_CARD.equals(crd.getLocalName())) {
				cardMetaData = XMLUtils.getChildElement(crd, CardContext.IC_NS, CardContext.IC_INFORMATION_CARD_META_DATA);
			}
			if (cardMetaData != null) {
				if (!CardUtils.isSelfIssued(cardMetaData)) {
					format = CRDFormatProvider.formatDescriptor;
				}
			}
			
		} catch (Exception e) {
			format = null;
			log.trace(e);
		}
		return format;
	}

	public IElement[] process(InputStream is, ICredential credential) throws CardIOException {
		IElement[] res = null;
		
		try {
			Element crd = CardCryptography.getCardFromSignedEnvelop(is);
			Element card = null;
			
			if (CardContext.IC_INFORMATION_CARD.equals(crd.getLocalName()))
				card = crd;
			else if (CardContext.IC_ROAMING_INFORMATION_CARD.equals(crd.getLocalName())) {
				card = XMLUtils.getChildElement(crd, CardContext.IC_NS, CardContext.IC_INFORMATION_CARD_META_DATA);
			}
			if (card != null) {
				if (!CardUtils.isSelfIssued(card)) {
					IElement e = new IOICardElement();
					e.set(card);
					res = new IElement[1];
					res[0] = e;
				} else {
					log.trace("Can't process self issued card element"); 
				}
			} else {
				log.trace("Can't find card element"); 
			}
		} catch (Exception e) {
			log.error(e);
		}
		
		return res;
	}
}
