package org.eclipse.higgins.icard.provider.cardspace.common.io;

import java.io.FileOutputStream;
import java.io.OutputStream;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.icard.auth.ICredential;
import org.eclipse.higgins.icard.auth.IPasswordCredential;
import org.eclipse.higgins.icard.io.CardIOException;
import org.eclipse.higgins.icard.io.IElement;
import org.eclipse.higgins.icard.io.IOutputProcessor;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.CardContext;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.CardCryptography;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CRDSOutputProcessor implements IOutputProcessor {
	private Log log = LogFactory.getLog(CRDSOutputProcessor.class);

	public void process(IElement[] icards, OutputStream out, ICredential credential) throws CardIOException {
		IPasswordCredential pc = null;
		String password = null;
		if (credential instanceof IPasswordCredential) {
			pc = (IPasswordCredential) credential;
			password = pc.getPassword();
		} 
		
		if (pc == null) {
			throw new CardIOException("Invalid credential type: " + credential);
		}
		
		if (password == null) {
			throw new CardIOException("Password can't be null");
		}
		
		try {
			DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
			dbf.setIgnoringComments(true);
			dbf.setIgnoringElementContentWhitespace(true);
			dbf.setNamespaceAware(true);
			dbf.setValidating(false);
			DocumentBuilder db = dbf.newDocumentBuilder();

			Document doc = db.newDocument();
			Element store = doc.createElementNS(CardContext.IC_NS, CardContext.IC_ROAMING_STORE); 
			doc.appendChild(store);

			for (int i = 0; i < icards.length; i++) {
				Element e = (Element) icards[i].getAs(Element.class);
				Element card = (Element) doc.importNode(e, true);
				store.appendChild(card);
			}
			//TODO  why is it for?
			//writeDoc(doc, new FileOutputStream("D:/temp/b/test1.xml"));
			
			CardCryptography.encrypt(doc, out, password);
		} catch (Exception e) {
			log.error("Can't export cards", e);
			throw new CardIOException("Can't export cards", e);
		}
	}

	private void writeDoc(Document doc, OutputStream os) {
		try {
			TransformerFactory transformerFactory = TransformerFactory.newInstance();
			Transformer transformer = transformerFactory.newTransformer();
			transformer.setOutputProperty(OutputKeys.METHOD, "xml"); //$NON-NLS-1$
			transformer.setOutputProperty(OutputKeys.INDENT, "yes"); //$NON-NLS-1$
			DOMSource source = new DOMSource(doc);
			StreamResult result = new StreamResult(os);
			transformer.transform(source, result);
			os.flush();
		} catch (Exception ex) {
			ex.printStackTrace();
		}
	}
}
