/**
 * Copyright (c) 2007-2008 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Sergey Lyakhov - initial API and implementation
 *     Valery Kokhan
 */

package org.eclipse.higgins.icard.provider.cardspace.common.utils;

import javax.xml.namespace.QName;

/**
 * Defines constants useful to work with cardstore format. 
 */
public interface CardContext {

	// Namespaces
	public static final String IC_NS = "http://schemas.xmlsoap.org/ws/2005/05/identity";

	public static final String TRUST_NS = "http://schemas.xmlsoap.org/ws/2005/02/trust";

	public static final String WSA_NS = "http://www.w3.org/2005/08/addressing";

	public static final String MEX_NS = "http://schemas.xmlsoap.org/ws/2004/09/mex";

	public static final String WSAI_NS = "http://schemas.xmlsoap.org/ws/2006/02/addressingidentity";

	public static final String DSIG_NS = "http://www.w3.org/2000/09/xmldsig#";

	public static final String XE_NS = "http://www.w3.org/2001/04/xmlenc#";
	
	// Local element names
	public final static String IC_ENCRYPTED_STORE = "EncryptedStore";
	
	public final static String IC_ROAMING_STORE = "RoamingStore";
	
	public final static String IC_ROAMING_INFORMATION_CARD = "RoamingInformationCard";
	
	public final static String IC_STORE_SALT = "StoreSalt";
	
	public final static String IC_INFORMATION_CARD = "InformationCard";
	
	public final static String IC_INFORMATION_CARD_META_DATA = "InformationCardMetaData";
	
	public final static String IC_INFORMATION_CARD_PRIVATE_DATA = "InformationCardPrivateData";
	
	public final static String IC_MASTER_KEY = "MasterKey";
	
	public final static String IC_CLAIM_VALUE = "ClaimValue";
	
	public final static String IC_CLAIM_VALUE_LIST = "ClaimValueList";
	
	public final static String IC_VALUE = "Value";
	
	public final static String IC_INFORMATION_CARD_REFERENCE = "InformationCardReference";
	
	public final static String IC_CARD_ID = "CardId";
	
	public final static String IC_CARD_VERSION = "CardVersion";
	
	public final static String IC_CARD_NAME = "CardName";
	
	public final static String IC_CARD_IMAGE = "CardImage";
	
	public final static String IC_ISSUER = "Issuer";
	
	public final static String IC_TIME_ISSUED = "TimeIssued";
	
	public final static String IC_TIME_EXPIRES = "TimeExpires";
	
	public final static String IC_SUPPORTED_TOKEN_TYPE_LIST = "SupportedTokenTypeList";
	
	public final static String IC_SUPPORTED_CLAIM_TYPE_LIST = "SupportedClaimTypeList";
	
	public final static String IC_SUPPORTED_CLAIM_TYPE = "SupportedClaimType";
	
	public final static String IC_DISPLAY_TAG = "DisplayTag";
	
	public final static String IC_DESCRIPTION = "Description";
	
	public final static String IC_IS_SELF_ISSUED = "IsSelfIssued";
	
	public final static String IC_HASH_SALT = "HashSalt";
	
	public final static String IC_TIME_LAST_UPDATED = "TimeLastUpdated";
	
	public final static String IC_ISSUER_ID = "IssuerId";
	
	public final static String IC_ISSUER_NAME = "IssuerName";
	
	public final static String IC_BACK_GROUND_COLOR = "BackgroundColor";
	
	public final static String IC_PIN_DIGEST = "PinDigest";
	
	public final static String IC_REQUIRE_APPLIES_TO = "RequireAppliesTo";
	
	public final static String IC_PRIVACY_NOTICE = "PrivacyNotice";
	
	public final static String IC_USERNAME_PASSWORD_CREDENTIAL = "UsernamePasswordCredential";

	public final static String IC_USERNAME = "Username";
	
	public final static String IC_SELF_ISSUED_CREDENTIAL = "SelfIssuedCredential";
	
	public final static String IC_PRIVATE_PERSONAL_IDENTIFIER = "PrivatePersonalIdentifier";
	
	public final static String IC_USER_CREDENTIAL = "UserCredential";
	
	public final static String IC_KERBEROS_V5_CREDENTIAL = "KerberosV5Credential";
	
	public final static String IC_DISPLAY_CREDENTIAL_HINT = "DisplayCredentialHint";
	
	public final static String IC_X509_V3_CREDENTIAL = "X509V3Credential";
	
	public final static String IC_TOKEN_SERVICE = "TokenService";
	
	public final static String IC_TOKEN_SERVICE_LIST = "TokenServiceList";
	
	
	
	public final static String DSIG_X509_DATA = "X509Data";
	
	public final static String DSIG_KEY_INFO = "KeyInfo";
	
	public final static String DSIG_X509_CERTIFICATE = "X509Certificate";
	

	
	public final static String XE_ENCRYPTED_DATA = "EncryptedData";
	
	public final static String XE_CIPHER_DATA = "CipherData";
	
	public final static String XE_CIPHER_VALUE = "CipherValue";

	
	public final static String TRUST_TOKEN_TYPE = "TokenType";
	
	
	public final static String WSA_ENDPOINT_REFERENCE = "EndpointReference";
	
	public final static String WSA_METADATA = "Metadata";
	
	public final static String WSA_ADDRESS = "Address";
	
	
	public final static String WSAI_IDENTITY = "Identity";
	
	// Qualified element names
	public final static QName QN_IC_ENCRYPTED_STORE = new QName(IC_NS, IC_ENCRYPTED_STORE);
	
	public final static QName QN_IC_ROAMING_STORE = new QName(IC_NS, IC_ROAMING_STORE);
	
	public final static QName QN_IC_ROAMING_INFORMATION_CARD = new QName(IC_NS, IC_ROAMING_INFORMATION_CARD);
	
	public final static QName QN_IC_STORE_SALT = new QName(IC_NS, IC_STORE_SALT);
	
	public final static QName QN_IC_INFORMATION_CARD = new QName(IC_NS, IC_INFORMATION_CARD);
	
	public final static QName QN_IC_INFORMATION_CARD_META_DATA = new QName(IC_NS, IC_INFORMATION_CARD_META_DATA);
	
	public final static QName QN_IC_INFORMATION_CARD_PRIVATE_DATA = new QName(IC_NS, IC_INFORMATION_CARD_PRIVATE_DATA);
	
	public final static QName QN_IC_MASTER_KEY = new QName(IC_NS, IC_MASTER_KEY);
	
	public final static QName QN_IC_CLAIM_VALUE = new QName(IC_NS, IC_CLAIM_VALUE);
	
	public final static QName QN_IC_CLAIM_VALUE_LIST = new QName(IC_NS, IC_CLAIM_VALUE_LIST);
	
	public final static QName QN_IC_VALUE = new QName(IC_NS, IC_VALUE);
	
	public final static QName QN_IC_INFORMATION_CARD_REFERENCE = new QName(IC_NS, IC_INFORMATION_CARD_REFERENCE);
	
	public final static QName QN_IC_CARD_ID = new QName(IC_NS, IC_CARD_ID);
	
	public final static QName QN_IC_CARD_VERSION = new QName(IC_NS, IC_CARD_VERSION);
	
	public final static QName QN_IC_CARD_NAME = new QName(IC_NS, IC_CARD_NAME);
	
	public final static QName QN_IC_CARD_IMAGE = new QName(IC_NS, IC_CARD_IMAGE);
	
	public final static QName QN_IC_ISSUER = new QName(IC_NS, IC_ISSUER);
	
	public final static QName QN_IC_TIME_ISSUED = new QName(IC_NS, IC_TIME_ISSUED);
	
	public final static QName QN_IC_TIME_EXPIRES = new QName(IC_NS, IC_TIME_EXPIRES);
	
	public final static QName QN_IC_SUPPORTED_TOKEN_TYPE_LIST = new QName(IC_NS, IC_SUPPORTED_TOKEN_TYPE_LIST);
	
	public final static QName QN_IC_SUPPORTED_CLAIM_TYPE_LIST = new QName(IC_NS, IC_SUPPORTED_CLAIM_TYPE_LIST);
	
	public final static QName QN_IC_SUPPORTED_CLAIM_TYPE = new QName(IC_NS, IC_SUPPORTED_CLAIM_TYPE);
	
	public final static QName QN_IC_DISPLAY_TAG = new QName(IC_NS, IC_DISPLAY_TAG);
	
	public final static QName QN_IC_DESCRIPTION = new QName(IC_NS, IC_DESCRIPTION);
	
	public final static QName QN_IC_IS_SELF_ISSUED = new QName(IC_NS, IC_IS_SELF_ISSUED);
	
	public final static QName QN_IC_HASH_SALT = new QName(IC_NS, IC_HASH_SALT);
	
	public final static QName QN_IC_TIME_LAST_UPDATED = new QName(IC_NS, IC_TIME_LAST_UPDATED);
	
	public final static QName QN_IC_ISSUER_ID = new QName(IC_NS, IC_ISSUER_ID);
	
	public final static QName QN_IC_ISSUER_NAME = new QName(IC_NS, IC_ISSUER_NAME);
	
	public final static QName QN_IC_BACK_GROUND_COLOR = new QName(IC_NS, IC_BACK_GROUND_COLOR);
	
	public final static QName QN_IC_PIN_DIGEST = new QName(IC_NS, IC_PIN_DIGEST);
	
	public final static QName QN_IC_REQUIRE_APPLIES_TO = new QName(IC_NS, IC_REQUIRE_APPLIES_TO);
	
	public final static QName QN_IC_PRIVACY_NOTICE = new QName(IC_NS, IC_PRIVACY_NOTICE);
	
	public final static QName QN_IC_USERNAME_PASSWORD_CREDENTIAL = new QName(IC_NS, IC_USERNAME_PASSWORD_CREDENTIAL);

	public final static QName QN_IC_USERNAME = new QName(IC_NS, IC_USERNAME);
	
	public final static QName QN_IC_SELF_ISSUED_CREDENTIAL = new QName(IC_NS, IC_SELF_ISSUED_CREDENTIAL);
	
	public final static QName QN_IC_PRIVATE_PERSONAL_IDENTIFIER = new QName(IC_NS, IC_PRIVATE_PERSONAL_IDENTIFIER);
	
	public final static QName QN_IC_USER_CREDENTIAL = new QName(IC_NS, IC_USER_CREDENTIAL);
	
	public final static QName QN_IC_KERBEROS_V5_CREDENTIAL = new QName(IC_NS, IC_KERBEROS_V5_CREDENTIAL);
	
	public final static QName QN_IC_DISPLAY_CREDENTIAL_HINT = new QName(IC_NS, IC_DISPLAY_CREDENTIAL_HINT);
	
	public final static QName QN_IC_X509_V3_CREDENTIAL = new QName(IC_NS, IC_X509_V3_CREDENTIAL);
	
	public final static QName QN_IC_TOKEN_SERVICE = new QName(IC_NS, IC_TOKEN_SERVICE);
	
	public final static QName QN_IC_TOKEN_SERVICE_LIST = new QName(IC_NS, IC_TOKEN_SERVICE_LIST);
	
	
	
	public final static QName QN_DSIG_X509_DATA = new QName(DSIG_NS, DSIG_X509_DATA);
	
	public final static QName QN_DSIG_KEY_INFO = new QName(DSIG_NS, DSIG_KEY_INFO);
	
	public final static QName QN_DSIG_X509_CERTIFICATE = new QName(DSIG_NS, DSIG_X509_CERTIFICATE);
	

	
	public final static QName QN_XE_ENCRYPTED_DATA = new QName(XE_NS, XE_ENCRYPTED_DATA);
	
	public final static QName QN_XE_CIPHER_DATA = new QName(XE_NS, XE_CIPHER_DATA);
	
	public final static QName QN_XE_CIPHER_VALUE = new QName(XE_NS, XE_CIPHER_VALUE);

	
	public final static QName QN_TRUST_TOKEN_TYPE = new QName(TRUST_NS, TRUST_TOKEN_TYPE);
	
	
	public final static QName QN_WSA_ENDPOINT_REFERENCE = new QName(WSA_NS, WSA_ENDPOINT_REFERENCE);
	
	public final static QName QN_WSA_METADATA = new QName(WSA_NS, WSA_METADATA);
	
	public final static QName QN_WSA_ADDRESS = new QName(WSA_NS, WSA_ADDRESS);
	
	
	public final static QName QN_WSAI_IDENTITY = new QName(WSAI_NS, WSAI_IDENTITY);
}
