/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.icard.provider.cardspace.common;

import java.io.ByteArrayInputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.LinkedList;
import javax.security.auth.callback.CallbackHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.icard.AuthenticationException;
import org.eclipse.higgins.icard.CUID;
import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.icard.ICard;
import org.eclipse.higgins.icard.ICardTemplate;
import org.eclipse.higgins.icard.IPolicy;
import org.eclipse.higgins.icard.ISimpleClaim;
import org.eclipse.higgins.icard.ISimpleClaimType;
import org.eclipse.higgins.icard.auth.ICredential;
import org.eclipse.higgins.icard.common.BasicCardProvider;
import org.eclipse.higgins.icard.common.ClaimValue;
import org.eclipse.higgins.icard.io.IElement;
import org.eclipse.higgins.icard.provider.cardspace.common.CardSpacePolicy;
import org.eclipse.higgins.icard.provider.cardspace.common.DummyManagedCard;
import org.eclipse.higgins.icard.provider.cardspace.common.ManagedCard;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.CardCryptography;
import org.eclipse.higgins.iss.ICardSelectorService;
import org.eclipse.higgins.iss.IDisplayToken;
import org.eclipse.higgins.iss.IICardSelector;
import org.eclipse.higgins.iss.IIdentityToken;
import org.eclipse.higgins.iss.SelectionANDofORs;
import org.eclipse.higgins.iss.SelectionANDofORsElm;
import org.w3c.dom.Element;

public abstract class ManagedCardProvider
extends BasicCardProvider {
    protected Log log = LogFactory.getLog((Class)(class$org$eclipse$higgins$icard$provider$cardspace$common$ManagedCardProvider == null ? (class$org$eclipse$higgins$icard$provider$cardspace$common$ManagedCardProvider = ManagedCardProvider.class$("org.eclipse.higgins.icard.provider.cardspace.common.ManagedCardProvider")) : class$org$eclipse$higgins$icard$provider$cardspace$common$ManagedCardProvider));
    protected static String strCertificate = "MIICVDCCAb2gAwIBAgIERWUHrzANBgkqhkiG9w0BAQUFADBQMQswCQYDVQQGEwJVUzEYMBYGA1UEChMPSUJNIENvcnBvcmF0aW9uMRUwEwYDVQQLEwxJQk0gUmVzZWFyY2gxEDAOBgNVBAMTB1Jvb3QgQ0EwHhcNMDYxMTIzMDIyOTU3WhcNMjYxMTE4MDIyOTU3WjBFMQswCQYDVQQGEwJVUzEQMA4GA1UEChMHRWNsaXBzZTEQMA4GA1UECxMHSGlnZ2luczESMBAGA1UEAxMJbG9jYWxob3N0MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCUFDtM2/nLEhSJqF7zqayW8gQ183KCiKME53VkSjl6C7O9J2hEiBMWsI9a+qBm13VWKvmTc3h3EsLaR/dOreXyCLKEwDIpwHojW3+i037OOxL6U3Ij094rqfHBCJP2xEyLNpPXdIioEgP5H6MTRPXShsBsTQ7bEhZs0QKyXwTNHwIDAQABo0YwRDAdBgNVHQ4EFgQUTHM9O3KViNYsvuGeg4eANMCFHuMwEwYDVR0lBAwwCgYIKwYBBQUHAwEwDgYDVR0PAQH/BAQDAgSwMA0GCSqGSIb3DQEBBQUAA4GBADkZZ34T637gwxp/EmRlRd4ru1Y2ribGoLRpY1icJYlyrUB3552f1K7r69EQxuwnyUnFYVhB+4ZnzhralkKtNs8UVo7RZHSE8jKWOi4YU3RXSqEHKs10ttQLLcHPuH4o9t2OJLeaVtaijbdicbxUEwqhgcNnNrQHe6+f5fgwzSYM";
    protected X509Certificate certificate = null;
    static /* synthetic */ Class class$org$eclipse$higgins$icard$provider$cardspace$common$ManagedCardProvider;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$eclipse$higgins$iss$IDisplayToken;
    static /* synthetic */ Class class$org$eclipse$higgins$icard$IManagedInformationCard;
    static /* synthetic */ Class class$org$w3c$dom$Element;

    public ICard getICardByCUID(CallbackHandler authHandler, CUID cuid, ICredential userCredential) throws AuthenticationException, CardException {
        ICard card = this.getICardByCUID(authHandler, cuid);
        if (card instanceof ManagedCard) {
            ManagedCard mcard = (ManagedCard)card;
            CardSpacePolicy p = new CardSpacePolicy();
            p.setRequiredClaims(mcard.getSupportedClaimTypesUris());
            try {
                ICardSelectorService iss = ICardSelectorService.getInstance();
                IICardSelector s = iss.getICardSelector(authHandler, (IPolicy)p);
                SelectionANDofORs selection = new SelectionANDofORs();
                selection.add(new SelectionANDofORsElm(mcard.getCUID().toString(), 0, 0));
                selection.setCredential(userCredential);
                selection.sslCertChain = new X509Certificate[]{this.getCertificate()};
                LinkedList<ISimpleClaim> claims = new LinkedList<ISimpleClaim>();
                IIdentityToken t = s.getIdentityToken(selection);
                t.getAs(class$java$lang$String == null ? (class$java$lang$String = ManagedCardProvider.class$("java.lang.String")) : class$java$lang$String);
                IDisplayToken dt = (IDisplayToken)t.getAs(class$org$eclipse$higgins$iss$IDisplayToken == null ? (class$org$eclipse$higgins$iss$IDisplayToken = ManagedCardProvider.class$("org.eclipse.higgins.iss.IDisplayToken")) : class$org$eclipse$higgins$iss$IDisplayToken);
                System.err.println(dt.getAs(class$java$lang$String == null ? (class$java$lang$String = ManagedCardProvider.class$("java.lang.String")) : class$java$lang$String));
                Iterator itr = mcard.getSupportedClaimTypes();
                while (itr.hasNext()) {
                    ISimpleClaimType ct = (ISimpleClaimType)itr.next();
                    ISimpleClaim c = (ISimpleClaim)dt.getClaim(ct.getType());
                    if (c == null) {
                        c = new ClaimValue(ct, "");
                    }
                    claims.add(c);
                }
                mcard.setClaims(claims);
                return mcard;
            }
            catch (Exception e) {
                throw new CardException((Throwable)e);
            }
        }
        throw new CardException("Unsupported card type: " + card);
    }

    public ICardTemplate[] getCardCreationTemplates(CallbackHandler authHandler) {
        return null;
    }

    public Class[] getSupportedTypes() {
        return new Class[]{class$org$eclipse$higgins$icard$IManagedInformationCard == null ? (class$org$eclipse$higgins$icard$IManagedInformationCard = ManagedCardProvider.class$("org.eclipse.higgins.icard.IManagedInformationCard")) : class$org$eclipse$higgins$icard$IManagedInformationCard};
    }

    protected X509Certificate getCertificate() {
        if (this.certificate == null) {
            try {
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                String strEncryptionCertificate = "-----BEGIN CERTIFICATE-----\n" + strCertificate + "\n-----END CERTIFICATE-----\n";
                ByteArrayInputStream streamCertificate = new ByteArrayInputStream(strEncryptionCertificate.getBytes());
                this.certificate = (X509Certificate)certificateFactory.generateCertificate(streamCertificate);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.certificate;
    }

    public boolean canImportICard(CallbackHandler authHandler, IElement element) {
        if (element == null) {
            return false;
        }
        try {
            Element card = (Element)element.getAs(class$org$w3c$dom$Element == null ? (class$org$w3c$dom$Element = ManagedCardProvider.class$("org.w3c.dom.Element")) : class$org$w3c$dom$Element);
            if (card == null) {
                return false;
            }
            Element crd = null;
            crd = "Signature".equals(card.getLocalName()) ? CardCryptography.getCardFromSignedEnvelop(card) : card;
            DummyManagedCard c = new DummyManagedCard();
            c.initFromXML(crd);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log.error((Object)e);
            return false;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

