/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.icard.provider.cardspace.common.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.Init;
import org.apache.xml.security.exceptions.Base64DecodingException;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.utils.Base64;
import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.EncryptedMasterKey;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class CardCryptography {
    private static Log log = LogFactory.getLog((Class)(class$org$eclipse$higgins$icard$provider$cardspace$common$utils$CardCryptography == null ? (class$org$eclipse$higgins$icard$provider$cardspace$common$utils$CardCryptography = CardCryptography.class$("org.eclipse.higgins.icard.provider.cardspace.common.utils.CardCryptography")) : class$org$eclipse$higgins$icard$provider$cardspace$common$utils$CardCryptography));
    private static final byte[] BOM = new byte[]{-17, -69, -65};
    private static final byte[] ENCRYPTION_KEY_ENTROPY = new byte[]{-39, 89, 123, 38, 30, -40, -77, 68, -109, 35, -77, -106, -123, -34, -107, -4};
    private static final byte[] INTEGRITY_KEY_ENTROPY = new byte[]{-60, 1, 123, -15, 107, -83, 47, 66, -81, -12, -105, 125, 4, 104, 3, -37};
    static /* synthetic */ Class class$org$eclipse$higgins$icard$provider$cardspace$common$utils$CardCryptography;

    private static Document parseEncryptedStore(InputStream is) throws ParserConfigurationException, SAXException, IOException {
        is.skip(BOM.length);
        DocumentBuilder db = CardCryptography.createDocumentBuilder();
        return db.parse(is);
    }

    private static Document parseDecryptedData(byte[] data) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilder db = CardCryptography.createDocumentBuilder();
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        return db.parse(bis);
    }

    private static DocumentBuilder createDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setIgnoringComments(true);
        dbf.setIgnoringElementContentWhitespace(true);
        dbf.setNamespaceAware(true);
        dbf.setValidating(false);
        return dbf.newDocumentBuilder();
    }

    public static byte[] getSubArray(byte[] array, int offset, int len) {
        byte[] newArr = new byte[len];
        System.arraycopy(array, offset, newArr, 0, len);
        return newArr;
    }

    private static byte[] decryptData(byte[] encryptedData, byte[] initVector, Key encryptionKey) throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, CardException {
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        IvParameterSpec ips = new IvParameterSpec(initVector);
        cipher.init(2, encryptionKey, ips);
        try {
            return cipher.doFinal(encryptedData);
        }
        catch (BadPaddingException e) {
            log.error((Object)e);
            throw new CardException(e.getMessage() + ". Wrong password or corrupted data.");
        }
    }

    private static byte[] calculateIntegityHash(byte[] iv, byte[] integrityKey, byte[] decryptedData) throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        byte[] lastDataBlock = CardCryptography.getSubArray(decryptedData, decryptedData.length - 16, 16);
        byte[] key = CardCryptography.concat(iv, integrityKey);
        key = CardCryptography.concat(key, lastDataBlock);
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        return md.digest(key);
    }

    public static Document decrypt(InputStream is, String password) throws Exception {
        if (is == null) {
            throw new IllegalArgumentException("Parameter \"is\" is null");
        }
        if (password == null) {
            throw new IllegalArgumentException("Parameter \"password\" is null");
        }
        Document encriptedData = CardCryptography.parseEncryptedStore(is);
        Element encryptedStoreElm = encriptedData.getDocumentElement();
        Element storeSaltElm = XMLUtils.getChildElement(encryptedStoreElm, "http://schemas.xmlsoap.org/ws/2005/05/identity", "StoreSalt");
        byte[] storeSalt = Base64.decode((String)XMLUtils.getTextContent(storeSaltElm));
        Element encryptedDataElm = XMLUtils.getChildElement(encryptedStoreElm, "http://www.w3.org/2001/04/xmlenc#", "EncryptedData");
        Element cipherDataElm = XMLUtils.getChildElement(encryptedDataElm, "http://www.w3.org/2001/04/xmlenc#", "CipherData");
        Element cipherValueElm = XMLUtils.getChildElement(cipherDataElm, "http://www.w3.org/2001/04/xmlenc#", "CipherValue");
        byte[] cipherValue = Base64.decode((String)XMLUtils.getTextContent(cipherValueElm));
        if (cipherValue.length < 48) {
            throw new CardException("Cardspace backup file is garbled. Decoded CipherValue byte array is too short.");
        }
        byte[] initVector = CardCryptography.getSubArray(cipherValue, 0, 16);
        byte[] integrityHash = CardCryptography.getSubArray(cipherValue, 16, 32);
        byte[] encryptedData = CardCryptography.getSubArray(cipherValue, 48, cipherValue.length - 48);
        byte[] derivedKey = CardCryptography.getDerivedKey(password.getBytes("UTF-16LE"), storeSalt);
        Key encryptionKey = CardCryptography.getEncryptionKey(derivedKey);
        byte[] integrityKey = CardCryptography.getIntegrityKey(derivedKey);
        byte[] decryptedData = CardCryptography.decryptData(encryptedData, initVector, encryptionKey);
        byte[] calculatedIntegityHash = CardCryptography.calculateIntegityHash(initVector, integrityKey, decryptedData = CardCryptography.getSubArray(decryptedData, BOM.length, decryptedData.length - BOM.length));
        if (!Arrays.equals(calculatedIntegityHash, integrityHash)) {
            throw new CardException("Cardspace backup file is garbled. Integrity checking failed.");
        }
        return CardCryptography.parseDecryptedData(decryptedData);
    }

    public static boolean isEncriptedStore(InputStream is) {
        boolean res = false;
        try {
            if (is == null) {
                return res;
            }
            Document encriptedData = CardCryptography.parseEncryptedStore(is);
            Element encryptedStoreElm = encriptedData.getDocumentElement();
            Element storeSaltElm = XMLUtils.getChildElement(encryptedStoreElm, "http://schemas.xmlsoap.org/ws/2005/05/identity", "StoreSalt");
            byte[] storeSalt = Base64.decode((String)XMLUtils.getTextContent(storeSaltElm));
            if (storeSalt != null) {
                Element encryptedDataElm = XMLUtils.getChildElement(encryptedStoreElm, "http://www.w3.org/2001/04/xmlenc#", "EncryptedData");
                Element cipherDataElm = XMLUtils.getChildElement(encryptedDataElm, "http://www.w3.org/2001/04/xmlenc#", "CipherData");
                Element cipherValueElm = XMLUtils.getChildElement(cipherDataElm, "http://www.w3.org/2001/04/xmlenc#", "CipherValue");
                byte[] cipherValue = Base64.decode((String)XMLUtils.getTextContent(cipherValueElm));
                res = cipherValue.length >= 48;
            }
        }
        catch (Exception e) {
            log.trace((Object)e);
            res = false;
        }
        return res;
    }

    public static byte[] encryptData(byte[] data, byte[] initVector, Key encryptionKey) throws Exception {
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        IvParameterSpec ips = new IvParameterSpec(initVector);
        cipher.init(1, encryptionKey, ips);
        return cipher.doFinal(data);
    }

    private static byte[] convert(Document doc) throws TransformerException, IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(100000);
        bos.write(BOM);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(bos);
        transformer.transform(source, result);
        return bos.toByteArray();
    }

    private static byte[] getCipherValue(byte[] data, byte[] salt, String password) throws Exception {
        byte[] initVector = SecureRandom.getSeed(16);
        byte[] derivedKey = CardCryptography.getDerivedKey(password.getBytes("UTF-16LE"), salt);
        Key encryptionKey = CardCryptography.getEncryptionKey(derivedKey);
        byte[] integrityKey = CardCryptography.getIntegrityKey(derivedKey);
        byte[] encryptedData = CardCryptography.encryptData(data, initVector, encryptionKey);
        byte[] integrityHash = CardCryptography.calculateIntegityHash(initVector, integrityKey, data);
        byte[] cipherValue = CardCryptography.concat(initVector, integrityHash);
        cipherValue = CardCryptography.concat(cipherValue, encryptedData);
        return cipherValue;
    }

    private static Document createEncryptedStore(byte[] salt, byte[] cipherVal) throws ParserConfigurationException {
        DocumentBuilder db = CardCryptography.createDocumentBuilder();
        Document doc = db.newDocument();
        Element root = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "EncryptedStore");
        doc.appendChild(root);
        Element storeSalt = doc.createElement("StoreSalt");
        XMLUtils.setTextContent(storeSalt, new String(Base64.encode((byte[])salt)));
        root.appendChild(storeSalt);
        Element encryptedData = doc.createElementNS("http://www.w3.org/2001/04/xmlenc#", "EncryptedData");
        root.appendChild(encryptedData);
        Element cipherData = doc.createElement("CipherData");
        encryptedData.appendChild(cipherData);
        Element cipherValue = doc.createElement("CipherValue");
        XMLUtils.setTextContent(cipherValue, new String(Base64.encode((byte[])cipherVal)));
        cipherData.appendChild(cipherValue);
        return doc;
    }

    private static Document encrypt(Document cardsStore, String password) throws Exception {
        byte[] data = CardCryptography.convert(cardsStore);
        byte[] salt = SecureRandom.getSeed(16);
        byte[] cipherValue = CardCryptography.getCipherValue(data, salt, password);
        return CardCryptography.createEncryptedStore(salt, cipherValue);
    }

    public static void encrypt(Document cardsStore, OutputStream os, String password) throws Exception {
        Document encryptedStore = CardCryptography.encrypt(cardsStore, password);
        os.write(BOM);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("method", "xml");
        DOMSource source = new DOMSource(encryptedStore);
        StreamResult result = new StreamResult(os);
        transformer.transform(source, result);
        os.flush();
    }

    private static byte[] concat(byte[] arr1, byte[] arr2) {
        byte[] newArr = new byte[arr1.length + arr2.length];
        System.arraycopy(arr1, 0, newArr, 0, arr1.length);
        System.arraycopy(arr2, 0, newArr, arr1.length, arr2.length);
        return newArr;
    }

    private static byte[] getIntegrityKey(byte[] derivedKey) throws NoSuchAlgorithmException {
        MessageDigest hash = MessageDigest.getInstance("SHA-256");
        byte[] key = CardCryptography.concat(INTEGRITY_KEY_ENTROPY, derivedKey);
        return hash.digest(key);
    }

    public static byte[] getDerivedKey(byte[] password, byte[] salt) throws NoSuchAlgorithmException {
        MessageDigest hash = MessageDigest.getInstance("SHA-256");
        byte[] key = CardCryptography.concat(password, salt);
        for (int i = 0; i < 1000; ++i) {
            key = hash.digest(key);
        }
        return key;
    }

    private static Key getEncryptionKey(byte[] derivedKey) throws NoSuchAlgorithmException {
        MessageDigest hash = MessageDigest.getInstance("SHA-256");
        byte[] key = CardCryptography.concat(ENCRYPTION_KEY_ENTROPY, derivedKey);
        key = hash.digest(key);
        return new SecretKeySpec(key, "AES");
    }

    public static Element getCardFromSignedEnvelop(InputStream signedCard) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setIgnoringComments(true);
        dbf.setIgnoringElementContentWhitespace(true);
        dbf.setNamespaceAware(true);
        dbf.setValidating(false);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(signedCard);
        Element sigElement = doc.getDocumentElement();
        return CardCryptography.getCardFromSignedEnvelop(sigElement);
    }

    public static Element getCardFromSignedEnvelop(Element sigElement) throws Exception {
        if (sigElement == null) {
            throw new CardException("Parameter \"sigElement\" is null");
        }
        XMLSignature signature = new XMLSignature(sigElement, "");
        KeyInfo ki = signature.getKeyInfo();
        if (ki == null) {
            throw new CardException("Couldn't find a KeyInfo element in signed envelop.");
        }
        if (!ki.containsX509Data()) {
            throw new CardException("Couldn't find a X509Data element in the KeyInfo.");
        }
        X509Certificate cert = signature.getKeyInfo().getX509Certificate();
        if (cert == null) {
            throw new CardException("Couldn't find a certificate.");
        }
        if (!signature.checkSignatureValue(cert)) {
            throw new CardException("Signature is invalid.");
        }
        if (signature.getObjectLength() != 1) {
            throw new CardException("Signature contains wrong count of objects (only one object container expected).");
        }
        Element obj = signature.getObjectItem(0).getElement();
        NodeList nl = obj.getChildNodes();
        Element card = null;
        int len = nl.getLength();
        for (int i = 0; i < len; ++i) {
            Element elm;
            Node node = nl.item(i);
            if (node.getNodeType() != 1 || !"InformationCard".equals((elm = (Element)node).getLocalName())) continue;
            card = elm;
            break;
        }
        if (card == null) {
            throw new CardException("Object container doesn't contain InformationCard element.");
        }
        return card;
    }

    public static String encodeBase64(byte[] data, int wrappedStringlen) {
        return Base64.encode((byte[])data, (int)wrappedStringlen);
    }

    public static byte[] decodeBase64(String data) throws CardException {
        try {
            return Base64.decode((String)data);
        }
        catch (Base64DecodingException e) {
            log.error((Object)e);
            throw new CardException(e.getMessage());
        }
    }

    public static String getBase64Hash(int bytesCount) {
        return CardCryptography.encodeBase64(SecureRandom.getSeed(bytesCount), 0);
    }

    public static byte[] getRandomBytes(int bytesCount) {
        return SecureRandom.getSeed(bytesCount);
    }

    public static byte[] decryptPersonalCardField(byte[] encryptedData, EncryptedMasterKey key) throws CardException {
        byte[] decryptedData = null;
        try {
            decryptedData = CardCryptography.decryptData(encryptedData, key.getInitVector(), key.getKey());
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new CardException(e.getMessage());
        }
        return decryptedData;
    }

    public static byte[] encryptPersonalCardField(byte[] data, byte[] salt, byte[] initVector, byte[] pinCode) throws CardException {
        byte[] encryptedData;
        byte[] derivedKey;
        if (pinCode == null) {
            throw new CardException("Parameter \"pinCode\" is null");
        }
        try {
            derivedKey = CardCryptography.getDerivedKey(pinCode, salt);
        }
        catch (NoSuchAlgorithmException e) {
            log.error((Object)e);
            throw new CardException(e.getMessage());
        }
        SecretKeySpec key = new SecretKeySpec(derivedKey, "AES");
        try {
            encryptedData = CardCryptography.encryptData(data, initVector, key);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new CardException(e.getMessage());
        }
        return encryptedData;
    }

    public static byte[] getPinDigest(byte[] pinCode) throws CardException {
        if (pinCode == null) {
            throw new CardException("Parameter \"pinCode\" is null");
        }
        try {
            MessageDigest hash = MessageDigest.getInstance("SHA-1");
            return hash.digest(pinCode);
        }
        catch (NoSuchAlgorithmException e) {
            log.error((Object)e);
            throw new CardException(e.getMessage());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Init.init();
    }
}

