/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.icard.provider.cardspace.common.utils;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.icard.IClaim;
import org.eclipse.higgins.icard.IClaimType;
import org.eclipse.higgins.icard.ISimpleClaim;
import org.eclipse.higgins.icard.ISimpleClaimType;
import org.eclipse.higgins.icard.InvalidClaimException;
import org.eclipse.higgins.icard.InvalidTypeException;
import org.eclipse.higgins.icard.common.ClaimType;
import org.eclipse.higgins.icard.common.ClaimValue;

public class SelfIssuedCardClaims {
    public static final String GIVEN_NAME_TYPE = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/givenname";
    public static final String GIVEN_NAME_NAME = "First Name";
    public static final String GIVEN_NAME_DESC = "First Name";
    public static final String SURNAME_TYPE = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/surname";
    public static final String SURNAME_NAME = "Last Name";
    public static final String SURNAME_DESC = "Last Name";
    public static final String EMAIL_ADDRESS_TYPE = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/emailaddress";
    public static final String EMAIL_ADDRESS_NAME = "Email Address";
    public static final String EMAIL_ADDRESS_DESC = "Email Address";
    public static final String STREET_ADDRESS_TYPE = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/streetaddress";
    public static final String STREET_ADDRESS_NAME = "Street";
    public static final String STREET_ADDRESS_DESC = "Street";
    public static final String LOCALITY_TYPE = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/locality";
    public static final String LOCALITY_NAME = "City";
    public static final String LOCALITY_DESC = "City";
    public static final String STATE_OR_PROVINCE_TYPE = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/stateorprovince";
    public static final String STATE_OR_PROVINCE_NAME = "State";
    public static final String STATE_OR_PROVINCE_DESC = "State";
    public static final String POSTAL_CODE_TYPE = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/postalcode";
    public static final String POSTAL_CODE_NAME = "Postal Code";
    public static final String POSTAL_CODE_DESC = "Postal Code";
    public static final String COUNTRY_TYPE = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/country";
    public static final String COUNTRY_NAME = "Country/Region";
    public static final String COUNTRY_DESC = "Country/Region";
    public static final String HOME_PHONE_TYPE = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/homephone";
    public static final String HOME_PHONE_NAME = "Home Phone";
    public static final String HOME_PHONE_DESC = "Home Phone Number";
    public static final String OTHER_PHONE_TYPE = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/otherphone";
    public static final String OTHER_PHONE_NAME = "Other Phone";
    public static final String OTHER_PHONE_DESC = "Other Phone Number";
    public static final String MOBILE_PHONE_TYPE = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/mobilephone";
    public static final String MOBILE_PHONE_NAME = "Mobile Phone";
    public static final String MOBILE_PHONE_DESC = "Mobile Phone Number";
    public static final String DATE_OF_BIRTH_TYPE = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/dateofbirth";
    public static final String DATE_OF_BIRTH_NAME = "Date of Birth";
    public static final String DATE_OF_BIRTH_DESC = "Date of Birth";
    public static final String GENDER_TYPE = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/gender";
    public static final String GENDER_NAME = "Gender";
    public static final String GENDER_DESC = "Gender";
    public static final String WEB_PAGE_TYPE = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/webpage";
    public static final String WEB_PAGE_NAME = "Web Page";
    public static final String WEB_PAGE_DESC = "Web Page";
    public static final String PPID_TYPE = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/privatepersonalidentifier";
    public static final String PPID_NAME = "PPID";
    public static final String PPID_DESC = "PPID";
    private static Hashtable claimTypes_;
    private static ArrayList claimTypesList_;
    private Hashtable claimValues_ = SelfIssuedCardClaims.getSupportedTypesHash();
    static /* synthetic */ Class class$org$eclipse$higgins$icard$provider$cardspace$common$utils$SelfIssuedCardClaims;

    public SelfIssuedCardClaims(List claimValues) throws CardException {
        if (claimValues != null) {
            int size = claimValues.size();
            for (int i = 0; i < size; ++i) {
                IClaim value = (IClaim)claimValues.get(i);
                IClaimType claimType = value.getType();
                if (claimType == null) {
                    throw new InvalidClaimException("Claim doestn't contain claim type.");
                }
                if (!claimType.isSimple()) {
                    throw new InvalidTypeException("Complex clime type: " + claimType.getType() + " is not supported.");
                }
                ISimpleClaimType simpleType = null;
                try {
                    simpleType = (ISimpleClaimType)claimType;
                }
                catch (ClassCastException e) {
                    throw new InvalidTypeException((Throwable)e);
                }
                if (simpleType.getMaxCardinality() != 1) {
                    throw new InvalidTypeException("Unsupported multivalued clime type: " + claimType.getType());
                }
                URI type = null;
                try {
                    type = new URI(claimType.getType());
                }
                catch (URISyntaxException e) {
                    throw new CardException((Throwable)e);
                }
                if (type == null) {
                    throw new InvalidTypeException("Claim type contains null type URI.");
                }
                String typeStr = type.toString();
                if (!claimTypes_.containsKey(typeStr)) {
                    throw new InvalidTypeException("Unsupported claim type : " + typeStr);
                }
                ISimpleClaim simple = null;
                try {
                    simple = (ISimpleClaim)value;
                }
                catch (ClassCastException e) {
                    throw new InvalidClaimException((Throwable)e);
                }
                List values = simple.getValues();
                if (values.size() <= 0) continue;
                this.claimValues_.put(typeStr, values.get(0));
            }
        }
    }

    public void setGivenName(String value) {
        if (value == null || value.trim().length() == 0) {
            this.claimValues_.put(GIVEN_NAME_TYPE, "");
        } else {
            this.claimValues_.put(GIVEN_NAME_TYPE, value.trim());
        }
    }

    public void setSurName(String value) {
        if (value == null || value.trim().length() == 0) {
            this.claimValues_.put(SURNAME_TYPE, "");
        } else {
            this.claimValues_.put(SURNAME_TYPE, value.trim());
        }
    }

    public void setEmailAddress(String value) {
        if (value == null || value.trim().length() == 0) {
            this.claimValues_.put(EMAIL_ADDRESS_TYPE, "");
        } else {
            this.claimValues_.put(EMAIL_ADDRESS_TYPE, value.trim());
        }
    }

    public void setStreetAddress(String value) {
        if (value == null || value.trim().length() == 0) {
            this.claimValues_.put(STREET_ADDRESS_TYPE, "");
        } else {
            this.claimValues_.put(STREET_ADDRESS_TYPE, value.trim());
        }
    }

    public void setLocality(String value) {
        if (value == null || value.trim().length() == 0) {
            this.claimValues_.put(LOCALITY_TYPE, "");
        } else {
            this.claimValues_.put(LOCALITY_TYPE, value.trim());
        }
    }

    public void setStateOrProvince(String value) {
        if (value == null || value.trim().length() == 0) {
            this.claimValues_.put(STATE_OR_PROVINCE_TYPE, "");
        } else {
            this.claimValues_.put(STATE_OR_PROVINCE_TYPE, value.trim());
        }
    }

    public void setPostalCode(String value) {
        if (value == null || value.trim().length() == 0) {
            this.claimValues_.put(POSTAL_CODE_TYPE, "");
        } else {
            this.claimValues_.put(POSTAL_CODE_TYPE, value.trim());
        }
    }

    public void setCountry(String value) {
        if (value == null || value.trim().length() == 0) {
            this.claimValues_.put(COUNTRY_TYPE, "");
        } else {
            this.claimValues_.put(COUNTRY_TYPE, value.trim());
        }
    }

    public void setHomePhone(String value) {
        if (value == null || value.trim().length() == 0) {
            this.claimValues_.put(HOME_PHONE_TYPE, "");
        } else {
            this.claimValues_.put(HOME_PHONE_TYPE, value.trim());
        }
    }

    public void setOtherPhone(String value) {
        if (value == null || value.trim().length() == 0) {
            this.claimValues_.put(OTHER_PHONE_TYPE, "");
        } else {
            this.claimValues_.put(OTHER_PHONE_TYPE, value.trim());
        }
    }

    public void setMobilePhone(String value) {
        if (value == null || value.trim().length() == 0) {
            this.claimValues_.put(MOBILE_PHONE_TYPE, "");
        } else {
            this.claimValues_.put(MOBILE_PHONE_TYPE, value.trim());
        }
    }

    public void setDateOfBirth(String value) {
        if (value == null || value.trim().length() == 0) {
            this.claimValues_.put(DATE_OF_BIRTH_TYPE, "");
        } else {
            this.claimValues_.put(DATE_OF_BIRTH_TYPE, value.trim());
        }
    }

    public void setGender(String value) {
        if (value == null || value.trim().length() == 0) {
            this.claimValues_.put(GENDER_TYPE, "");
        } else {
            this.claimValues_.put(GENDER_TYPE, value.trim());
        }
    }

    public void setWebPage(String value) {
        if (value == null || value.trim().length() == 0) {
            this.claimValues_.put(WEB_PAGE_TYPE, "");
        } else {
            this.claimValues_.put(WEB_PAGE_TYPE, value.trim());
        }
    }

    public void setPrivatePersonalIdentifier(String value) {
        if (value == null || value.trim().length() == 0) {
            this.claimValues_.put(PPID_TYPE, "");
        } else {
            this.claimValues_.put(PPID_TYPE, value.trim());
        }
    }

    public String getGivenName() {
        if (this.claimValues_.containsKey(GIVEN_NAME_TYPE)) {
            return this.claimValues_.get(GIVEN_NAME_TYPE).toString();
        }
        return "";
    }

    public String getSurName() {
        if (this.claimValues_.containsKey(SURNAME_TYPE)) {
            return this.claimValues_.get(SURNAME_TYPE).toString();
        }
        return "";
    }

    public String getEmailAddress() {
        if (this.claimValues_.containsKey(EMAIL_ADDRESS_TYPE)) {
            return this.claimValues_.get(EMAIL_ADDRESS_TYPE).toString();
        }
        return "";
    }

    public String getStreetAddress() {
        if (this.claimValues_.containsKey(STREET_ADDRESS_TYPE)) {
            return this.claimValues_.get(STREET_ADDRESS_TYPE).toString();
        }
        return "";
    }

    public String getLocality() {
        if (this.claimValues_.containsKey(LOCALITY_TYPE)) {
            return this.claimValues_.get(LOCALITY_TYPE).toString();
        }
        return "";
    }

    public String getStateOrProvince() {
        if (this.claimValues_.containsKey(STATE_OR_PROVINCE_TYPE)) {
            return this.claimValues_.get(STATE_OR_PROVINCE_TYPE).toString();
        }
        return "";
    }

    public String getPostalCode() {
        if (this.claimValues_.containsKey(POSTAL_CODE_TYPE)) {
            return this.claimValues_.get(POSTAL_CODE_TYPE).toString();
        }
        return "";
    }

    public String getCountry() {
        if (this.claimValues_.containsKey(COUNTRY_TYPE)) {
            return this.claimValues_.get(COUNTRY_TYPE).toString();
        }
        return "";
    }

    public String getHomePhone() {
        if (this.claimValues_.containsKey(HOME_PHONE_TYPE)) {
            return this.claimValues_.get(HOME_PHONE_TYPE).toString();
        }
        return "";
    }

    public String getOtherPhone() {
        if (this.claimValues_.containsKey(OTHER_PHONE_TYPE)) {
            return this.claimValues_.get(OTHER_PHONE_TYPE).toString();
        }
        return "";
    }

    public String getMobilePhone() {
        if (this.claimValues_.containsKey(MOBILE_PHONE_TYPE)) {
            return this.claimValues_.get(MOBILE_PHONE_TYPE).toString();
        }
        return "";
    }

    public String getDateOfBirth() {
        if (this.claimValues_.containsKey(DATE_OF_BIRTH_TYPE)) {
            return this.claimValues_.get(DATE_OF_BIRTH_TYPE).toString();
        }
        return "";
    }

    public String getGender() {
        if (this.claimValues_.containsKey(GENDER_TYPE)) {
            return this.claimValues_.get(GENDER_TYPE).toString();
        }
        return "";
    }

    public String getWebPage() {
        if (this.claimValues_.containsKey(WEB_PAGE_TYPE)) {
            return this.claimValues_.get(WEB_PAGE_TYPE).toString();
        }
        return "";
    }

    public String getPrivatePersonalIdentifier() {
        if (this.claimValues_.containsKey(PPID_TYPE)) {
            return this.claimValues_.get(PPID_TYPE).toString();
        }
        return "";
    }

    public ArrayList getClaimValueList(boolean skipEmptyValues) throws CardException {
        ArrayList<ClaimValue> list = new ArrayList<ClaimValue>();
        Enumeration types = this.claimValues_.keys();
        while (types.hasMoreElements()) {
            String type = (String)types.nextElement();
            String value = (String)this.claimValues_.get(type);
            if (value == null || value.trim().length() <= 0) continue;
            ClaimType cType = SelfIssuedCardClaims.getClaimType(type);
            list.add(new ClaimValue((ISimpleClaimType)cType, value));
        }
        return list;
    }

    public static ArrayList getSupportedClaimTypeList() {
        ArrayList al = new ArrayList();
        al.addAll(claimTypesList_);
        return al;
    }

    public static ClaimType getClaimType(String type) throws CardException {
        if (type == null) {
            throw new CardException("Parameter \"type\" is null.");
        }
        if (claimTypes_.containsKey(type)) {
            return (ClaimType)((ClaimType)claimTypes_.get(type)).clone();
        }
        throw new CardException("Unsupported self-issued claim type : " + type);
    }

    public static ClaimType getClaimType(URI type) throws CardException {
        if (type == null) {
            throw new CardException("Parameter \"type\" is null.");
        }
        return SelfIssuedCardClaims.getClaimType(type.toString());
    }

    public static Hashtable getSupportedTypesHash() {
        Hashtable<String, String> claimValues = new Hashtable<String, String>();
        claimValues.put(GIVEN_NAME_TYPE, "1");
        claimValues.put(SURNAME_TYPE, "2");
        claimValues.put(EMAIL_ADDRESS_TYPE, "3");
        claimValues.put(STREET_ADDRESS_TYPE, "4");
        claimValues.put(LOCALITY_TYPE, "5");
        claimValues.put(STATE_OR_PROVINCE_TYPE, "6");
        claimValues.put(POSTAL_CODE_TYPE, "7");
        claimValues.put(COUNTRY_TYPE, "8");
        claimValues.put(HOME_PHONE_TYPE, "9");
        claimValues.put(OTHER_PHONE_TYPE, "10");
        claimValues.put(MOBILE_PHONE_TYPE, "11");
        claimValues.put(DATE_OF_BIRTH_TYPE, "12");
        claimValues.put(GENDER_TYPE, "13");
        claimValues.put(WEB_PAGE_TYPE, "14");
        claimValues.put(PPID_TYPE, "15");
        return claimValues;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        block2: {
            try {
                claimTypes_ = new Hashtable();
                claimTypes_.put(GIVEN_NAME_TYPE, new ClaimType(GIVEN_NAME_TYPE, "First Name", "First Name"));
                claimTypes_.put(SURNAME_TYPE, new ClaimType(SURNAME_TYPE, "Last Name", "Last Name"));
                claimTypes_.put(EMAIL_ADDRESS_TYPE, new ClaimType(EMAIL_ADDRESS_TYPE, "Email Address", "Email Address"));
                claimTypes_.put(STREET_ADDRESS_TYPE, new ClaimType(STREET_ADDRESS_TYPE, "Street", "Street"));
                claimTypes_.put(LOCALITY_TYPE, new ClaimType(LOCALITY_TYPE, "City", "City"));
                claimTypes_.put(STATE_OR_PROVINCE_TYPE, new ClaimType(STATE_OR_PROVINCE_TYPE, "State", "State"));
                claimTypes_.put(POSTAL_CODE_TYPE, new ClaimType(POSTAL_CODE_TYPE, "Postal Code", "Postal Code"));
                claimTypes_.put(COUNTRY_TYPE, new ClaimType(COUNTRY_TYPE, "Country/Region", "Country/Region"));
                claimTypes_.put(HOME_PHONE_TYPE, new ClaimType(HOME_PHONE_TYPE, HOME_PHONE_NAME, HOME_PHONE_DESC));
                claimTypes_.put(OTHER_PHONE_TYPE, new ClaimType(OTHER_PHONE_TYPE, OTHER_PHONE_NAME, OTHER_PHONE_DESC));
                claimTypes_.put(MOBILE_PHONE_TYPE, new ClaimType(MOBILE_PHONE_TYPE, MOBILE_PHONE_NAME, MOBILE_PHONE_DESC));
                claimTypes_.put(DATE_OF_BIRTH_TYPE, new ClaimType(DATE_OF_BIRTH_TYPE, "Date of Birth", "Date of Birth"));
                claimTypes_.put(GENDER_TYPE, new ClaimType(GENDER_TYPE, "Gender", "Gender"));
                claimTypes_.put(WEB_PAGE_TYPE, new ClaimType(WEB_PAGE_TYPE, "Web Page", "Web Page"));
                claimTypes_.put(PPID_TYPE, new ClaimType(PPID_TYPE, "PPID", "PPID"));
                claimTypesList_ = new ArrayList();
                claimTypesList_.add(new ClaimType(GIVEN_NAME_TYPE, "First Name", "First Name"));
                claimTypesList_.add(new ClaimType(SURNAME_TYPE, "Last Name", "Last Name"));
                claimTypesList_.add(new ClaimType(EMAIL_ADDRESS_TYPE, "Email Address", "Email Address"));
                claimTypesList_.add(new ClaimType(STREET_ADDRESS_TYPE, "Street", "Street"));
                claimTypesList_.add(new ClaimType(LOCALITY_TYPE, "City", "City"));
                claimTypesList_.add(new ClaimType(STATE_OR_PROVINCE_TYPE, "State", "State"));
                claimTypesList_.add(new ClaimType(POSTAL_CODE_TYPE, "Postal Code", "Postal Code"));
                claimTypesList_.add(new ClaimType(COUNTRY_TYPE, "Country/Region", "Country/Region"));
                claimTypesList_.add(new ClaimType(HOME_PHONE_TYPE, HOME_PHONE_NAME, HOME_PHONE_DESC));
                claimTypesList_.add(new ClaimType(OTHER_PHONE_TYPE, OTHER_PHONE_NAME, OTHER_PHONE_DESC));
                claimTypesList_.add(new ClaimType(MOBILE_PHONE_TYPE, MOBILE_PHONE_NAME, MOBILE_PHONE_DESC));
                claimTypesList_.add(new ClaimType(DATE_OF_BIRTH_TYPE, "Date of Birth", "Date of Birth"));
                claimTypesList_.add(new ClaimType(GENDER_TYPE, "Gender", "Gender"));
                claimTypesList_.add(new ClaimType(WEB_PAGE_TYPE, "Web Page", "Web Page"));
                claimTypesList_.add(new ClaimType(PPID_TYPE, "PPID", "PPID"));
            }
            catch (CardException e) {
                Log log = LogFactory.getLog((Class)(class$org$eclipse$higgins$icard$provider$cardspace$common$utils$SelfIssuedCardClaims == null ? (class$org$eclipse$higgins$icard$provider$cardspace$common$utils$SelfIssuedCardClaims = SelfIssuedCardClaims.class$("org.eclipse.higgins.icard.provider.cardspace.common.utils.SelfIssuedCardClaims")) : class$org$eclipse$higgins$icard$provider$cardspace$common$utils$SelfIssuedCardClaims));
                if (log == null) break block2;
                log.error((Object)e);
            }
        }
    }
}

