/*******************************************************************************
 * Copyright (c) 2006-2007 IBM Corporation, Parity Communications Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *    Bjoern Assmann (IBM Corporation) - initial API and implementation
 *    abhi shelat
 *    Valery Kokhan - refactoring to integrate with I-Card Registry
 *******************************************************************************/

package org.eclipse.higgins.icard.provider.cardspace.common;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.icard.ICard;
import org.eclipse.higgins.icard.ICardConstants;
import org.eclipse.higgins.icard.IInformationCard;
import org.eclipse.higgins.icard.policy.ICardSpacePolicy;

public class CardSpacePolicy implements ICardSpacePolicy {
	protected static final Log log = LogFactory.getLog(CardSpacePolicy.class);
	
	protected String issuer = "";
	protected String issuerPolicy = "";
	protected String tokenType = "";
	protected List requiredClaims = new ArrayList();
	protected List optionalClaims = new ArrayList();
	protected URL site = null;
	protected String privacyUrl = "";
	protected String privacyVersion = "";
	//protected List cardTypes = Arrays.asList(new String[] {ICardConstants.I_CARD_TYPE_CARDSPACE});
	protected Class[] cardTypes = new Class[] {IInformationCard.class};

	public String getIssuer() {
		return issuer;
	}

	public String getIssuerPolicy() {
		return issuerPolicy;
	}

	public String getTokenType() {
		return tokenType;
	}

	public List getRequiredClaims() {
		return Collections.unmodifiableList(requiredClaims);
	}

	public List getOptionalClaims() {
		return Collections.unmodifiableList(optionalClaims);
	}

	public URL getSite() {
		return site ;
	}

	public String getPrivacyUrl() {
		return privacyUrl;
	}

	public String getPrivacyVersion() {
		return privacyVersion;
	}

	public void setIssuer(String issuer) {
		this.issuer = issuer;
	}

	public void setIssuerPolicy(String issuerPolicy) {
		this.issuerPolicy = issuerPolicy;
	}

	public void setOptionalClaims(List optionalClaims) {
		this.optionalClaims = optionalClaims;
	}

	public void setPrivacyUrl(String privacyUrl) {
		this.privacyUrl = privacyUrl;
	}

	public void setPrivacyVersion(String privacyVersion) {
		this.privacyVersion = privacyVersion;
	}

	public void setRequiredClaims(List requiredClaims) {
		this.requiredClaims = requiredClaims;
	}

	public void setSite(URL site) {
		this.site = site;
	}

	public void setTokenType(String tokenType) {
		this.tokenType = tokenType;
	}

	public String getType() {
		return ICardConstants.POLICY_TYPE_CARDSPACE;
	}

	public Class[] getICardTypes() {
		//return Collections.unmodifiableList(cardTypes);
		return cardTypes;
	}

	public boolean isSatisfiedBy(ICard icard) {
		if (icard == null) {
			return false;
		} /*else if (!getICardTypes().contains(icard.getType())) {
			log.trace("CardSpacePolicy::isSatisfiedBy(ICard icard) fail on card [" + icard.getName()+"] b/c cardType mismatch");
			return false;
		} */else if (icard instanceof IInformationCard) {
			return isSatisfiedBy((IInformationCard) icard);
		}
		return false;
	}

	public boolean isSatisfiedBy(IInformationCard icard) {
		log.trace("CardSpacePolicy::isSatisfiedBy check on ["+icard.getName()+"]");		
		// check whether card applies to policy, i.e. check issuer, ....
		// TODO

		// check issuer
		if (!issuer.equals("")) {
			if (!issuer.equals(icard.getIssuer())) {
				log.trace("issuer " + issuer + " does not match " + icard.getIssuer());
				return false;
			}
		}
		log.trace("issuer ok.");

		// TODO the time when infocard expires should be considered

		// TODO How should issuerPolicy be used for the matching ?
		
		// TODO should we check tokenType ?
		List suppTokenTypes = icard.getSupportedTokenTypes();
		boolean bSupportedTokenType = false;
		if (tokenType == null || tokenType.trim().length() == 0) {
			bSupportedTokenType = true;
		}
		else {
			if (null != suppTokenTypes)
			{
				log.trace("Supported token types count: " + suppTokenTypes.size());
				log.trace("Supported token types: " + suppTokenTypes);
				for (int i = 0; i < suppTokenTypes.size(); ++i)
				{
					java.net.URI uriTokenType = (java.net.URI)suppTokenTypes.get(i);
					String strTokenType = uriTokenType.toString();
					if (strTokenType.equals(tokenType))
					{
						bSupportedTokenType = true;
						break;
					}
				}
			}
		}
		if (!bSupportedTokenType)
		{
			log.trace("Token type: " + tokenType + " is not supported.");
			return false;
		}
		log.trace("token type ok.");		

		List suppClaims = icard.getSupportedClaimTypesUris();		
		log.trace("Supported claim types count: " + suppClaims.size());
		log.trace("Supported claim types: " + suppClaims);
		for (int j = 0; j < requiredClaims.size(); ++ j)
		{
			String strRequiredClaimType = (String) requiredClaims.get(j);
			boolean bSupportedClaimType = false;
			for (int i = 0; i < suppClaims.size(); ++i)
			{
				String strSupportedClaimType = (String)suppClaims.get(i);
				if (strSupportedClaimType.equals(strRequiredClaimType))
				{
					bSupportedClaimType = true;
					break;
				}
			}
			if (!bSupportedClaimType)
			{
				log.trace("claim not satisfied: " + strRequiredClaimType);
				log.trace("returning FALSE");
				return false;					
			}
		}
		
		// TODO how should we deal with ArrayList optionalClaims

		// TODO Should we use this for the matching String privacyUrl;
		
		// TODO How should we consider  privacyVersion; ?
		log.trace("returning TRUE");
		return true;
	}

	public String[] getSummary() {
		return makeSummary(requiredClaims);
	}
	
	public String[] makeSummary(List claims) {
		String[] summary = new String[claims.size()];
		ListIterator li = claims.listIterator();
		int i=0;
		while (li.hasNext()) {
			String cl = CardspaceDisplayMappings.getString(li.next().toString());
			summary[i++] = cl;
		}
		return summary;
	}
	
	public String[] getOptionalClaimSummary() {
		return makeSummary(optionalClaims);
	}
	
}
