/**
 * Copyright (c) 2007 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Sergey Lyakhov - initial API and implementation
 */

package org.eclipse.higgins.icard.provider.cardspace.common;

import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.icard.ICardConstants;
import org.eclipse.higgins.icard.IInformationCard;
import org.eclipse.higgins.icard.common.Card;

public abstract class InformationCard extends Card implements IInformationCard {
	protected byte[] issuerID_ = null;

	protected byte[] hashSalt_ = null;

	protected byte[] masterKey_ = null;

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.icard.IInformationCard#getIssuerID()
	 */
	public byte[] getIssuerID() {
		return issuerID_;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.icard.IInformationCard#getHashSalt()
	 */
	public byte[] getHashSalt() {
		return hashSalt_;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.icard.IInformationCard#getMasterKey()
	 */
	public byte[] getMasterKey() throws CardException {
		return masterKey_;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.icard.ICard#getType()
	 */
	public String getType() {
		return ICardConstants.I_CARD_TYPE_CARDSPACE;
	}

}
