/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.icard.provider.cardspace.common.utils;

import java.net.URI;
import java.security.cert.CertStore;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.configuration.xml.ConfigurationHandler;
import org.eclipse.higgins.icard.IClaimType;
import org.eclipse.higgins.icard.IEndpointReference;
import org.eclipse.higgins.icard.IInformationCard;
import org.eclipse.higgins.icard.IManagedInformationCard;
import org.eclipse.higgins.icard.IPersonalInformationCard;
import org.eclipse.higgins.icard.ITokenService;
import org.eclipse.higgins.icard.common.ClaimValue;
import org.eclipse.higgins.icard.policy.ICardSpacePolicy;
import org.eclipse.higgins.sts.api.IConstants;
import org.eclipse.higgins.sts.api.IElement;
import org.eclipse.higgins.sts.api.IFault;
import org.eclipse.higgins.sts.api.IMetadataExchangeService;
import org.eclipse.higgins.sts.api.ISTSRequest;
import org.eclipse.higgins.sts.api.ISTSResponse;
import org.eclipse.higgins.sts.api.ISecurityTokenService;
import org.eclipse.higgins.sts.binding.axis1x.client.MetadataExchangeServiceClientBindingFactory;
import org.eclipse.higgins.sts.binding.axis1x.client.SecurityTokenServiceClientBindingFactory;
import org.eclipse.higgins.sts.client.MetadataExchangeServiceFactory;
import org.eclipse.higgins.sts.client.SecurityTokenServiceFactory;
import org.eclipse.higgins.sts.client.TokenRequestFactory;
import org.eclipse.higgins.sts.common.Constants;
import org.eclipse.higgins.sts.common.Element;
import org.eclipse.higgins.sts.common.InformationCardReference;
import org.eclipse.higgins.sts.common.STSResponse;

public class STSHelper {
    IInformationCard card;
    private static final String PPID_CLAIM_TYPE = new Constants().getIdentityClaimPrivatePersonalIdentifier().toString();
    IElement elemClaims = new Element();
    String username;
    String password;
    X509Certificate sslCert;
    CertStore certStore;
    URI relyingPArtyURI;
    String stsConfigurationBase;
    protected static final Log log = LogFactory.getLog((Class)(class$org$eclipse$higgins$icard$provider$cardspace$common$utils$STSHelper == null ? (class$org$eclipse$higgins$icard$provider$cardspace$common$utils$STSHelper = STSHelper.class$("org.eclipse.higgins.icard.provider.cardspace.common.utils.STSHelper")) : class$org$eclipse$higgins$icard$provider$cardspace$common$utils$STSHelper));
    static /* synthetic */ Class class$org$eclipse$higgins$icard$provider$cardspace$common$utils$STSHelper;
    static /* synthetic */ Class class$org$eclipse$higgins$icard$common$ClaimValue;

    public STSHelper(String stsConfigurationBase, IInformationCard card, ICardSpacePolicy pol, String username, String password) throws Exception {
        this.stsConfigurationBase = stsConfigurationBase;
        this.card = card;
        String claims = null;
        if (card instanceof IPersonalInformationCard) {
            Hashtable claimsMap = this.getClaimsMap((IPersonalInformationCard)card);
            claims = this.personalClaimsPolicyToString(pol, claimsMap);
        } else {
            claims = this.managedClaimsPolicyToString(pol);
        }
        log.debug((Object)("Claims: " + claims));
        this.elemClaims.set((Object)claims);
        this.username = username;
        this.password = password;
        this.sslCert = null;
        String stsConfig = System.getProperty("org.eclipse.higgins.sts.conf");
        if (stsConfig != null && stsConfig.length() > 0) {
            this.stsConfigurationBase = stsConfig;
        }
    }

    private String managedClaimsPolicyToString(ICardSpacePolicy pol) {
        String begin = "<wst:Claims xmlns:ic=\"http://schemas.xmlsoap.org/ws/2005/05/identity\" xmlns:wst=\"http://schemas.xmlsoap.org/ws/2005/02/trust\" wst:Dialect=\"http://schemas.xmlsoap.org/ws/2005/05/identity\">";
        String end = "</wst:Claims>";
        String middle = "";
        List requiredClaims = pol.getRequiredClaims();
        for (int i = 0; i < requiredClaims.size(); ++i) {
            middle = middle + this.claimConvertHelper((String)requiredClaims.get(i));
        }
        return begin + middle + end;
    }

    private Hashtable getClaimsMap(IPersonalInformationCard card) throws Exception {
        Hashtable<String, String> ht = new Hashtable<String, String>();
        Iterator itr = card.getClaims();
        while (itr.hasNext()) {
            Object obj = itr.next();
            if (!(obj instanceof ClaimValue)) {
                throw new Exception("Class of claim of IPersonalInformationCard expected to be " + (class$org$eclipse$higgins$icard$common$ClaimValue == null ? (class$org$eclipse$higgins$icard$common$ClaimValue = STSHelper.class$("org.eclipse.higgins.icard.common.ClaimValue")) : class$org$eclipse$higgins$icard$common$ClaimValue).getName());
            }
            ClaimValue claim = (ClaimValue)obj;
            if (claim != null) {
                IClaimType type = claim.getType();
                if (type != null) {
                    String claimType = type.getType();
                    if (claimType == null) continue;
                    String value = claim.getValue();
                    if (value == null) {
                        value = "";
                    }
                    ht.put(claimType, value);
                    continue;
                }
                log.warn((Object)"The claim type of claim is null. This claim will be skipped.");
                continue;
            }
            log.warn((Object)"Some of claims of the card is null. This claim will be skipped.");
        }
        return ht;
    }

    private void addPersonalClaimToBuffer(StringBuffer buf, String claimType, String claimValue) {
        buf.append("<ic:ClaimType Uri=\"");
        buf.append(claimType);
        buf.append("\">");
        buf.append(claimValue);
        buf.append("</ic:ClaimType>");
    }

    private String personalClaimsPolicyToString(ICardSpacePolicy pol, Hashtable claims) throws Exception {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<wst:Claims xmlns:ic=\"http://schemas.xmlsoap.org/ws/2005/05/identity\" xmlns:wst=\"http://schemas.xmlsoap.org/ws/2005/02/trust\" wst:Dialect=\"http://schemas.xmlsoap.org/ws/2005/05/identity\">");
        List requiredClaims = pol.getRequiredClaims();
        block0: for (int i = 0; i < requiredClaims.size(); ++i) {
            String requiredClaim = (String)requiredClaims.get(i);
            if (requiredClaim.indexOf(PPID_CLAIM_TYPE) > -1) {
                this.addPersonalClaimToBuffer(buffer, PPID_CLAIM_TYPE, "");
                continue;
            }
            Enumeration types = claims.keys();
            while (types.hasMoreElements()) {
                String claimType = (String)types.nextElement();
                if (requiredClaim.indexOf(claimType) <= -1) continue;
                String claimValue = (String)claims.get(claimType);
                this.addPersonalClaimToBuffer(buffer, claimType, claimValue);
                continue block0;
            }
        }
        buffer.append("</wst:Claims>");
        return buffer.toString();
    }

    String claimConvertHelper(String claim) {
        return "<ic:ClaimType Uri=\"" + claim + "\"/>";
    }

    public void setX509Certificate(X509Certificate x) {
        this.sslCert = x;
    }

    public void setCertStore(CertStore certStore) {
        this.certStore = certStore;
    }

    public void setRelyingPArtyURI(URI rpURI) {
        this.relyingPArtyURI = rpURI;
    }

    public ISTSResponse getToken() throws Exception {
        if (this.card.isSelfIssued()) {
            return this.getToken_SelfSignedCard();
        }
        return this.getToken_ManagedCard();
    }

    public ISTSResponse getToken_ManagedCard() throws Exception {
        IManagedInformationCard mCard = (IManagedInformationCard)this.card;
        SecurityTokenServiceClientBindingFactory bindingFactorySTS = new SecurityTokenServiceClientBindingFactory();
        MetadataExchangeServiceClientBindingFactory bindingFactoryMEX = new MetadataExchangeServiceClientBindingFactory();
        ISecurityTokenService bindingSTS = (ISecurityTokenService)bindingFactorySTS.getSingletonInstance();
        IMetadataExchangeService bindingMEX = (IMetadataExchangeService)bindingFactoryMEX.getSingletonInstance();
        ISecurityTokenService sts = null;
        IMetadataExchangeService mex = null;
        Hashtable<String, URI> mapGlobalSettings = new Hashtable<String, URI>();
        List services = mCard.getTokenServices();
        ITokenService service = (ITokenService)services.get(0);
        IEndpointReference ref = service.getEndpointReference();
        URI uriTokenService = ref.getAddress();
        URI uriMetadataService = ref.getMetadataAddress();
        mapGlobalSettings.put("TokenServiceTrustURI", uriTokenService);
        log.error((Object)("uri metadata service: " + uriMetadataService));
        mapGlobalSettings.put("MetadataServiceURI", uriMetadataService);
        mapGlobalSettings.put("SecurityTokenServiceBinding", (URI)bindingSTS);
        mapGlobalSettings.put("MetadataExchangeServiceBinding", (URI)bindingMEX);
        bindingSTS.configure(mapGlobalSettings, null, null);
        SecurityTokenServiceFactory factorySTS = new SecurityTokenServiceFactory();
        sts = (ISecurityTokenService)factorySTS.getSingletonInstance();
        sts.configure(mapGlobalSettings, null, null);
        bindingMEX.configure(mapGlobalSettings, null, null);
        MetadataExchangeServiceFactory factoryMEX = new MetadataExchangeServiceFactory();
        mex = (IMetadataExchangeService)factoryMEX.getSingletonInstance();
        mex.configure(mapGlobalSettings, null, null);
        InformationCardReference informationCardReference = new InformationCardReference();
        informationCardReference.setCardId(URI.create(mCard.getID()));
        informationCardReference.setCardVersion(mCard.getVersion());
        Constants constants = new Constants();
        TokenRequestFactory factoryRequest = new TokenRequestFactory();
        STSResponse stsResponse = new STSResponse();
        ISTSRequest stsRequest = factoryRequest.createManagedRequest(this.relyingPArtyURI, new X509Certificate[]{this.sslCert}, this.certStore, uriTokenService, URI.create("urn:oasis:names:tc:SAML:1.0:assertion"), (IInformationCard)mCard, this.elemClaims, this.username, this.password);
        sts.invoke(mapGlobalSettings, null, null, null, (IConstants)constants, stsRequest, (ISTSResponse)stsResponse);
        if (null != stsResponse.getFault()) {
            log.error((Object)"Returning STS Fault");
            log.trace((Object)"Returning STS Fault");
            IFault fault = stsResponse.getFault();
            log.error((Object)("Returning STS Fault: " + fault.getDetail()));
            throw new Exception("Returning STS Fault: " + fault.getDetail());
        }
        return stsResponse;
    }

    public ISTSResponse getToken_SelfSignedCard() throws Exception {
        IPersonalInformationCard pCard = (IPersonalInformationCard)this.card;
        Map mapGlobalSettings = null;
        ConfigurationHandler configurationHandler = new ConfigurationHandler();
        if (null == this.stsConfigurationBase) {
            throw new Exception("Directory with System properties not set");
        }
        configurationHandler.setConfigurationBase(this.stsConfigurationBase);
        configurationHandler.setFileName("PersonalConfiguration.xml");
        boolean bInitialized = configurationHandler.configure(null);
        if (!bInitialized) {
            log.error((Object)"Not Initialized!");
            throw new Exception("Not initialized!");
        }
        mapGlobalSettings = configurationHandler.getSettings();
        ISecurityTokenService sts = (ISecurityTokenService)mapGlobalSettings.get("SecurityTokenService");
        InformationCardReference informationCardReference = new InformationCardReference();
        informationCardReference.setCardId(URI.create(pCard.getID()));
        informationCardReference.setCardVersion(pCard.getVersion());
        Constants constants = new Constants();
        TokenRequestFactory factoryRequest = new TokenRequestFactory();
        STSResponse stsResponse = new STSResponse();
        ISTSRequest stsRequest = factoryRequest.createPersonalRequest(this.relyingPArtyURI, new X509Certificate[]{this.sslCert}, this.certStore, URI.create("urn:oasis:names:tc:SAML:1.0:assertion"), (IInformationCard)pCard, this.elemClaims);
        sts.invoke(mapGlobalSettings, "SecurityTokenService", null, null, (IConstants)constants, stsRequest, (ISTSResponse)stsResponse);
        if (null != stsResponse.getFault()) {
            log.error((Object)"Returning STS Fault");
            log.error((Object)stsResponse.getFault().getDetail());
            throw new Exception("STS Fault");
        }
        return stsResponse;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

