/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.icard.provider.cardspace.common;

import java.io.ByteArrayInputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.LinkedList;
import javax.security.auth.callback.CallbackHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.icard.AuthenticationException;
import org.eclipse.higgins.icard.CUID;
import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.icard.ICard;
import org.eclipse.higgins.icard.ICardTemplate;
import org.eclipse.higgins.icard.IPolicy;
import org.eclipse.higgins.icard.ISimpleClaim;
import org.eclipse.higgins.icard.ISimpleClaimType;
import org.eclipse.higgins.icard.auth.ICredential;
import org.eclipse.higgins.icard.common.BasicCardProvider;
import org.eclipse.higgins.icard.common.ClaimValue;
import org.eclipse.higgins.icard.io.IElement;
import org.eclipse.higgins.icard.provider.cardspace.common.CardSpacePolicy;
import org.eclipse.higgins.icard.provider.cardspace.common.DummyManagedCard;
import org.eclipse.higgins.icard.provider.cardspace.common.ManagedCard;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.CardCryptography;
import org.eclipse.higgins.iss.ICardSelectorService;
import org.eclipse.higgins.iss.IDisplayToken;
import org.eclipse.higgins.iss.IICardSelector;
import org.eclipse.higgins.iss.IIdentityToken;
import org.eclipse.higgins.iss.SelectionANDofORs;
import org.eclipse.higgins.iss.SelectionANDofORsElm;
import org.w3c.dom.Element;

public abstract class ManagedCardProvider
extends BasicCardProvider {
    protected Log log;
    protected static String strCertificate = "MIICVDCCAb2gAwIBAgIERWUHrzANBgkqhkiG9w0BAQUFADBQMQswCQYDVQQGEwJVUzEYMBYGA1UEChMPSUJNIENvcnBvcmF0aW9uMRUwEwYDVQQLEwxJQk0gUmVzZWFyY2gxEDAOBgNVBAMTB1Jvb3QgQ0EwHhcNMDYxMTIzMDIyOTU3WhcNMjYxMTE4MDIyOTU3WjBFMQswCQYDVQQGEwJVUzEQMA4GA1UEChMHRWNsaXBzZTEQMA4GA1UECxMHSGlnZ2luczESMBAGA1UEAxMJbG9jYWxob3N0MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCUFDtM2/nLEhSJqF7zqayW8gQ183KCiKME53VkSjl6C7O9J2hEiBMWsI9a+qBm13VWKvmTc3h3EsLaR/dOreXyCLKEwDIpwHojW3+i037OOxL6U3Ij094rqfHBCJP2xEyLNpPXdIioEgP5H6MTRPXShsBsTQ7bEhZs0QKyXwTNHwIDAQABo0YwRDAdBgNVHQ4EFgQUTHM9O3KViNYsvuGeg4eANMCFHuMwEwYDVR0lBAwwCgYIKwYBBQUHAwEwDgYDVR0PAQH/BAQDAgSwMA0GCSqGSIb3DQEBBQUAA4GBADkZZ34T637gwxp/EmRlRd4ru1Y2ribGoLRpY1icJYlyrUB3552f1K7r69EQxuwnyUnFYVhB+4ZnzhralkKtNs8UVo7RZHSE8jKWOi4YU3RXSqEHKs10ttQLLcHPuH4o9t2OJLeaVtaijbdicbxUEwqhgcNnNrQHe6+f5fgwzSYM";
    protected X509Certificate certificate;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    public ManagedCardProvider() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.higgins.icard.provider.cardspace.common.ManagedCardProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.log = LogFactory.getLog((Class)clazz);
        this.certificate = null;
    }

    public ICard getICardByCUID(CallbackHandler authHandler, CUID cuid, ICredential userCredential) throws AuthenticationException, CardException {
        ICard card = this.getICardByCUID(authHandler, cuid);
        if (card instanceof ManagedCard) {
            ManagedCard mcard = (ManagedCard)card;
            CardSpacePolicy p = new CardSpacePolicy();
            p.setRequiredClaims(mcard.getSupportedClaimTypesUris());
            try {
                ICardSelectorService iss = ICardSelectorService.getInstance();
                IICardSelector s = iss.getICardSelector(authHandler, (IPolicy)p);
                SelectionANDofORs selection = new SelectionANDofORs();
                selection.add(new SelectionANDofORsElm(mcard.getCUID().toString(), 0, 0));
                selection.setCredential(userCredential);
                selection.sslCertChain = new X509Certificate[]{this.getCertificate()};
                LinkedList<ISimpleClaim> claims = new LinkedList<ISimpleClaim>();
                IIdentityToken t = s.getIdentityToken(selection);
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                t.getAs((Class)clazz);
                Class<?> clazz2 = class$2;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$2 = Class.forName("org.eclipse.higgins.iss.IDisplayToken");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                IDisplayToken dt = (IDisplayToken)t.getAs((Class)clazz2);
                Class<?> clazz3 = class$1;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$1 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                System.err.println(dt.getAs((Class)clazz3));
                Iterator itr = mcard.getSupportedClaimTypes();
                while (itr.hasNext()) {
                    ISimpleClaimType ct = (ISimpleClaimType)itr.next();
                    ISimpleClaim c = (ISimpleClaim)dt.getClaim(ct.getType());
                    if (c == null) {
                        c = new ClaimValue(ct, "");
                    }
                    claims.add(c);
                }
                mcard.setClaims(claims);
                return mcard;
            }
            catch (Exception e) {
                throw new CardException((Throwable)e);
            }
        }
        throw new CardException("Unsupported card type: " + card);
    }

    public ICardTemplate[] getCardCreationTemplates(CallbackHandler authHandler) {
        return null;
    }

    public ICardTemplate getCardCreationTemplatesByID(CallbackHandler authHandler, String ID) {
        return null;
    }

    public Class[] getSupportedTypes() {
        Class[] classArray = new Class[1];
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.higgins.icard.IManagedInformationCard");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        return classArray;
    }

    protected X509Certificate getCertificate() {
        if (this.certificate == null) {
            try {
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                String strEncryptionCertificate = "-----BEGIN CERTIFICATE-----\n" + strCertificate + "\n-----END CERTIFICATE-----\n";
                ByteArrayInputStream streamCertificate = new ByteArrayInputStream(strEncryptionCertificate.getBytes());
                this.certificate = (X509Certificate)certificateFactory.generateCertificate(streamCertificate);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.certificate;
    }

    public boolean canImportICard(CallbackHandler authHandler, IElement element) {
        Element card;
        block8: {
            if (element == null) {
                return false;
            }
            try {
                Class<?> clazz = class$4;
                if (clazz == null) {
                    try {
                        clazz = class$4 = Class.forName("org.w3c.dom.Element");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((card = (Element)element.getAs((Class)clazz)) != null) break block8;
                return false;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.log.warn((Object)e);
                return false;
            }
        }
        Element crd = null;
        crd = "Signature".equals(card.getLocalName()) ? CardCryptography.getCardFromSignedEnvelop(card) : card;
        DummyManagedCard c = new DummyManagedCard();
        c.initFromXML(crd);
        return true;
    }
}

