/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.icard.provider.cardspace.common;

import java.net.URI;
import java.security.cert.CertStore;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import org.eclipse.higgins.icard.IInformationCard;
import org.eclipse.higgins.icard.policy.ICardSpacePolicy;
import org.eclipse.higgins.icard.provider.cardspace.common.CardSpacePolicy;
import org.eclipse.higgins.sts.client.PPIDHelper;

public class PPIDCardSpacePolicy
extends CardSpacePolicy
implements ICardSpacePolicy {
    public X509Certificate[] x509Cert;
    byte[] ppid;
    private CertStore certStore;
    static final String PPID_CLAIM = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/privatepersonalidentifier";
    static final String TOKEN_TYPE = "urn:oasis:names:tc:SAML:1.0:assertion";
    static final URI TOKEN_TYPE_URI = URI.create("urn:oasis:names:tc:SAML:1.0:assertion");

    public PPIDCardSpacePolicy(X509Certificate[] x509cert, CertStore certStore, byte[] ppid) {
        this.x509Cert = x509cert;
        this.certStore = certStore;
        this.ppid = ppid;
        this.tokenType = TOKEN_TYPE;
        this.issuer = "http://schemas.xmlsoap.org/ws/2005/05/identity/issuer/self";
        this.requiredClaims.add(PPID_CLAIM);
    }

    public boolean isSatisfiedBy(IInformationCard icard) {
        log.trace((Object)"CardSpacePolicy::isSatisfiedBy(IInformationCard icard)");
        log.trace((Object)("icard: " + icard));
        if (!this.issuer.equals(icard.getIssuer())) {
            log.trace((Object)"issuer not ok.");
            return false;
        }
        log.trace((Object)"issuer ok.");
        List suppTokenTypes = icard.getSupportedTokenTypes();
        log.trace((Object)("Supported token types: " + suppTokenTypes));
        if (suppTokenTypes == null || !suppTokenTypes.contains(TOKEN_TYPE_URI)) {
            log.trace((Object)("Token type: " + this.tokenType + " is not supported."));
        }
        try {
            byte[] ppid_card = PPIDHelper.computeClaimValuePPID((IInformationCard)icard, (X509Certificate[])this.x509Cert, (CertStore)this.certStore);
            return Arrays.equals(this.ppid, ppid_card);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

