package org.eclipse.higgins.icard.provider.cardspace.common.utils;

import java.util.ArrayList;

import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.icard.ICardProvider;
import org.eclipse.higgins.icard.ICardTemplate;
import org.eclipse.higgins.icard.IPersonalInformationCard;
import org.eclipse.higgins.icard.ITemplateContainer;
import org.eclipse.higgins.icard.ITemplateElement;
import org.eclipse.higgins.icard.ITemplateValue;
import org.eclipse.higgins.icard.common.CardTemplate;
import org.eclipse.higgins.icard.common.ClaimType;
import org.eclipse.higgins.icard.common.ClaimValue;
import org.eclipse.higgins.icard.common.TemplateContainer;
import org.eclipse.higgins.icard.common.TemplateValue;

public class PersonalCardTemplateHelper {

	public static final String CARD_TEMPLATE_ID = "PersonalCardTemplate";

	public static final String CARD_NAME = "cardName";

	public static final String CARD_PICTURE = "cardPicture";

	public static final String CLAIM_LIST = "claimList";

	public static CardTemplate getCardTemplate(ICardProvider provider) {
		CardTemplate cardTemplate = new CardTemplate(CARD_TEMPLATE_ID, "Personal card template", "Personal card template", provider, IPersonalInformationCard.class);
		cardTemplate.addTemplateElement(TemplateValue.createTextFieldTemplate(CARD_NAME, "Selfish", null, "Card name", "Card name", null, false));
		cardTemplate.addTemplateElement(TemplateValue.createFileTemplate(CARD_PICTURE, null, "Card picutre", "Card picutre", false));
		TemplateContainer claims = new TemplateContainer(CLAIM_LIST, "Information that will be sent with this card", "Claim list");
		ArrayList claimTypes = SelfIssuedCardClaims.getSupportedClaimTypeList();
		int size = claimTypes.size();
		for (int i = 0; i < size; i++) {
			ClaimType ct = (ClaimType) claimTypes.get(i);
			if (SelfIssuedCardClaims.PPID_TYPE.equals(ct.getType()))
				continue;
			String pattern = null;
			if (SelfIssuedCardClaims.EMAIL_ADDRESS_TYPE.equals(ct.getType()))
				pattern = "^\\w+\\S*@\\S+\\.[a-zA-Z]+$";
			ITemplateValue val = TemplateValue.createTextFieldTemplate(ct.getType(), "", pattern, ct.getDescription(), ct.getDisplayName(), null, false);
			claims.addTemplateElement(val);
		}
		cardTemplate.addTemplateElement(claims);
		return cardTemplate;
	}

	/**
	 * @param template
	 * @return <code>ArrayList</code>
	 */
	public static ArrayList getClaimsFromCardTemplate(ICardTemplate template) throws CardException {
		if (template == null)
			throw new CardException("Parameter \"template\" is null.");
		if (CARD_TEMPLATE_ID.equals(template.getID()) == false)
			throw new CardException("Unexpected template ID : " + template.getID());
		ITemplateElement te = template.getTemplateElementByID(CLAIM_LIST);
		if (te == null)
			throw new CardException("Claim list template container was not found.");
		if (te instanceof ITemplateContainer == false)
			throw new CardException("Claim list expected to be an instance of " + ITemplateContainer.class.getName());
		ITemplateContainer claimContainer = (ITemplateContainer) te;
		ArrayList supportedClaimTypes = SelfIssuedCardClaims.getSupportedClaimTypeList();
		ArrayList res = new ArrayList();
		int size = supportedClaimTypes.size();
		for (int i = 0; i < size; i++) {
			ClaimType claimType = (ClaimType) supportedClaimTypes.get(i);
			String type = claimType.getType();
			if (SelfIssuedCardClaims.PPID_TYPE.equals(type))
				continue;
			ITemplateValue value = claimContainer.getTemplateValueByID(type);
			if (value != null) {
				String val = value.getValue();
				if (val != null && val.trim().length() > 0)
					res.add(new ClaimValue(claimType, val));
			}
		}
		return res;
	}

}
