/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.icard.provider.cardspace.common;

import java.io.ByteArrayInputStream;
import java.io.StringReader;
import java.net.URI;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.icard.IEndpointReference;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.CardCryptography;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class EndpointReference
implements IEndpointReference {
    private Log log = LogFactory.getLog((Class)(class$org$eclipse$higgins$icard$provider$cardspace$common$EndpointReference == null ? (class$org$eclipse$higgins$icard$provider$cardspace$common$EndpointReference = EndpointReference.class$("org.eclipse.higgins.icard.provider.cardspace.common.EndpointReference")) : class$org$eclipse$higgins$icard$provider$cardspace$common$EndpointReference));
    protected URI address_ = null;
    protected X509Certificate certificate_ = null;
    protected URI metadataAddress_ = null;
    protected Element metadata_ = null;
    protected Element identity_ = null;
    static /* synthetic */ Class class$org$eclipse$higgins$icard$provider$cardspace$common$EndpointReference;

    public EndpointReference(URI address, String metadata, String identity) throws CardException {
        if (address == null) {
            throw new IllegalArgumentException("Parameter \"address\" is null.");
        }
        this.address_ = address;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setIgnoringComments(true);
        dbf.setIgnoringElementContentWhitespace(true);
        dbf.setNamespaceAware(true);
        dbf.setValidating(false);
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            if (metadata != null) {
                StringReader sisMetadata = new StringReader(metadata);
                InputSource isMetadata = new InputSource(sisMetadata);
                Document mdDoc = db.parse(isMetadata);
                this.metadata_ = mdDoc.getDocumentElement();
                this.metadata_.removeAttribute("xmlns");
            }
            if (identity != null) {
                StringReader sisIdentity = new StringReader(identity);
                InputSource isIdentity = new InputSource(sisIdentity);
                Document idntDoc = db.parse(isIdentity);
                this.identity_ = idntDoc.getDocumentElement();
            }
            this.parseMetadataAndCertificate();
        }
        catch (Exception e) {
            this.log.error((Object)e);
            throw new CardException((Throwable)e);
        }
    }

    private void parseMetadataAndCertificate() throws CardException {
        block9: {
            try {
                if (this.metadata_ != null) {
                    String mdAddr = null;
                    try {
                        Element metadata = XMLUtils.getChildElement(this.metadata_, "http://schemas.xmlsoap.org/ws/2004/09/mex", "Metadata");
                        Element metadataSection = XMLUtils.getChildElement(metadata, "http://schemas.xmlsoap.org/ws/2004/09/mex", "MetadataSection");
                        Element metadataReference = XMLUtils.getChildElement(metadataSection, "http://schemas.xmlsoap.org/ws/2004/09/mex", "MetadataReference");
                        Element address = XMLUtils.getChildElement(metadataReference, "http://www.w3.org/2005/08/addressing", "Address");
                        mdAddr = address.getFirstChild().getNodeValue();
                    }
                    catch (Exception e) {
                        this.log.error((Object)e);
                    }
                    if (mdAddr != null) {
                        this.metadataAddress_ = new URI(mdAddr);
                    }
                }
                if (this.identity_ == null) break block9;
                String certStr = null;
                try {
                    Element keyInfo = XMLUtils.getChildElement(this.identity_, "http://www.w3.org/2000/09/xmldsig#", "KeyInfo");
                    Element x509Data = XMLUtils.getChildElement(keyInfo, "http://www.w3.org/2000/09/xmldsig#", "X509Data");
                    Element x509Certificate = XMLUtils.getChildElement(x509Data, "http://www.w3.org/2000/09/xmldsig#", "X509Certificate");
                    certStr = x509Certificate.getFirstChild().getNodeValue();
                }
                catch (Exception e) {
                    this.log.error((Object)e);
                }
                if (certStr != null) {
                    byte[] certBytes = CardCryptography.decodeBase64(certStr);
                    ByteArrayInputStream bis = new ByteArrayInputStream(certBytes);
                    CertificateFactory cf = CertificateFactory.getInstance("X.509");
                    this.certificate_ = (X509Certificate)cf.generateCertificate(bis);
                }
            }
            catch (Exception e) {
                this.log.error((Object)e);
                throw new CardException((Throwable)e);
            }
        }
    }

    public EndpointReference(URI address, Element metadata, Element identity) throws CardException {
        if (address == null) {
            throw new CardException("Parameter \"address\" is null.");
        }
        this.address_ = address;
        this.metadata_ = metadata;
        this.identity_ = identity;
        this.parseMetadataAndCertificate();
    }

    public URI getAddress() {
        return this.address_;
    }

    public Element getMetadata() {
        return this.metadata_;
    }

    public Element getIdentity() {
        return this.identity_;
    }

    public X509Certificate getCertificate() {
        return this.certificate_;
    }

    public URI getMetadataAddress() {
        return this.metadataAddress_;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

