/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.icard.provider.cardspace.common.utils;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.icard.CardException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XMLUtils {
    protected static final Log log = LogFactory.getLog((Class)(class$org$eclipse$higgins$icard$provider$cardspace$common$utils$XMLUtils == null ? (class$org$eclipse$higgins$icard$provider$cardspace$common$utils$XMLUtils = XMLUtils.class$("org.eclipse.higgins.icard.provider.cardspace.common.utils.XMLUtils")) : class$org$eclipse$higgins$icard$provider$cardspace$common$utils$XMLUtils));
    static /* synthetic */ Class class$org$eclipse$higgins$icard$provider$cardspace$common$utils$XMLUtils;

    public static String elementToString(Element elm) throws TransformerException {
        if (elm == null) {
            return null;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        DOMSource source = new DOMSource(elm);
        StreamResult result = new StreamResult(bos);
        transformer.transform(source, result);
        byte[] buf = bos.toByteArray();
        if (buf == null) {
            return null;
        }
        return new String(buf);
    }

    public static String toString(OMElement omElement) throws Exception {
        if (null == omElement) {
            return null;
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        omElement.serialize((OutputStream)outputStream);
        String strElement = null;
        try {
            strElement = outputStream.toString("UTF-8");
            strElement = XMLUtils.StripNamespaceDeclaration(strElement);
        }
        catch (UnsupportedEncodingException uee) {
            log.error((Object)uee);
            throw uee;
        }
        return strElement;
    }

    public static String StripNamespaceDeclaration(String strElement) {
        boolean bNamespaceDeclaration = strElement.startsWith("<?xml");
        if (!bNamespaceDeclaration) {
            return strElement;
        }
        String strResult = strElement.substring(1);
        int nBegin = strResult.indexOf("<");
        return strResult.substring(nBegin);
    }

    public static ArrayList getChildElements(Element owner, String nameSpace, String localName) throws CardException {
        ArrayList<Node> children = new ArrayList<Node>();
        if (owner == null) {
            throw new CardException("Parameter \"owner\" is null.");
        }
        NodeList nl = owner.getChildNodes();
        int len = nl.getLength();
        for (int i = 0; i < len; ++i) {
            Node nd = nl.item(i);
            if (nd.getNodeType() != 1 || nameSpace != null && !nameSpace.equals(nd.getNamespaceURI()) || localName != null && !localName.equals(nd.getLocalName())) continue;
            children.add(nd);
        }
        return children;
    }

    public static Element getChildElement(Element owner, String nameSpace, String localName) throws CardException {
        ArrayList children = XMLUtils.getChildElements(owner, nameSpace, localName);
        switch (children.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (Element)children.get(0);
            }
        }
        throw new CardException("There are more then one child element with local name = " + localName + " and nameSpace = " + nameSpace);
    }

    public static String getTextContent(Element element) {
        NodeList nlChildren = element.getChildNodes();
        for (int i = 0; i < nlChildren.getLength(); ++i) {
            Node nodeChild = nlChildren.item(i);
            if (3 != nodeChild.getNodeType()) continue;
            Text textChild = (Text)nodeChild;
            return textChild.getData();
        }
        return null;
    }

    public static void setTextContent(Element element, String value) {
        NodeList nlChildren = element.getChildNodes();
        for (int i = 0; i < nlChildren.getLength(); ++i) {
            Node nodeChild = nlChildren.item(i);
            if (3 != nodeChild.getNodeType()) continue;
            Text textChild = (Text)nodeChild;
            if (value == null) {
                element.removeChild(textChild);
            } else {
                textChild.setData(value);
            }
            return;
        }
        if (value != null) {
            Text textNode = element.getOwnerDocument().createTextNode(value);
            element.appendChild(textNode);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

