/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.icard.provider.cardspace.common;

import java.net.URI;
import java.security.SecureRandom;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.icard.AuthenticationException;
import org.eclipse.higgins.icard.AuthenticationRequiredException;
import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.icard.IClaim;
import org.eclipse.higgins.icard.IClaimType;
import org.eclipse.higgins.icard.IPersonalInformationCard;
import org.eclipse.higgins.icard.InvalidTypeException;
import org.eclipse.higgins.icard.auth.ICredential;
import org.eclipse.higgins.icard.auth.ICredentialDescriptor;
import org.eclipse.higgins.icard.auth.IPinCodeCredential;
import org.eclipse.higgins.icard.common.ClaimType;
import org.eclipse.higgins.icard.common.ClaimValue;
import org.eclipse.higgins.icard.common.auth.BasicCredentialDescriptor;
import org.eclipse.higgins.icard.common.auth.PinCodeCredential;
import org.eclipse.higgins.icard.common.io.IOElement;
import org.eclipse.higgins.icard.common.utils.DateConvertor;
import org.eclipse.higgins.icard.io.CardIOException;
import org.eclipse.higgins.icard.io.IElement;
import org.eclipse.higgins.icard.io.IElementFormat;
import org.eclipse.higgins.icard.io.UnsupportedElementFormatException;
import org.eclipse.higgins.icard.provider.cardspace.common.InformationCard;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.CardCryptography;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.CardUtils;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.SelfIssuedCardClaims;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class PersonalCard
extends InformationCard
implements IPersonalInformationCard {
    protected static Log log;
    public static String ISSUER_SELF;
    protected HashMap dirtyClaimValueMap_ = null;
    protected URI claimListContextID_ = null;
    protected String claimListEntityID_ = null;
    protected byte[] pinDigest_ = null;
    protected int pinStatus;
    public static final int NO_PIN = 0;
    public static final int LOCKED = 1;
    public static final int UNLOCKED = 2;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.higgins.icard.provider.cardspace.common.PersonalCard");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
        ISSUER_SELF = "http://schemas.xmlsoap.org/ws/2005/05/identity/issuer/self";
    }

    public void initFromXML(Element card) throws CardException, DOMException {
        if (!"RoamingInformationCard".equals(card.getNodeName())) {
            throw new CardException("Can not init personal card from element " + card.getNodeName());
        }
        this.isSelfIssued_ = true;
        this.issuer_ = ISSUER_SELF;
        this.issuerName_ = "Self";
        Element informationCardMetaData = XMLUtils.getChildElement(card, "http://schemas.xmlsoap.org/ws/2005/05/identity", "InformationCardMetaData");
        if (informationCardMetaData == null) {
            throw new CardException("Can not find \"InformationCardMetaData\" element.");
        }
        this.language_ = null;
        if (informationCardMetaData.hasAttribute("xml:lang")) {
            this.language_ = informationCardMetaData.getAttribute("xml:lang");
        }
        Element informationCardPrivateData = XMLUtils.getChildElement(card, "http://schemas.xmlsoap.org/ws/2005/05/identity", "InformationCardPrivateData");
        this.checkIsSelfIssued(informationCardMetaData);
        this.id_ = CardUtils.parseCardId(informationCardMetaData);
        this.version_ = CardUtils.parseCardVersion(informationCardMetaData);
        this.name_ = CardUtils.parseCardName(informationCardMetaData);
        this.image_ = CardUtils.parseCardImage(informationCardMetaData);
        this.imageMimeType_ = CardUtils.parseCardImageType(informationCardMetaData);
        this.timeIssued_ = CardUtils.parseTimeIssued(informationCardMetaData);
        this.timeExpires_ = CardUtils.parseTimeExpires(informationCardMetaData);
        this.supportedTokenTypes_ = CardUtils.parseSupportedTokenTypes(informationCardMetaData);
        this.claimTypes_ = this.parseClaimTypes(informationCardMetaData);
        this.hashSalt_ = CardUtils.parseHashSalt(informationCardMetaData);
        this.pinDigest_ = CardUtils.parsePinDigest(informationCardMetaData);
        this.issuerID_ = CardUtils.parseIssuerID(informationCardMetaData);
        this.timeLastUpdated_ = CardUtils.parseTimeLastUpdated(informationCardMetaData);
        this.extensions_ = CardUtils.parseExtensions(informationCardMetaData);
        this.dirtyClaimValueMap_ = CardUtils.parseClaimValues(informationCardPrivateData);
        this.masterKey_ = CardUtils.parseMasterKey(card);
        this.pinStatus = this.pinDigest_ != null && this.pinDigest_.length > 0 ? 1 : 0;
    }

    private void checkIsSelfIssued(Element metaData) throws CardException {
        String boolValue;
        Element isSelfIssued = XMLUtils.getChildElement(metaData, "http://schemas.xmlsoap.org/ws/2005/05/identity", "IsSelfIssued");
        String string = boolValue = isSelfIssued != null ? XMLUtils.getTextContent(isSelfIssued) : "";
        if (boolValue == null || !"true".equals(boolValue.trim().toLowerCase())) {
            throw new CardException("Can not import non-self issued card.");
        }
    }

    protected List parseClaimTypes(Element metaData) throws CardException {
        List res = CardUtils.parseClaimTypes(metaData);
        res.add(new ClaimType("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/privatepersonalidentifier", "Private Personal Identifier", "Private Personal Identifier", false, false));
        return res;
    }

    public URI getClaimListContextID() {
        return this.claimListContextID_;
    }

    public String getClaimListEntityID() {
        return this.claimListEntityID_;
    }

    public IElement toElement(IElementFormat format) throws CardException, CardIOException, UnsupportedElementFormatException {
        if (!this.isFormatSupported(format)) {
            throw new CardException("Unsupported element format: " + format);
        }
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setIgnoringComments(true);
            dbf.setIgnoringElementContentWhitespace(true);
            dbf.setNamespaceAware(true);
            dbf.setValidating(false);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.newDocument();
            Element card = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "RoamingInformationCard");
            Element metaData = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "InformationCardMetaData");
            if (this.language_ != null) {
                metaData.setAttribute("xml:lang", this.language_);
            } else {
                metaData.setAttribute("xml:lang", "en");
            }
            card.appendChild(metaData);
            this.addCardReference(doc, metaData);
            this.addCardName(doc, metaData);
            this.addCardImage(doc, metaData);
            this.addIssuer(doc, metaData);
            this.addTimeIssued(doc, metaData);
            this.addTimeExpires(doc, metaData);
            this.addSupportedTokenTypes(doc, metaData);
            this.addClaimTypes(doc, metaData);
            this.addIsSelfIssued(doc, metaData);
            this.addPinDigest(doc, metaData);
            this.addHashSalt(doc, metaData);
            this.addTimeLastUpdated(doc, metaData);
            this.addIssuerID(doc, metaData);
            this.addIssuerName(doc, metaData);
            this.addBackgroundColor(doc, metaData);
            Element privateData = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "InformationCardPrivateData");
            Element masterKey = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "MasterKey");
            if (this.masterKey_ == null) {
                byte[] cfr_ignored_0 = new byte[32];
                this.masterKey_ = SecureRandom.getSeed(32);
            }
            String base64Key = CardCryptography.encodeBase64(this.masterKey_, 0);
            masterKey.appendChild(doc.createTextNode(base64Key));
            privateData.appendChild(masterKey);
            Element claimValueList = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "ClaimValueList");
            Iterator supportedClaimTypes = SelfIssuedCardClaims.getSupportedClaimTypeList().iterator();
            while (supportedClaimTypes.hasNext()) {
                IClaimType claimType = (IClaimType)supportedClaimTypes.next();
                String type = claimType.getType();
                ClaimValue claim = (ClaimValue)this.dirtyClaimValueMap_.get(type);
                if ("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/privatepersonalidentifier".equals(type)) continue;
                Element claimValue = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "ClaimValue");
                claimValue.setAttribute("Uri", type);
                String valueStr = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/gender".equals(type) ? SelfIssuedCardClaims.getGenderCode(claim.getValue()) : claim.getValue();
                Element value = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "Value");
                value.appendChild(doc.createTextNode(valueStr));
                claimValue.appendChild(value);
                claimValueList.appendChild(claimValue);
            }
            privateData.appendChild(claimValueList);
            card.appendChild(privateData);
            IOElement element = new IOElement();
            element.set((Object)card);
            return element;
        }
        catch (Exception e) {
            log.error((Object)"Can't export card", (Throwable)e);
            throw new CardException("Can't export card", (Throwable)e);
        }
    }

    private void addIsSelfIssued(Document doc, Element informationCardMetaData) {
        Element IsSelfIssued = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "IsSelfIssued");
        informationCardMetaData.appendChild(IsSelfIssued);
        XMLUtils.setTextContent(IsSelfIssued, "true");
    }

    private void addIssuerName(Document doc, Element informationCardMetaData) {
        Element IssuerName = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "IssuerName");
        informationCardMetaData.appendChild(IssuerName);
        XMLUtils.setTextContent(IssuerName, "Self");
    }

    private void addIssuerID(Document doc, Element informationCardMetaData) {
        Element issuerID = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "IssuerId");
        informationCardMetaData.appendChild(issuerID);
        if (this.issuerID_ != null) {
            XMLUtils.setTextContent(issuerID, CardCryptography.encodeBase64(this.issuerID_, 0));
        }
    }

    private void addHashSalt(Document doc, Element informationCardMetaData) {
        Element hashSalt = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "HashSalt");
        informationCardMetaData.appendChild(hashSalt);
        XMLUtils.setTextContent(hashSalt, CardCryptography.encodeBase64(this.hashSalt_, 0));
    }

    private void addPinDigest(Document doc, Element informationCardMetaData) {
        if (this.pinDigest_ != null) {
            Element pinDigest = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "PinDigest");
            informationCardMetaData.appendChild(pinDigest);
            XMLUtils.setTextContent(pinDigest, CardCryptography.encodeBase64(this.pinDigest_, 0));
        }
    }

    private void addTimeLastUpdated(Document doc, Element informationCardMetaData) {
        Element timeLastUpdated = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "TimeLastUpdated");
        informationCardMetaData.appendChild(timeLastUpdated);
        String time = DateConvertor.format((Date)this.timeLastUpdated_);
        XMLUtils.setTextContent(timeLastUpdated, time);
    }

    private void addBackgroundColor(Document doc, Element informationCardMetaData) {
        Element bgcolor = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "BackgroundColor");
        informationCardMetaData.appendChild(bgcolor);
        XMLUtils.setTextContent(bgcolor, "0");
    }

    private void addTokenServiceList(Document doc, Element informationCardMetaData) {
        Element tokenServiceList = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "TokenServiceList");
        informationCardMetaData.appendChild(tokenServiceList);
        Element tokenService = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "TokenService");
        tokenServiceList.appendChild(tokenService);
        Element endpointReference = doc.createElementNS("http://www.w3.org/2005/08/addressing", "EndpointReference");
        tokenService.appendChild(endpointReference);
        Element address = doc.createElementNS("http://www.w3.org/2005/08/addressing", "Address");
        XMLUtils.setTextContent(address, ISSUER_SELF);
        endpointReference.appendChild(address);
        Element metaData = doc.createElementNS("http://www.w3.org/2005/08/addressing", "Metadata");
        endpointReference.appendChild(metaData);
        Element metaDataMex = doc.createElementNS("http://schemas.xmlsoap.org/ws/2004/09/mex", "Metadata");
        metaData.appendChild(metaDataMex);
        Element metaDataSection = doc.createElementNS("http://schemas.xmlsoap.org/ws/2004/09/mex", "MetadataSection");
        metaDataMex.appendChild(metaDataSection);
        Element metaDataReference = doc.createElementNS("http://schemas.xmlsoap.org/ws/2004/09/mex", "MetadataReference");
        metaDataSection.appendChild(metaDataReference);
        Element mexAddress = doc.createElementNS("http://schemas.xmlsoap.org/ws/2004/09/mex", "Address");
        metaDataReference.appendChild(mexAddress);
    }

    public Element claimsToXML(Document doc) throws CardException {
        Element root = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "ClaimValueList");
        doc.appendChild(root);
        Set setClaimValues = this.claimValues_.entrySet();
        Iterator values = setClaimValues.iterator();
        while (values.hasNext()) {
            Map.Entry meClaimValue = values.next();
            ClaimValue claim = (ClaimValue)meClaimValue.getValue();
            Element claimValue = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "ClaimValue");
            claimValue.setAttribute("Uri", claim.getType().toString());
            root.appendChild(claimValue);
            Element value = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "Value");
            XMLUtils.setTextContent(value, claim.getValue());
            claimValue.appendChild(value);
        }
        return root;
    }

    private void addCardReference(Document doc, Element root) {
        Element ref = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "InformationCardReference");
        root.appendChild(ref);
        Element id = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "CardId");
        XMLUtils.setTextContent(id, this.id_.toString());
        ref.appendChild(id);
        Element version = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "CardVersion");
        XMLUtils.setTextContent(version, this.version_);
        ref.appendChild(version);
    }

    private void addCardName(Document doc, Element root) {
        if (this.name_ != null) {
            Element name = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "CardName");
            XMLUtils.setTextContent(name, this.name_);
            root.appendChild(name);
        }
    }

    private void addCardImage(Document doc, Element root) {
        if (this.image_ != null) {
            Element image = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "CardImage");
            image.setAttribute("MimeType", this.imageMimeType_);
            XMLUtils.setTextContent(image, CardCryptography.encodeBase64(this.image_, 0));
            root.appendChild(image);
        }
    }

    private void addIssuer(Document doc, Element root) {
        Element issuer = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "Issuer");
        XMLUtils.setTextContent(issuer, this.issuer_);
        root.appendChild(issuer);
    }

    private void addTimeIssued(Document doc, Element root) {
        String time = DateConvertor.format((Date)this.timeIssued_);
        Element timeIssued = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "TimeIssued");
        XMLUtils.setTextContent(timeIssued, time);
        root.appendChild(timeIssued);
    }

    private void addTimeExpires(Document doc, Element root) {
        if (this.timeExpires_ != null) {
            String time = DateConvertor.format((Date)this.timeExpires_);
            Element timeExpires = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "TimeExpires");
            XMLUtils.setTextContent(timeExpires, time);
            root.appendChild(timeExpires);
        }
    }

    private void addSupportedTokenTypes(Document doc, Element root) {
        Element tokenList = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "SupportedTokenTypeList");
        root.appendChild(tokenList);
        Iterator it = this.supportedTokenTypes_.iterator();
        while (it.hasNext()) {
            String uri = it.next().toString();
            Element tokenType = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/02/trust", "TokenType");
            XMLUtils.setTextContent(tokenType, uri);
            tokenList.appendChild(tokenType);
        }
    }

    private void addClaimTypes(Document doc, Element root) {
        Element claimTypeList = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "SupportedClaimTypeList");
        root.appendChild(claimTypeList);
        Iterator it = this.claimTypes_.iterator();
        while (it.hasNext()) {
            IClaimType type = (IClaimType)it.next();
            if ("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/privatepersonalidentifier".equals(type.getType())) continue;
            Element claimType = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "SupportedClaimType");
            claimType.setAttribute("Uri", type.getType().toString());
            claimTypeList.appendChild(claimType);
            Element displayTag = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "DisplayTag");
            XMLUtils.setTextContent(displayTag, type.getDisplayName());
            claimType.appendChild(displayTag);
            Element description = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/05/identity", "Description");
            XMLUtils.setTextContent(description, type.getDescription());
            claimType.appendChild(description);
        }
    }

    public byte[] getPinDigest() throws CardException {
        return this.pinDigest_;
    }

    public IClaim getClaim(String type) throws AuthenticationRequiredException, InvalidTypeException, CardException {
        List supportedTypes = this.getSupportedClaimTypesUris();
        if (type == null || !supportedTypes.contains(type)) {
            throw new InvalidTypeException("Claim type: " + type + " is not supported.");
        }
        if (this.claimValues_ == null) {
            this.retrieveClaims(null);
        }
        if (this.claimValues_ == null) {
            throw new AuthenticationRequiredException();
        }
        if (this.claimValues_.containsKey(type)) {
            return (IClaim)this.claimValues_.get(type);
        }
        return null;
    }

    public IClaim getClaimByLocalName(String shortTypeName) throws AuthenticationRequiredException, InvalidTypeException, CardException {
        if (this.claimValuesByLocalName_ == null) {
            this.retrieveClaims(null);
        }
        if (this.claimValuesByLocalName_ == null) {
            throw new AuthenticationRequiredException();
        }
        if (this.claimValuesByLocalName_.containsKey(shortTypeName)) {
            return (IClaim)this.claimValuesByLocalName_.get(shortTypeName);
        }
        throw new InvalidTypeException("Claim with local type name: " + shortTypeName + " is not supported.");
    }

    public Iterator getClaims() throws CardException {
        if (this.claimValues_ == null) {
            this.retrieveClaims(null);
        }
        if (this.claimValues_ == null) {
            throw new AuthenticationRequiredException();
        }
        return this.claimValues_.values().iterator();
    }

    public ICredentialDescriptor[] getRequiredCredentials() {
        ICredentialDescriptor[] requiredCredentials = null;
        if (this.pinDigest_ != null) {
            requiredCredentials = new ICredentialDescriptor[]{new BasicCredentialDescriptor("PinCodeCredential", "Please provide PIN code", (ICredential)new PinCodeCredential())};
        }
        return requiredCredentials;
    }

    public int getPinStatus() {
        return this.pinStatus;
    }

    public abstract boolean validatePINCode(String var1) throws Exception;

    public abstract void lock(IPinCodeCredential var1) throws Exception;

    public abstract void unlock(IPinCodeCredential var1) throws Exception;

    protected abstract void retrieveClaims(ICredential var1) throws AuthenticationRequiredException, AuthenticationException, CardException;

    public String getType() {
        return "IPersonalInformationCard";
    }
}

