/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.icard.provider.cardspace.common.utils;

import com.ibm.icu.text.SimpleDateFormat;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.icard.IClaim;
import org.eclipse.higgins.icard.IClaimType;
import org.eclipse.higgins.icard.ISimpleClaim;
import org.eclipse.higgins.icard.ISimpleClaimType;
import org.eclipse.higgins.icard.IUIDescriptor;
import org.eclipse.higgins.icard.InvalidClaimException;
import org.eclipse.higgins.icard.InvalidTypeException;
import org.eclipse.higgins.icard.common.ClaimType;
import org.eclipse.higgins.icard.common.ClaimValue;
import org.eclipse.higgins.icard.common.UIDescriptor;

public class SelfIssuedCardClaims {
    public static final String GIVEN_NAME_TYPE = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/givenname";
    public static final String GIVEN_NAME_NAME = "First Name";
    public static final String GIVEN_NAME_DESC = "First Name";
    public static final String SURNAME_TYPE = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/surname";
    public static final String SURNAME_NAME = "Last Name";
    public static final String SURNAME_DESC = "Last Name";
    public static final String EMAIL_ADDRESS_TYPE = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/emailaddress";
    public static final String EMAIL_ADDRESS_NAME = "Email Address";
    public static final String EMAIL_ADDRESS_DESC = "Email Address";
    public static final String STREET_ADDRESS_TYPE = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/streetaddress";
    public static final String STREET_ADDRESS_NAME = "Street";
    public static final String STREET_ADDRESS_DESC = "Street";
    public static final String LOCALITY_TYPE = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/locality";
    public static final String LOCALITY_NAME = "City";
    public static final String LOCALITY_DESC = "City";
    public static final String STATE_OR_PROVINCE_TYPE = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/stateorprovince";
    public static final String STATE_OR_PROVINCE_NAME = "State";
    public static final String STATE_OR_PROVINCE_DESC = "State";
    public static final String POSTAL_CODE_TYPE = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/postalcode";
    public static final String POSTAL_CODE_NAME = "Postal Code";
    public static final String POSTAL_CODE_DESC = "Postal Code";
    public static final String COUNTRY_TYPE = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/country";
    public static final String COUNTRY_NAME = "Country/Region";
    public static final String COUNTRY_DESC = "Country/Region";
    public static final String HOME_PHONE_TYPE = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/homephone";
    public static final String HOME_PHONE_NAME = "Home Phone";
    public static final String HOME_PHONE_DESC = "Home Phone Number";
    public static final String OTHER_PHONE_TYPE = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/otherphone";
    public static final String OTHER_PHONE_NAME = "Other Phone";
    public static final String OTHER_PHONE_DESC = "Other Phone Number";
    public static final String MOBILE_PHONE_TYPE = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/mobilephone";
    public static final String MOBILE_PHONE_NAME = "Mobile Phone";
    public static final String MOBILE_PHONE_DESC = "Mobile Phone Number";
    public static final String DATE_OF_BIRTH_TYPE = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/dateofbirth";
    public static final String DATE_OF_BIRTH_NAME = "Date of Birth";
    public static final String DATE_OF_BIRTH_DESC = "Date of Birth";
    public static final String GENDER_TYPE = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/gender";
    public static final String GENDER_NAME = "Gender";
    public static final String GENDER_DESC = "Gender";
    public static final String WEB_PAGE_TYPE = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/webpage";
    public static final String WEB_PAGE_NAME = "Web Page";
    public static final String WEB_PAGE_DESC = "Web Page";
    public static final String PPID_TYPE = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/privatepersonalidentifier";
    public static final String PPID_NAME = "Site Specific Card ID";
    public static final String PPID_DESC = "Site Specific Card ID";
    private static Hashtable claimTypes_;
    private static ArrayList claimTypesList_;
    private Hashtable claimValues_ = SelfIssuedCardClaims.getSupportedTypesHash();
    public static final String GENDER_MALE = "Male";
    public static final String GENDER_FEMALE = "Female";
    private static final SimpleDateFormat BIRTH_SDF;
    private static final ArrayList GENDER_LIST;
    static /* synthetic */ Class class$0;

    static {
        block7: {
            BIRTH_SDF = new SimpleDateFormat("yyyy-MM-dd");
            GENDER_LIST = new ArrayList();
            try {
                BIRTH_SDF.setLenient(false);
                GENDER_LIST.add("");
                GENDER_LIST.add(GENDER_MALE);
                GENDER_LIST.add(GENDER_FEMALE);
                UIDescriptor dateOfBirthDescriptor = UIDescriptor.createDateTimeDescriptor((String)"YYYY-MM-DD", null);
                UIDescriptor genderDescriptor = UIDescriptor.createComboBoxDescriptor((List)GENDER_LIST);
                ClaimType givenName = new ClaimType(GIVEN_NAME_TYPE, "First Name", "First Name");
                ClaimType surName = new ClaimType(SURNAME_TYPE, "Last Name", "Last Name");
                ClaimType email = new ClaimType(EMAIL_ADDRESS_TYPE, "Email Address", "Email Address");
                ClaimType street = new ClaimType(STREET_ADDRESS_TYPE, "Street", "Street");
                ClaimType locality = new ClaimType(LOCALITY_TYPE, "City", "City");
                ClaimType state = new ClaimType(STATE_OR_PROVINCE_TYPE, "State", "State");
                ClaimType postalCode = new ClaimType(POSTAL_CODE_TYPE, "Postal Code", "Postal Code");
                ClaimType country = new ClaimType(COUNTRY_TYPE, "Country/Region", "Country/Region");
                ClaimType homePhone = new ClaimType(HOME_PHONE_TYPE, HOME_PHONE_NAME, HOME_PHONE_DESC);
                ClaimType otherPhone = new ClaimType(OTHER_PHONE_TYPE, OTHER_PHONE_NAME, OTHER_PHONE_DESC);
                ClaimType mobilePhone = new ClaimType(MOBILE_PHONE_TYPE, MOBILE_PHONE_NAME, MOBILE_PHONE_DESC);
                ClaimType dateOfBirth = new ClaimType(DATE_OF_BIRTH_TYPE, "Date of Birth", "Date of Birth");
                dateOfBirth.setUIDescriptor((IUIDescriptor)dateOfBirthDescriptor);
                ClaimType gender = new ClaimType(GENDER_TYPE, "Gender", "Gender");
                gender.setUIDescriptor((IUIDescriptor)genderDescriptor);
                ClaimType webPage = new ClaimType(WEB_PAGE_TYPE, "Web Page", "Web Page");
                ClaimType ppid = new ClaimType(PPID_TYPE, "Site Specific Card ID", "Site Specific Card ID", false, false);
                claimTypesList_ = new ArrayList();
                claimTypesList_.add(givenName);
                claimTypesList_.add(surName);
                claimTypesList_.add(email);
                claimTypesList_.add(street);
                claimTypesList_.add(locality);
                claimTypesList_.add(state);
                claimTypesList_.add(postalCode);
                claimTypesList_.add(country);
                claimTypesList_.add(homePhone);
                claimTypesList_.add(otherPhone);
                claimTypesList_.add(mobilePhone);
                claimTypesList_.add(dateOfBirth);
                claimTypesList_.add(gender);
                claimTypesList_.add(webPage);
                claimTypesList_.add(ppid);
                claimTypes_ = new Hashtable();
                int i = 0;
                int j = claimTypesList_.size();
                while (i < j) {
                    ClaimType ct = (ClaimType)claimTypesList_.get(i);
                    claimTypes_.put(ct.getType(), ct);
                    ++i;
                }
            }
            catch (CardException e) {
                Log log;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.higgins.icard.provider.cardspace.common.utils.SelfIssuedCardClaims");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((log = LogFactory.getLog((Class)clazz)) == null) break block7;
                log.error((Object)e);
            }
        }
    }

    public SelfIssuedCardClaims(List claimValues) throws CardException {
        if (claimValues != null) {
            int size = claimValues.size();
            int i = 0;
            while (i < size) {
                IClaim value = (IClaim)claimValues.get(i);
                IClaimType claimType = value.getType();
                if (claimType == null) {
                    throw new InvalidClaimException("Claim doestn't contain claim type.");
                }
                if (!claimType.isSimple()) {
                    throw new InvalidTypeException("Complex clime type: " + claimType.getType() + " is not supported.");
                }
                ISimpleClaimType simpleType = null;
                try {
                    simpleType = (ISimpleClaimType)claimType;
                }
                catch (ClassCastException e) {
                    throw new InvalidTypeException((Throwable)e);
                }
                if (simpleType.getMaxCardinality() != 1) {
                    throw new InvalidTypeException("Unsupported multivalued clime type: " + claimType.getType());
                }
                URI type = null;
                try {
                    type = new URI(claimType.getType());
                }
                catch (URISyntaxException e) {
                    throw new CardException((Throwable)e);
                }
                if (type == null) {
                    throw new InvalidTypeException("Claim type contains null type URI.");
                }
                String typeStr = type.toString();
                if (!claimTypes_.containsKey(typeStr)) {
                    throw new InvalidTypeException("Unsupported claim type : " + typeStr);
                }
                ISimpleClaim simple = null;
                try {
                    simple = (ISimpleClaim)value;
                }
                catch (ClassCastException e) {
                    throw new InvalidClaimException((Throwable)e);
                }
                List values = simple.getValues();
                if (values.size() > 0) {
                    this.claimValues_.put(typeStr, values.get(0));
                }
                ++i;
            }
        }
    }

    public void setGivenName(String value) {
        if (value == null || value.trim().length() == 0) {
            this.claimValues_.put(GIVEN_NAME_TYPE, "");
        } else {
            this.claimValues_.put(GIVEN_NAME_TYPE, value.trim());
        }
    }

    public void setSurName(String value) {
        if (value == null || value.trim().length() == 0) {
            this.claimValues_.put(SURNAME_TYPE, "");
        } else {
            this.claimValues_.put(SURNAME_TYPE, value.trim());
        }
    }

    public void setEmailAddress(String value) {
        if (value == null || value.trim().length() == 0) {
            this.claimValues_.put(EMAIL_ADDRESS_TYPE, "");
        } else {
            this.claimValues_.put(EMAIL_ADDRESS_TYPE, value.trim());
        }
    }

    public void setStreetAddress(String value) {
        if (value == null || value.trim().length() == 0) {
            this.claimValues_.put(STREET_ADDRESS_TYPE, "");
        } else {
            this.claimValues_.put(STREET_ADDRESS_TYPE, value.trim());
        }
    }

    public void setLocality(String value) {
        if (value == null || value.trim().length() == 0) {
            this.claimValues_.put(LOCALITY_TYPE, "");
        } else {
            this.claimValues_.put(LOCALITY_TYPE, value.trim());
        }
    }

    public void setStateOrProvince(String value) {
        if (value == null || value.trim().length() == 0) {
            this.claimValues_.put(STATE_OR_PROVINCE_TYPE, "");
        } else {
            this.claimValues_.put(STATE_OR_PROVINCE_TYPE, value.trim());
        }
    }

    public void setPostalCode(String value) {
        if (value == null || value.trim().length() == 0) {
            this.claimValues_.put(POSTAL_CODE_TYPE, "");
        } else {
            this.claimValues_.put(POSTAL_CODE_TYPE, value.trim());
        }
    }

    public void setCountry(String value) {
        if (value == null || value.trim().length() == 0) {
            this.claimValues_.put(COUNTRY_TYPE, "");
        } else {
            this.claimValues_.put(COUNTRY_TYPE, value.trim());
        }
    }

    public void setHomePhone(String value) {
        if (value == null || value.trim().length() == 0) {
            this.claimValues_.put(HOME_PHONE_TYPE, "");
        } else {
            this.claimValues_.put(HOME_PHONE_TYPE, value.trim());
        }
    }

    public void setOtherPhone(String value) {
        if (value == null || value.trim().length() == 0) {
            this.claimValues_.put(OTHER_PHONE_TYPE, "");
        } else {
            this.claimValues_.put(OTHER_PHONE_TYPE, value.trim());
        }
    }

    public void setMobilePhone(String value) {
        if (value == null || value.trim().length() == 0) {
            this.claimValues_.put(MOBILE_PHONE_TYPE, "");
        } else {
            this.claimValues_.put(MOBILE_PHONE_TYPE, value.trim());
        }
    }

    public void setDateOfBirth(String value) {
        if (value == null || value.trim().length() == 0) {
            this.claimValues_.put(DATE_OF_BIRTH_TYPE, "");
        } else {
            this.claimValues_.put(DATE_OF_BIRTH_TYPE, value.trim());
        }
    }

    public void setGender(String value) {
        if (value == null || value.trim().length() == 0) {
            this.claimValues_.put(GENDER_TYPE, "");
        } else {
            this.claimValues_.put(GENDER_TYPE, value.trim());
        }
    }

    public void setWebPage(String value) {
        if (value == null || value.trim().length() == 0) {
            this.claimValues_.put(WEB_PAGE_TYPE, "");
        } else {
            this.claimValues_.put(WEB_PAGE_TYPE, value.trim());
        }
    }

    public void setPrivatePersonalIdentifier(String value) {
        if (value == null || value.trim().length() == 0) {
            this.claimValues_.put(PPID_TYPE, "");
        } else {
            this.claimValues_.put(PPID_TYPE, value.trim());
        }
    }

    public String getGivenName() {
        if (this.claimValues_.containsKey(GIVEN_NAME_TYPE)) {
            return this.claimValues_.get(GIVEN_NAME_TYPE).toString();
        }
        return "";
    }

    public String getSurName() {
        if (this.claimValues_.containsKey(SURNAME_TYPE)) {
            return this.claimValues_.get(SURNAME_TYPE).toString();
        }
        return "";
    }

    public String getEmailAddress() {
        if (this.claimValues_.containsKey(EMAIL_ADDRESS_TYPE)) {
            return this.claimValues_.get(EMAIL_ADDRESS_TYPE).toString();
        }
        return "";
    }

    public String getStreetAddress() {
        if (this.claimValues_.containsKey(STREET_ADDRESS_TYPE)) {
            return this.claimValues_.get(STREET_ADDRESS_TYPE).toString();
        }
        return "";
    }

    public String getLocality() {
        if (this.claimValues_.containsKey(LOCALITY_TYPE)) {
            return this.claimValues_.get(LOCALITY_TYPE).toString();
        }
        return "";
    }

    public String getStateOrProvince() {
        if (this.claimValues_.containsKey(STATE_OR_PROVINCE_TYPE)) {
            return this.claimValues_.get(STATE_OR_PROVINCE_TYPE).toString();
        }
        return "";
    }

    public String getPostalCode() {
        if (this.claimValues_.containsKey(POSTAL_CODE_TYPE)) {
            return this.claimValues_.get(POSTAL_CODE_TYPE).toString();
        }
        return "";
    }

    public String getCountry() {
        if (this.claimValues_.containsKey(COUNTRY_TYPE)) {
            return this.claimValues_.get(COUNTRY_TYPE).toString();
        }
        return "";
    }

    public String getHomePhone() {
        if (this.claimValues_.containsKey(HOME_PHONE_TYPE)) {
            return this.claimValues_.get(HOME_PHONE_TYPE).toString();
        }
        return "";
    }

    public String getOtherPhone() {
        if (this.claimValues_.containsKey(OTHER_PHONE_TYPE)) {
            return this.claimValues_.get(OTHER_PHONE_TYPE).toString();
        }
        return "";
    }

    public String getMobilePhone() {
        if (this.claimValues_.containsKey(MOBILE_PHONE_TYPE)) {
            return this.claimValues_.get(MOBILE_PHONE_TYPE).toString();
        }
        return "";
    }

    public String getDateOfBirth() {
        if (this.claimValues_.containsKey(DATE_OF_BIRTH_TYPE)) {
            return this.claimValues_.get(DATE_OF_BIRTH_TYPE).toString();
        }
        return "";
    }

    public String getGender() {
        if (this.claimValues_.containsKey(GENDER_TYPE)) {
            return this.claimValues_.get(GENDER_TYPE).toString();
        }
        return "";
    }

    public String getWebPage() {
        if (this.claimValues_.containsKey(WEB_PAGE_TYPE)) {
            return this.claimValues_.get(WEB_PAGE_TYPE).toString();
        }
        return "";
    }

    public String getPrivatePersonalIdentifier() {
        if (this.claimValues_.containsKey(PPID_TYPE)) {
            return this.claimValues_.get(PPID_TYPE).toString();
        }
        return "";
    }

    public ArrayList getClaimValueList(boolean skipEmptyValues) throws CardException {
        ArrayList<ClaimValue> list = new ArrayList<ClaimValue>();
        Enumeration types = this.claimValues_.keys();
        while (types.hasMoreElements()) {
            String type = (String)types.nextElement();
            String value = (String)this.claimValues_.get(type);
            if (value == null || value.trim().length() <= 0) continue;
            ClaimType cType = SelfIssuedCardClaims.getClaimType(type);
            list.add(new ClaimValue((ISimpleClaimType)cType, value));
        }
        return list;
    }

    public static ArrayList getSupportedClaimTypeList() {
        ArrayList al = new ArrayList();
        al.addAll(claimTypesList_);
        return al;
    }

    public static ClaimType getClaimType(String type) throws CardException {
        if (type == null) {
            throw new CardException("Parameter \"type\" is null.");
        }
        if (claimTypes_.containsKey(type)) {
            return (ClaimType)((ClaimType)claimTypes_.get(type)).clone();
        }
        throw new CardException("Unsupported self-issued claim type : " + type);
    }

    public static ClaimType getClaimType(URI type) throws CardException {
        if (type == null) {
            throw new CardException("Parameter \"type\" is null.");
        }
        return SelfIssuedCardClaims.getClaimType(type.toString());
    }

    public static Hashtable getSupportedTypesHash() {
        Hashtable<String, String> claimValues = new Hashtable<String, String>();
        claimValues.put(GIVEN_NAME_TYPE, "1");
        claimValues.put(SURNAME_TYPE, "2");
        claimValues.put(EMAIL_ADDRESS_TYPE, "3");
        claimValues.put(STREET_ADDRESS_TYPE, "4");
        claimValues.put(LOCALITY_TYPE, "5");
        claimValues.put(STATE_OR_PROVINCE_TYPE, "6");
        claimValues.put(POSTAL_CODE_TYPE, "7");
        claimValues.put(COUNTRY_TYPE, "8");
        claimValues.put(HOME_PHONE_TYPE, "9");
        claimValues.put(OTHER_PHONE_TYPE, "10");
        claimValues.put(MOBILE_PHONE_TYPE, "11");
        claimValues.put(DATE_OF_BIRTH_TYPE, "12");
        claimValues.put(GENDER_TYPE, "13");
        claimValues.put(WEB_PAGE_TYPE, "14");
        claimValues.put(PPID_TYPE, "15");
        return claimValues;
    }

    public static String getGenderClaimValue(String genderCode) throws CardException {
        if (genderCode == null || "".equals(genderCode) || "0".equals(genderCode)) {
            return "";
        }
        if ("1".equals(genderCode)) {
            return GENDER_MALE;
        }
        if ("2".equals(genderCode)) {
            return GENDER_FEMALE;
        }
        throw new CardException("Unsupported claim value :" + genderCode);
    }

    public static String getGenderCode(String genderClaimValue) throws CardException {
        if (GENDER_MALE.equalsIgnoreCase(genderClaimValue)) {
            return "1";
        }
        if (GENDER_FEMALE.equalsIgnoreCase(genderClaimValue)) {
            return "2";
        }
        if (genderClaimValue == null || genderClaimValue.trim().length() == 0) {
            return "";
        }
        throw new CardException("Unsupported claim value :" + genderClaimValue);
    }

    public static void validateClaimValue(String claimValue, String claimType) throws CardException {
        if (GENDER_TYPE.equals(claimType)) {
            if (claimType != null && !GENDER_LIST.contains(claimValue)) {
                throw new CardException("Unsupported claim value for claim type http://schemas.xmlsoap.org/ws/2005/05/identity/claims/gender");
            }
        } else if (DATE_OF_BIRTH_TYPE.equals(claimType) && claimValue != null && claimValue.length() > 0) {
            try {
                BIRTH_SDF.parse(claimValue);
            }
            catch (ParseException parseException) {
                throw new CardException("Incorrect value of claim http://schemas.xmlsoap.org/ws/2005/05/identity/claims/dateofbirth");
            }
        }
    }

    public static ArrayList getGenderValuesList() {
        ArrayList al = new ArrayList();
        al.addAll(GENDER_LIST);
        return al;
    }

    public static String convertICMDate(String dateICM) throws CardException {
        if (dateICM != null && dateICM.trim().length() > 0) {
            try {
                BIRTH_SDF.parse(dateICM);
                return dateICM;
            }
            catch (ParseException parseException) {
                SimpleDateFormat sdf = new SimpleDateFormat("MMMM dd, yyyy");
                sdf.setLenient(false);
                try {
                    Date dt = sdf.parse(dateICM);
                    return BIRTH_SDF.format(dt);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                    return dateICM;
                }
            }
        }
        return dateICM;
    }

    public static void main(String[] args) throws CardException {
        System.out.println(SelfIssuedCardClaims.convertICMDate("August 13, 2008"));
    }
}

