package org.eclipse.higgins.icard.provider.cardspace.common;

import java.util.ArrayList;
import java.util.Iterator;

import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.icard.ICardExtensionEvent;
import org.eclipse.higgins.icard.IExtensionListener;
import org.eclipse.higgins.icard.IInformationCardExtension;
import org.eclipse.higgins.icard.io.IElement;

public class InformationCardExtension implements IInformationCardExtension {

	protected IElement element;

	protected boolean enabled;

	protected Object id;

	protected ArrayList listeners;

	/**
	 * @param element
	 *            XML extension element
	 * @param enabled
	 *            <code>true</code> if this element should be processed,
	 *            otherwise <code>false</code>
	 * @param id
	 *            Unique identifier of extension within a card. May be
	 *            <code>null</code> for new, not stored extension
	 */
	public InformationCardExtension(IElement element, boolean enabled, Object id) {
		this.element = element;
		this.enabled = enabled;
		this.id = id;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.icard.IInformationCardExtension#getElement()
	 */
	public IElement getElement() {
		return element;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.icard.IInformationCardExtension#isEnabled()
	 */
	public boolean isEnabled() {
		return enabled;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.icard.IInformationCardExtension#setElement(org.eclipse.higgins.icard.io.IElement)
	 */
	public void setElement(IElement extension) throws CardException {
		element = extension;
		setElementChangedEvent();
	}

	private void setElementChangedEvent() throws CardException {
		if (listeners != null && listeners.size() > 0) {
			ICardExtensionEvent event = new ICardExtensionEvent(this);
			Iterator lstnrs = listeners.iterator();
			while (lstnrs.hasNext()) {
				IExtensionListener listener = (IExtensionListener) lstnrs.next();
				listener.extensionElementChanged(event);
			}
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.icard.IInformationCardExtension#setEnabled(boolean)
	 */
	public void setEnabled(boolean enabled) throws CardException {
		this.enabled = enabled;
		setEnabledChangedEvent();
	}

	private void setEnabledChangedEvent() throws CardException {
		if (listeners != null && listeners.size() > 0) {
			ICardExtensionEvent event = new ICardExtensionEvent(this);
			Iterator lstnrs = listeners.iterator();
			while (lstnrs.hasNext()) {
				IExtensionListener listener = (IExtensionListener) lstnrs.next();
				listener.extensionEnabledChanged(event);
			}
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.icard.IInformationCardExtension#getId()
	 */
	public Object getId() {
		return id;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.icard.IInformationCardExtension#setId(java.lang.Object)
	 */
	public void setId(Object id) {
		this.id = id;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.icard.IInformationCardExtension#addListener(org.eclipse.higgins.icard.IExtensionListener)
	 */
	public synchronized void addListener(IExtensionListener listener) {
		if (listeners == null)
			listeners = new ArrayList();
		if (!listeners.contains(listener))
			listeners.add(listener);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.icard.IInformationCardExtension#removeListener(org.eclipse.higgins.icard.IExtensionListener)
	 */
	public void removeListener(IExtensionListener listener) {
		if (listeners != null) {
			if (listeners.contains(listener))
				listeners.remove(listener);
		}
	}

}
