/*******************************************************************************
 * Copyright (c) 2006-2007 IBM Corporation, Parity Communications Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *    Bjoern Assmann (IBM Corporation) - initial API and implementation
 *    abhi shelat
 ******************************************************************************/


package org.eclipse.higgins.icard.provider.cardspace.common;

import java.net.URI;
import java.security.cert.CertStore;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;

import org.eclipse.higgins.icard.IInformationCard;
import org.eclipse.higgins.icard.policy.ICardSpacePolicy;
//import org.eclipse.higgins.icard.provider.cardspace.common.utils.PPIDHelper;
import org.eclipse.higgins.sts.client.PPIDHelper;

public class PPIDCardSpacePolicy  extends CardSpacePolicy  implements ICardSpacePolicy{

	public X509Certificate [] x509Cert;

	byte[] ppid;
	
	private CertStore certStore;

	static final String PPID_CLAIM = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/privatepersonalidentifier";
	
	static final String TOKEN_TYPE = "urn:oasis:names:tc:SAML:1.0:assertion";
	static final URI TOKEN_TYPE_URI = URI.create(TOKEN_TYPE);

	public PPIDCardSpacePolicy(X509Certificate [] x509cert, 
			CertStore certStore, byte[] ppid) {
		this.x509Cert = x509cert;
		this.certStore = certStore;
		this.ppid = ppid;
		this.tokenType = TOKEN_TYPE;
		this.issuer = "http://schemas.xmlsoap.org/ws/2005/05/identity/issuer/self";
		requiredClaims.add(PPID_CLAIM);
	}

	public boolean isSatisfiedBy(IInformationCard icard) {
		log.trace("CardSpacePolicy::isSatisfiedBy(IInformationCard icard)");
		log.trace("icard: " + icard);

		// check issuer
		if (!issuer.equals(icard.getIssuer())) {
			log.trace("issuer not ok.");
			return false;
		}
		log.trace("issuer ok.");

		// check token type
		List suppTokenTypes = icard.getSupportedTokenTypes();
		log.trace("Supported token types: " + suppTokenTypes);

		if (suppTokenTypes == null || !suppTokenTypes.contains(TOKEN_TYPE_URI)) {
			log.trace("Token type: " + tokenType + " is not supported.");
		}

		// check ppid whether the ppid from the policy matches the ppid( x509cert, card)
//		TokenRequestFactory trf = new TokenRequestFactory();
		try
		{
			byte [] ppid_card =  PPIDHelper.computeClaimValuePPID
				( icard, 
				  x509Cert,
				  certStore);
					/*byte [] byteRPIdentifier = org.eclipse.higgins.sts.utilities.KeyGenHelper.generateRPIdentifier
				(new X509Certificate[] {x509Cert});
			byte [] ppid_card = org.eclipse.higgins.sts.utilities.KeyGenHelper.generatePPID
				(java.net.URI.create(icard.getID()), byteRPIdentifier);
			*/
			if( Arrays.equals( ppid, ppid_card))
			{
				return true;
			}
			else
			{
				return false;
			}
		} 
		catch (Exception e)
		{
			// TODO Auto-generated catch block
			e.printStackTrace();
			return false;
		}
	
	}
}
