package org.eclipse.higgins.icard.provider.cardspace.common;

import java.net.MalformedURLException;
import java.net.URL;

import org.apache.axiom.om.OMElement;
import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.icard.common.io.IOElement;
import org.eclipse.higgins.icard.common.utils.CardContext;
import org.eclipse.higgins.icard.io.IElement;
import org.eclipse.higgins.icard.policy.ISTSPrivacyPolicy;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.XMLUtils;
import org.w3c.dom.Element;

public class STSPrivacyPolicy implements ISTSPrivacyPolicy {

	protected IElement element;
	protected String version;
	protected String policyURL;

	public STSPrivacyPolicy(Element element) throws CardException {
		if (element == null)
			throw new CardException("Parameter \"element\" is null.");
		this.element = new IOElement();
		try {
			this.element.set(element);
		} catch (Exception e) {
			throw new CardException(e);
		}
		String ver = element.getAttribute(CardContext.IC_VERSION_ATTR);
		version = (ver != null) ? ver : "";
		policyURL = XMLUtils.getTextContent(element);
		try {
			new URL(policyURL);
		} catch (MalformedURLException e) {
			throw new CardException("URL of STS privacy policy is not valid", e);
		}
	}

	public STSPrivacyPolicy(String privacyPolicy) throws CardException {
		if (privacyPolicy == null)
			throw new CardException("Parameter \"privacyPolicy\" is null.");
		element = new IOElement();
		try {
			element.set(privacyPolicy);
		} catch (Exception e) {
			throw new CardException(e);
		}
		OMElement oe = null;
		try {
			oe = (OMElement) element.getAs(OMElement.class);
		} catch (Exception e) {
			throw new CardException(e);
		}
		String ver = oe.getAttributeValue(CardContext.QN_IC_VERSION_ATTR);
		version = (ver != null) ? ver : "";
		policyURL = oe.getText();
		try {
			new URL(policyURL);
		} catch (MalformedURLException e) {
			throw new CardException("URL of STS privacy policy is not valid", e);
		}
	}

	public IElement getPrivacyElement() {
		return element;
	}

	public String getPrivacyUrl() {
		return policyURL;
	}

	public String getPrivacyVersion() {
		return version;
	}

}
