package org.eclipse.higgins.icard.provider.cardspace.common;

import org.eclipse.higgins.icard.ITokenService;
import org.eclipse.higgins.icard.auth.ICredential;
import org.eclipse.higgins.icard.auth.ICredentialDescriptor;
import org.eclipse.higgins.icard.auth.ITokenServiceCredential;
import org.eclipse.higgins.icard.common.auth.TokenServiceCredential;
import org.w3c.dom.Element;

public class TSCredentialDescriptor implements ICredentialDescriptor {
	
	protected String type_;
	protected String displayCredentialHint_;
	protected ITokenServiceCredential credential_;
	protected Element credentialElement_ = null;
	
	protected ITokenService tokenService = null;
	
	public TSCredentialDescriptor(ITokenService tokenService) {
		this.tokenService = tokenService;
		initialize();
	}
	
	public TSCredentialDescriptor(String type, String displayCredentialHint, ITokenServiceCredential credential) {
		this.type_ = type;
		this.displayCredentialHint_ = displayCredentialHint;
		this.credential_ = credential;
	}
	
	private void initialize() {
		if (tokenService != null) {
			ICredentialDescriptor base = tokenService.getUserCredential();
			type_ = base.getType();
			displayCredentialHint_ = base.getDisplayCredentialHint();
			credentialElement_ = base.asXML();
			credential_ = new TokenServiceCredential(tokenService.getEndpointReference()).createCredential(base.getCredential());
		}
	}

	public Element asXML() {
		return credentialElement_;
	}

	public ICredential getCredential() {
		return credential_;
	}

	public String getDisplayCredentialHint() {
		return displayCredentialHint_;
	}

	public String getType() {
		return type_;
	}

}
