/**
 * Copyright (c) 2007 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Sergey Lyakhov - initial API and implementation
 */

package org.eclipse.higgins.icard.provider.cardspace.common;

import org.eclipse.higgins.icard.IEndpointReference;
import org.eclipse.higgins.icard.ITokenService;
import org.eclipse.higgins.icard.auth.ICredentialDescriptor;

public class TokenService implements ITokenService  {
	private IEndpointReference endpointReference_;

	private ICredentialDescriptor userCredential_;

	/**
	 * @param endpointReference
	 * @param userCredential
	 */
	public TokenService(EndpointReference endpointReference, CredentialDescriptor userCredential) {
		if (endpointReference == null)
			throw new IllegalArgumentException("Parameter \"endpointReference\" is null");
		if (userCredential == null)
			throw new IllegalArgumentException("Parameter \"userCredential\" is null");
		endpointReference_ = endpointReference;
		userCredential_ = userCredential;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.icard.ITokenService#getEndpointReference()
	 */
	public IEndpointReference getEndpointReference() {
		return endpointReference_;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.icard.ITokenService#getUserCredential()
	 */
	public ICredentialDescriptor getUserCredential() {
		return userCredential_;
	}

}
