/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.icard.provider.cardspace.common;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import javax.security.auth.callback.CallbackHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.icard.AuthenticationException;
import org.eclipse.higgins.icard.CUID;
import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.icard.ICard;
import org.eclipse.higgins.icard.ICardTemplate;
import org.eclipse.higgins.icard.IPolicy;
import org.eclipse.higgins.icard.ISimpleClaim;
import org.eclipse.higgins.icard.ISimpleClaimType;
import org.eclipse.higgins.icard.auth.ICredential;
import org.eclipse.higgins.icard.common.BasicCardProvider;
import org.eclipse.higgins.icard.common.ClaimValue;
import org.eclipse.higgins.icard.io.IElement;
import org.eclipse.higgins.icard.provider.cardspace.common.CardSpacePolicy;
import org.eclipse.higgins.icard.provider.cardspace.common.DummyManagedCard;
import org.eclipse.higgins.icard.provider.cardspace.common.ManagedCard;
import org.eclipse.higgins.icard.provider.cardspace.common.STSFaultException;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.CardCryptography;
import org.eclipse.higgins.iss.ICardSelectorService;
import org.eclipse.higgins.iss.IDisplayToken;
import org.eclipse.higgins.iss.IICardSelector;
import org.eclipse.higgins.iss.IIdentityToken;
import org.eclipse.higgins.iss.SelectionANDofORs;
import org.eclipse.higgins.iss.SelectionANDofORsElm;
import org.w3c.dom.Element;

public abstract class ManagedCardProvider
extends BasicCardProvider {
    private static Log log = LogFactory.getLog((Class)(class$org$eclipse$higgins$icard$provider$cardspace$common$ManagedCardProvider == null ? (class$org$eclipse$higgins$icard$provider$cardspace$common$ManagedCardProvider = ManagedCardProvider.class$("org.eclipse.higgins.icard.provider.cardspace.common.ManagedCardProvider")) : class$org$eclipse$higgins$icard$provider$cardspace$common$ManagedCardProvider));
    protected String rpKeyStore = null;
    protected String rpKeyStorePassword = null;
    protected String rpCertificateAlias = null;
    protected String relyingPartyURI = "urn://higgins-selector";
    protected X509Certificate rpCertificate = null;
    protected static final String APPLIES_TO_SELECTOR_ID = "appliesTo.selectorIdentifier";
    protected static final String APPLIES_TO_KEYSTORE = "appliesTo.keystoreFile";
    protected static final String APPLIES_TO_KEYSTORE_PASS = "appliesTo.keystorePassword";
    protected static final String APPLIES_TO_CERTIFICATE_ALIAS = "appliesTo.certificateAlias";
    protected static String strCertificate = "MIICVDCCAb2gAwIBAgIERWUHrzANBgkqhkiG9w0BAQUFADBQMQswCQYDVQQGEwJVUzEYMBYGA1UEChMPSUJNIENvcnBvcmF0aW9uMRUwEwYDVQQLEwxJQk0gUmVzZWFyY2gxEDAOBgNVBAMTB1Jvb3QgQ0EwHhcNMDYxMTIzMDIyOTU3WhcNMjYxMTE4MDIyOTU3WjBFMQswCQYDVQQGEwJVUzEQMA4GA1UEChMHRWNsaXBzZTEQMA4GA1UECxMHSGlnZ2luczESMBAGA1UEAxMJbG9jYWxob3N0MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCUFDtM2/nLEhSJqF7zqayW8gQ183KCiKME53VkSjl6C7O9J2hEiBMWsI9a+qBm13VWKvmTc3h3EsLaR/dOreXyCLKEwDIpwHojW3+i037OOxL6U3Ij094rqfHBCJP2xEyLNpPXdIioEgP5H6MTRPXShsBsTQ7bEhZs0QKyXwTNHwIDAQABo0YwRDAdBgNVHQ4EFgQUTHM9O3KViNYsvuGeg4eANMCFHuMwEwYDVR0lBAwwCgYIKwYBBQUHAwEwDgYDVR0PAQH/BAQDAgSwMA0GCSqGSIb3DQEBBQUAA4GBADkZZ34T637gwxp/EmRlRd4ru1Y2ribGoLRpY1icJYlyrUB3552f1K7r69EQxuwnyUnFYVhB+4ZnzhralkKtNs8UVo7RZHSE8jKWOi4YU3RXSqEHKs10ttQLLcHPuH4o9t2OJLeaVtaijbdicbxUEwqhgcNnNrQHe6+f5fgwzSYM";
    protected X509Certificate certificate = null;
    static /* synthetic */ Class class$org$eclipse$higgins$icard$provider$cardspace$common$ManagedCardProvider;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$eclipse$higgins$iss$IDisplayToken;
    static /* synthetic */ Class class$org$eclipse$higgins$icard$IManagedInformationCard;
    static /* synthetic */ Class class$org$w3c$dom$Element;

    protected void init(Hashtable config) {
        try {
            String selectorID;
            if (config.containsKey(APPLIES_TO_KEYSTORE)) {
                this.rpKeyStore = (String)config.get(APPLIES_TO_KEYSTORE);
            }
            if (config.containsKey(APPLIES_TO_KEYSTORE_PASS)) {
                this.rpKeyStorePassword = (String)config.get(APPLIES_TO_KEYSTORE_PASS);
            }
            if (config.containsKey(APPLIES_TO_CERTIFICATE_ALIAS)) {
                this.rpCertificateAlias = (String)config.get(APPLIES_TO_CERTIFICATE_ALIAS);
            }
            if (config.containsKey(APPLIES_TO_SELECTOR_ID) && (selectorID = (String)config.get(APPLIES_TO_SELECTOR_ID)) != null && selectorID.trim().length() > 0) {
                this.relyingPartyURI = selectorID;
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    public ICard getICardByCUID(CallbackHandler authHandler, CUID cuid, ICredential userCredential) throws AuthenticationException, CardException {
        ICard card = this.getICardByCUID(authHandler, cuid);
        if (card instanceof ManagedCard) {
            if (this.rpCertificate == null) {
                this.initFakeRelyingPartyCertificate();
            }
            ManagedCard mcard = (ManagedCard)card;
            CardSpacePolicy p = new CardSpacePolicy();
            p.setRequiredClaims(mcard.getSupportedClaimTypesUris());
            try {
                ICardSelectorService iss = ICardSelectorService.getInstance();
                IICardSelector s = iss.getICardSelector(authHandler, (IPolicy)p);
                SelectionANDofORs selection = new SelectionANDofORs();
                selection.action = this.relyingPartyURI;
                selection.add(new SelectionANDofORsElm(mcard.getCUID().toString(), 0, 0));
                selection.setCredential(userCredential);
                selection.sslCertChain = new X509Certificate[]{this.rpCertificate};
                LinkedList<ISimpleClaim> claims = new LinkedList<ISimpleClaim>();
                IIdentityToken t = s.getIdentityToken(selection);
                t.getAs(class$java$lang$String == null ? (class$java$lang$String = ManagedCardProvider.class$("java.lang.String")) : class$java$lang$String);
                IDisplayToken dt = (IDisplayToken)t.getAs(class$org$eclipse$higgins$iss$IDisplayToken == null ? (class$org$eclipse$higgins$iss$IDisplayToken = ManagedCardProvider.class$("org.eclipse.higgins.iss.IDisplayToken")) : class$org$eclipse$higgins$iss$IDisplayToken);
                Iterator itr = mcard.getSupportedClaimTypes();
                while (itr.hasNext()) {
                    ISimpleClaimType ct = (ISimpleClaimType)itr.next();
                    ISimpleClaim c = (ISimpleClaim)dt.getClaim(ct.getType());
                    if (c == null) {
                        c = new ClaimValue(ct, "");
                    }
                    claims.add(c);
                }
                mcard.setClaims(claims);
                return mcard;
            }
            catch (STSFaultException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CardException((Throwable)e);
            }
        }
        throw new CardException("Unsupported card type: " + card);
    }

    public ICardTemplate[] getCardCreationTemplates(CallbackHandler authHandler) {
        return null;
    }

    public ICardTemplate getCardCreationTemplatesByID(CallbackHandler authHandler, String ID) {
        return null;
    }

    public Class[] getSupportedTypes() {
        return new Class[]{class$org$eclipse$higgins$icard$IManagedInformationCard == null ? (class$org$eclipse$higgins$icard$IManagedInformationCard = ManagedCardProvider.class$("org.eclipse.higgins.icard.IManagedInformationCard")) : class$org$eclipse$higgins$icard$IManagedInformationCard};
    }

    protected X509Certificate getDefaultCertificate() {
        if (this.certificate == null) {
            try {
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                String strEncryptionCertificate = "-----BEGIN CERTIFICATE-----\n" + strCertificate + "\n-----END CERTIFICATE-----\n";
                ByteArrayInputStream streamCertificate = new ByteArrayInputStream(strEncryptionCertificate.getBytes());
                this.certificate = (X509Certificate)certificateFactory.generateCertificate(streamCertificate);
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
            }
        }
        return this.certificate;
    }

    public boolean canImportICard(CallbackHandler authHandler, IElement element) {
        if (element == null) {
            return false;
        }
        try {
            Element card = (Element)element.getAs(class$org$w3c$dom$Element == null ? (class$org$w3c$dom$Element = ManagedCardProvider.class$("org.w3c.dom.Element")) : class$org$w3c$dom$Element);
            if (card == null) {
                return false;
            }
            Element crd = null;
            crd = "Signature".equals(card.getLocalName()) ? CardCryptography.getCardFromSignedEnvelop(card, true, true) : card;
            DummyManagedCard c = new DummyManagedCard();
            c.initFromXML(crd);
            return true;
        }
        catch (Exception e) {
            log.warn((Object)e, (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private X509Certificate getCertificateFromKeystore() {
        X509Certificate res = null;
        FileInputStream fis = null;
        char[] pass = null;
        if (this.rpKeyStorePassword != null) {
            pass = this.rpKeyStorePassword.toCharArray();
        }
        File rpksFile = new File(this.rpKeyStore);
        fis = new FileInputStream(rpksFile);
        KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(fis, pass);
        res = (X509Certificate)keyStore.getCertificate(this.rpCertificateAlias);
        Object var7_7 = null;
        if (fis == null) return res;
        try {
            fis.close();
            return res;
        }
        catch (IOException e2) {
            log.warn((Object)e2, (Throwable)e2);
        }
        return res;
        {
            catch (Exception e) {
                log.error((Object)"Can not init the fake RP certificate from keystore", (Throwable)e);
                Object var7_8 = null;
                if (fis == null) return res;
                try {
                    fis.close();
                    return res;
                }
                catch (IOException e2) {
                    log.warn((Object)e2, (Throwable)e2);
                }
                return res;
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (fis == null) throw throwable;
            try {
                fis.close();
                throw throwable;
            }
            catch (IOException e2) {
                log.warn((Object)e2, (Throwable)e2);
            }
            throw throwable;
        }
    }

    private void initFakeRelyingPartyCertificate() {
        if (this.rpKeyStore == null) {
            log.warn((Object)"The file name of key store of fake RP certificate is not defined. The following configuration parameter should be defined: appliesTo.keystoreFile");
        } else if (this.rpCertificateAlias == null) {
            log.warn((Object)"The file name of key store of fake RP certificate is not defined. The following configuration parameter should be defined: appliesTo.keystoreFile");
        } else {
            this.rpCertificate = this.getCertificateFromKeystore();
        }
        if (this.rpCertificate == null) {
            this.rpCertificate = this.getCertificateFromKeystore();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

