/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.icard.provider.cardspace.common.io;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.security.auth.callback.PasswordCallback;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.icard.auth.ICredential;
import org.eclipse.higgins.icard.io.CardIOException;
import org.eclipse.higgins.icard.io.IElement;
import org.eclipse.higgins.icard.io.IFormatDescriptor;
import org.eclipse.higgins.icard.io.IInputProcessor;
import org.eclipse.higgins.icard.provider.cardspace.common.io.CRDSFormatProvider;
import org.eclipse.higgins.icard.provider.cardspace.common.io.IOICardElement;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.CardCryptography;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CRDSInputProcessor
implements IInputProcessor {
    private Log log = LogFactory.getLog((Class)(class$org$eclipse$higgins$icard$provider$cardspace$common$io$CRDSInputProcessor == null ? (class$org$eclipse$higgins$icard$provider$cardspace$common$io$CRDSInputProcessor = CRDSInputProcessor.class$("org.eclipse.higgins.icard.provider.cardspace.common.io.CRDSInputProcessor")) : class$org$eclipse$higgins$icard$provider$cardspace$common$io$CRDSInputProcessor));
    static /* synthetic */ Class class$org$eclipse$higgins$icard$provider$cardspace$common$io$CRDSInputProcessor;

    public IFormatDescriptor checkInput(InputStream is) {
        IFormatDescriptor res = null;
        if (CardCryptography.isEncriptedStore(is)) {
            res = CRDSFormatProvider.formatDescriptor;
        }
        return res;
    }

    public IElement[] process(InputStream is, ICredential credential) throws CardIOException {
        int i;
        Document cardBackup;
        IElement[] res = null;
        try {
            PasswordCallback pc = (PasswordCallback)credential.getCallbacks()[0];
            String password = new String(pc.getPassword());
            cardBackup = CardCryptography.decrypt(is, password);
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
            throw new CardIOException((Throwable)e);
        }
        ArrayList<IOICardElement> cardsList = new ArrayList<IOICardElement>();
        NodeList newCards = cardBackup.getDocumentElement().getChildNodes();
        for (i = 0; i < newCards.getLength(); ++i) {
            Node nd = newCards.item(i);
            if (nd.getNodeType() != 1) continue;
            Element card = (Element)nd;
            try {
                IOICardElement e = new IOICardElement();
                e.set(card);
                cardsList.add(e);
                continue;
            }
            catch (Exception e) {
                this.log.error((Object)e, (Throwable)e);
            }
        }
        res = new IElement[cardsList.size()];
        for (i = 0; i < res.length; ++i) {
            res[i] = (IElement)cardsList.get(i);
        }
        return res;
    }

    private void writeDoc(Document doc, OutputStream os) {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(os);
            transformer.transform(source, result);
            os.flush();
        }
        catch (Exception ex) {
            this.log.error((Object)ex, (Throwable)ex);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

