/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.icard.provider.cardspace.common.io;

import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.icard.auth.ICredential;
import org.eclipse.higgins.icard.io.CardIOException;
import org.eclipse.higgins.icard.io.IElement;
import org.eclipse.higgins.icard.io.IFormatDescriptor;
import org.eclipse.higgins.icard.io.IInputProcessor;
import org.eclipse.higgins.icard.provider.cardspace.common.CertificateNotValidException;
import org.eclipse.higgins.icard.provider.cardspace.common.SignatureNotValidException;
import org.eclipse.higgins.icard.provider.cardspace.common.io.CRDFormatProvider;
import org.eclipse.higgins.icard.provider.cardspace.common.io.IOICardElement;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.CardCryptography;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.CardUtils;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.XMLUtils;
import org.w3c.dom.Element;

public class CRDInputProcessor
implements IInputProcessor {
    private Log log;
    static /* synthetic */ Class class$0;

    public CRDInputProcessor() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.higgins.icard.provider.cardspace.common.io.CRDInputProcessor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.log = LogFactory.getLog((Class)clazz);
    }

    public IFormatDescriptor checkInput(InputStream is) throws CertificateNotValidException, SignatureNotValidException {
        IFormatDescriptor format = null;
        try {
            Element crd = CardCryptography.getCardFromSignedEnvelop(is);
            Element cardMetaData = null;
            if ("InformationCard".equals(crd.getLocalName())) {
                cardMetaData = crd;
            } else if ("RoamingInformationCard".equals(crd.getLocalName())) {
                cardMetaData = XMLUtils.getChildElement(crd, "http://schemas.xmlsoap.org/ws/2005/05/identity", "InformationCardMetaData");
            }
            if (cardMetaData != null && !CardUtils.isSelfIssued(cardMetaData)) {
                format = CRDFormatProvider.formatDescriptor;
            }
        }
        catch (CertificateNotValidException e) {
            throw e;
        }
        catch (SignatureNotValidException e) {
            throw e;
        }
        catch (Exception e) {
            format = null;
            this.log.trace((Object)e);
        }
        return format;
    }

    public IElement[] process(InputStream is, ICredential credential) throws CardIOException {
        IElement[] res = null;
        try {
            Element crd = CardCryptography.getCardFromSignedEnvelop(is);
            Element card = null;
            if ("InformationCard".equals(crd.getLocalName())) {
                card = crd;
            } else if ("RoamingInformationCard".equals(crd.getLocalName())) {
                card = XMLUtils.getChildElement(crd, "http://schemas.xmlsoap.org/ws/2005/05/identity", "InformationCardMetaData");
            }
            if (card != null) {
                if (!CardUtils.isSelfIssued(card)) {
                    IOICardElement e = new IOICardElement();
                    e.set(card);
                    res = new IElement[]{e};
                } else {
                    this.log.trace((Object)"Can't process self issued card element");
                }
            } else {
                this.log.trace((Object)"Can't find card element");
            }
        }
        catch (Exception e) {
            this.log.error((Object)e);
        }
        return res;
    }
}

