/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.icard.provider.cardspace.common.io;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.security.auth.callback.PasswordCallback;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.icard.auth.ICredential;
import org.eclipse.higgins.icard.io.CardIOException;
import org.eclipse.higgins.icard.io.IElement;
import org.eclipse.higgins.icard.io.IFormatDescriptor;
import org.eclipse.higgins.icard.io.IInputProcessor;
import org.eclipse.higgins.icard.provider.cardspace.common.io.CRDSFormatProvider;
import org.eclipse.higgins.icard.provider.cardspace.common.io.IOICardElement;
import org.eclipse.higgins.icard.provider.cardspace.common.utils.CardCryptography;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CRDSInputProcessor
implements IInputProcessor {
    private Log log;
    static /* synthetic */ Class class$0;

    public CRDSInputProcessor() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.higgins.icard.provider.cardspace.common.io.CRDSInputProcessor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.log = LogFactory.getLog((Class)clazz);
    }

    public IFormatDescriptor checkInput(InputStream is) {
        IFormatDescriptor res = null;
        if (CardCryptography.isEncriptedStore(is)) {
            res = CRDSFormatProvider.formatDescriptor;
        }
        return res;
    }

    public IElement[] process(InputStream is, ICredential credential) throws CardIOException {
        Document cardBackup;
        IElement[] res = null;
        try {
            PasswordCallback pc = (PasswordCallback)credential.getCallbacks()[0];
            String password = new String(pc.getPassword());
            cardBackup = CardCryptography.decrypt(is, password);
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
            throw new CardIOException((Throwable)e);
        }
        ArrayList<IOICardElement> cardsList = new ArrayList<IOICardElement>();
        NodeList newCards = cardBackup.getDocumentElement().getChildNodes();
        int i = 0;
        while (i < newCards.getLength()) {
            Node nd = newCards.item(i);
            if (nd.getNodeType() == 1) {
                Element card = (Element)nd;
                try {
                    IOICardElement e = new IOICardElement();
                    e.set(card);
                    cardsList.add(e);
                }
                catch (Exception e) {
                    this.log.error((Object)e, (Throwable)e);
                }
            }
            ++i;
        }
        res = new IElement[cardsList.size()];
        i = 0;
        while (i < res.length) {
            res[i] = (IElement)cardsList.get(i);
            ++i;
        }
        return res;
    }

    private void writeDoc(Document doc, OutputStream os) {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(os);
            transformer.transform(source, result);
            os.flush();
        }
        catch (Exception ex) {
            this.log.error((Object)ex, (Throwable)ex);
        }
    }
}

